/*
 * Decompiled with CFR 0.152.
 */
package marauroa.client.net;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marauroa.client.net.IPerceptionListener;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPObjectNotFoundException;
import marauroa.common.net.Serializable;
import marauroa.common.net.message.MessageS2CPerception;

public class PerceptionHandler {
    private static final Logger logger = Log4J.getLogger(PerceptionHandler.class);
    private IPerceptionListener listener;
    private List<MessageS2CPerception> previousPerceptions = new LinkedList<MessageS2CPerception>();
    private boolean synced = false;

    public PerceptionHandler() {
    }

    public PerceptionHandler(IPerceptionListener iPerceptionListener) {
        this();
        this.listener = iPerceptionListener;
    }

    public void apply(MessageS2CPerception messageS2CPerception, Map<RPObject.ID, RPObject> map) throws Exception {
        this.listener.onPerceptionBegin(messageS2CPerception.getPerceptionType(), messageS2CPerception.getPerceptionTimestamp());
        for (Serializable serializable : map.values()) {
            serializable.resetAddedAndDeleted();
        }
        if (messageS2CPerception.getPerceptionType() == 1) {
            try {
                this.previousPerceptions.clear();
                this.applyPerceptionAddedRPObjects(messageS2CPerception, map);
                this.applyPerceptionMyRPObject(messageS2CPerception, map);
                if (!this.synced) {
                    this.synced = true;
                    this.listener.onSynced();
                }
            }
            catch (Exception exception) {
                this.listener.onException(exception, messageS2CPerception);
            }
        } else if (messageS2CPerception.getPerceptionType() == 0) {
            try {
                this.applyPerceptionDeletedRPObjects(messageS2CPerception, map);
                this.applyPerceptionModifiedRPObjects(messageS2CPerception, map);
                this.applyPerceptionAddedRPObjects(messageS2CPerception, map);
                this.applyPerceptionMyRPObject(messageS2CPerception, map);
            }
            catch (Exception exception) {
                this.listener.onException(exception, messageS2CPerception);
            }
        } else {
            this.previousPerceptions.add(messageS2CPerception);
            Iterator<Serializable> iterator = this.previousPerceptions.iterator();
            while (iterator.hasNext()) {
                Serializable serializable;
                serializable = (MessageS2CPerception)iterator.next();
                try {
                    this.applyPerceptionDeletedRPObjects((MessageS2CPerception)serializable, map);
                    this.applyPerceptionModifiedRPObjects((MessageS2CPerception)serializable, map);
                    this.applyPerceptionAddedRPObjects((MessageS2CPerception)serializable, map);
                    this.applyPerceptionMyRPObject((MessageS2CPerception)serializable, map);
                }
                catch (Exception exception) {
                    this.listener.onException(exception, messageS2CPerception);
                }
                iterator.remove();
            }
            if (this.previousPerceptions.isEmpty()) {
                this.synced = true;
                this.listener.onSynced();
            } else {
                this.synced = false;
                this.listener.onUnsynced();
            }
        }
        this.listener.onPerceptionEnd(messageS2CPerception.getPerceptionType(), messageS2CPerception.getPerceptionTimestamp());
    }

    private void applyPerceptionAddedRPObjects(MessageS2CPerception messageS2CPerception, Map<RPObject.ID, RPObject> map) throws RPObjectNotFoundException {
        try {
            if (messageS2CPerception.getPerceptionType() == 1 && !this.listener.onClear()) {
                map.clear();
            }
            for (RPObject rPObject : messageS2CPerception.getAddedRPObjects()) {
                if (this.listener.onAdded(rPObject)) continue;
                map.put(rPObject.getID(), rPObject);
            }
        }
        catch (Exception exception) {
            logger.error("error in applyPerceptionAddedRPObjects", exception);
            throw new RPObjectNotFoundException(RPObject.INVALID_ID);
        }
    }

    private void applyPerceptionDeletedRPObjects(MessageS2CPerception messageS2CPerception, Map<RPObject.ID, RPObject> map) throws RPObjectNotFoundException {
        try {
            for (RPObject rPObject : messageS2CPerception.getDeletedRPObjects()) {
                if (this.listener.onDeleted(rPObject)) continue;
                map.remove(rPObject.getID());
            }
        }
        catch (Exception exception) {
            logger.error("error in applyPerceptionDeletedRPObjects", exception);
            throw new RPObjectNotFoundException(RPObject.INVALID_ID);
        }
    }

    private void applyPerceptionModifiedRPObjects(MessageS2CPerception messageS2CPerception, Map<RPObject.ID, RPObject> map) throws RPObjectNotFoundException {
        try {
            RPObject rPObject;
            for (RPObject rPObject2 : messageS2CPerception.getModifiedDeletedRPObjects()) {
                rPObject = map.get(rPObject2.getID());
                if (this.listener.onModifiedDeleted(rPObject, rPObject2)) continue;
                rPObject.applyDifferences(null, rPObject2);
            }
            for (RPObject rPObject2 : messageS2CPerception.getModifiedAddedRPObjects()) {
                rPObject = map.get(rPObject2.getID());
                if (rPObject == null) {
                    logger.warn("Missing base object for modified added RPObject with id " + rPObject2.getID());
                    continue;
                }
                if (this.listener.onModifiedAdded(rPObject, rPObject2)) continue;
                rPObject.applyDifferences(rPObject2, null);
            }
        }
        catch (RPObjectNotFoundException rPObjectNotFoundException) {
            logger.error("error in applyModifiedRPObjects", rPObjectNotFoundException);
            logger.error("world is [" + map.toString() + "]");
            throw rPObjectNotFoundException;
        }
        catch (Exception exception) {
            logger.error("error in applyModifiedRPObjects", exception);
            logger.error("world is [" + map.toString() + "]");
            throw new RPObjectNotFoundException(RPObject.INVALID_ID);
        }
    }

    private void applyPerceptionMyRPObject(MessageS2CPerception messageS2CPerception, Map<RPObject.ID, RPObject> map) throws RPObjectNotFoundException {
        try {
            RPObject rPObject = messageS2CPerception.getMyRPObjectAdded();
            RPObject rPObject2 = messageS2CPerception.getMyRPObjectDeleted();
            this.addMyRPObjectToWorldIfPrivate(rPObject, map);
            if (!this.listener.onMyRPObject(rPObject, rPObject2)) {
                RPObject.ID iD = null;
                if (rPObject != null) {
                    iD = rPObject.getID();
                }
                if (rPObject2 != null) {
                    iD = rPObject2.getID();
                }
                if (iD == null) {
                    return;
                }
                RPObject rPObject3 = map.get(iD);
                rPObject3.applyDifferences(rPObject, rPObject2);
            }
        }
        catch (Exception exception) {
            logger.error("error in applyPerceptionMyRPObject", exception);
            throw new RPObjectNotFoundException(RPObject.INVALID_ID);
        }
    }

    private void addMyRPObjectToWorldIfPrivate(RPObject rPObject, Map<RPObject.ID, RPObject> map) {
        if (rPObject == null) {
            return;
        }
        if (map.get(rPObject.getID()) != null) {
            return;
        }
        RPObject rPObject2 = (RPObject)rPObject.clone();
        if (!this.listener.onAdded(rPObject2)) {
            map.put(rPObject2.getID(), rPObject2);
        }
    }
}

