/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.crypto;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import marauroa.common.Log4J;
import marauroa.common.Logger;

public class Hash {
    private static Logger logger = Log4J.getLogger(Hash.class);
    private static String hex = "0123456789ABCDEF";
    private static MessageDigest md;
    private static SecureRandom random;

    public static final synchronized byte[] hash(String string) {
        try {
            return Hash.hash(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error(unsupportedEncodingException, unsupportedEncodingException);
            return null;
        }
    }

    public static final synchronized int hashLength() {
        return md.getDigestLength();
    }

    public static final synchronized byte[] hash(byte[] byArray) {
        md.reset();
        md.update(byArray);
        return md.digest();
    }

    public static final byte[] xor(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return null;
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    public static final int compare(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return byArray.length - byArray2.length;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return byArray[i] - byArray2[i];
        }
        return 0;
    }

    public static final synchronized byte[] random(int n) {
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        return byArray;
    }

    public static final String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(hex.charAt(by >>> 4 & 0xF));
            stringBuilder.append(hex.charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }

    public static final byte[] bigIntToBytes(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] != 1) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - 1];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray[i + 1];
        }
        return byArray2;
    }

    public static final BigInteger bytesToBigInt(byte[] byArray) {
        if (byArray[0] > 1) {
            return new BigInteger(byArray);
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 1;
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i + 1] = byArray[i];
        }
        return new BigInteger(byArray2);
    }

    static {
        try {
            md = MessageDigest.getInstance("MD5");
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
    }
}

