/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.crypto;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public final class Sha512Crypt {
    private static final String sha512_salt_prefix = "$6$";
    private static final String sha512_rounds_prefix = "rounds=";
    private static final int SALT_LEN_MAX = 16;
    private static final int ROUNDS_DEFAULT = 5000;
    private static final int ROUNDS_MIN = 1000;
    private static final int ROUNDS_MAX = 999999999;
    private static final String SALTCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private static final String itoa64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    private static MessageDigest getSHA512() {
        try {
            return MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static final String Sha512_crypt(String string, String string2, int n) {
        int n2;
        byte[] byArray;
        Object object;
        MessageDigest messageDigest = Sha512Crypt.getSHA512();
        MessageDigest messageDigest2 = Sha512Crypt.getSHA512();
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        int n3 = 5000;
        if (string2 != null) {
            if (string2.startsWith(sha512_salt_prefix)) {
                string2 = string2.substring(sha512_salt_prefix.length());
            }
            if (string2.startsWith(sha512_rounds_prefix)) {
                object = string2.substring(sha512_rounds_prefix.length(), string2.indexOf(36));
                int n4 = Integer.valueOf((String)object);
                string2 = string2.substring(string2.indexOf(36) + 1);
                n3 = Math.max(1000, Math.min(n4, 999999999));
            }
            if (string2.length() > 16) {
                string2 = string2.substring(0, 16);
            }
        } else {
            object = new Random();
            StringBuffer stringBuffer = new StringBuffer();
            while (stringBuffer.length() < 16) {
                int n5 = (int)(((Random)object).nextFloat() * (float)SALTCHARS.length());
                stringBuffer.append(SALTCHARS.substring(n5, n5 + 1));
            }
            string2 = stringBuffer.toString();
        }
        if (n != 0) {
            n3 = Math.max(1000, Math.min(n, 999999999));
        }
        try {
            object = string.getBytes("UTF-8");
            byArray = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        messageDigest.reset();
        messageDigest.update((byte[])object, 0, ((Object)object).length);
        messageDigest.update(byArray, 0, byArray.length);
        messageDigest2.reset();
        messageDigest2.update((byte[])object, 0, ((Object)object).length);
        messageDigest2.update(byArray, 0, byArray.length);
        messageDigest2.update((byte[])object, 0, ((Object)object).length);
        byte[] byArray4 = messageDigest2.digest();
        for (n2 = ((Object)object).length; n2 > 64; n2 -= 64) {
            messageDigest.update(byArray4, 0, 64);
        }
        messageDigest.update(byArray4, 0, n2);
        for (n2 = ((Object)object).length; n2 > 0; n2 >>= 1) {
            if ((n2 & 1) != 0) {
                messageDigest.update(byArray4, 0, 64);
                continue;
            }
            messageDigest.update((byte[])object, 0, ((Object)object).length);
        }
        byArray4 = messageDigest.digest();
        messageDigest2.reset();
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            messageDigest2.update((byte[])object, 0, ((Object)object).length);
        }
        byte[] byArray5 = messageDigest2.digest();
        byArray2 = new byte[((Object)object).length];
        int n6 = 0;
        for (n2 = byArray2.length; n2 >= 64; n2 -= 64) {
            System.arraycopy(byArray5, 0, byArray2, n6, 64);
            n6 += 64;
        }
        System.arraycopy(byArray5, 0, byArray2, n6, n2);
        messageDigest2.reset();
        for (n2 = 0; n2 < 16 + (byArray4[0] & 0xFF); ++n2) {
            messageDigest2.update(byArray, 0, byArray.length);
        }
        byArray5 = messageDigest2.digest();
        byArray3 = new byte[byArray.length];
        n6 = 0;
        for (n2 = byArray3.length; n2 >= 64; n2 -= 64) {
            System.arraycopy(byArray5, 0, byArray3, n6, 64);
            n6 += 64;
        }
        System.arraycopy(byArray5, 0, byArray3, n6, n2);
        for (n2 = 0; n2 < n3; ++n2) {
            messageDigest.reset();
            if ((n2 & 1) != 0) {
                messageDigest.update(byArray2, 0, ((Object)object).length);
            } else {
                messageDigest.update(byArray4, 0, 64);
            }
            if (n2 % 3 != 0) {
                messageDigest.update(byArray3, 0, byArray.length);
            }
            if (n2 % 7 != 0) {
                messageDigest.update(byArray2, 0, ((Object)object).length);
            }
            if ((n2 & 1) != 0) {
                messageDigest.update(byArray4, 0, 64);
            } else {
                messageDigest.update(byArray2, 0, ((Object)object).length);
            }
            byArray4 = messageDigest.digest();
        }
        StringBuffer stringBuffer = new StringBuffer(sha512_salt_prefix);
        if (n3 != 5000) {
            stringBuffer.append(sha512_rounds_prefix);
            stringBuffer.append(n3);
            stringBuffer.append("$");
        }
        stringBuffer.append(string2);
        stringBuffer.append("$");
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[0], byArray4[21], byArray4[42], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[22], byArray4[43], byArray4[1], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[44], byArray4[2], byArray4[23], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[3], byArray4[24], byArray4[45], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[25], byArray4[46], byArray4[4], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[47], byArray4[5], byArray4[26], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[6], byArray4[27], byArray4[48], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[28], byArray4[49], byArray4[7], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[50], byArray4[8], byArray4[29], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[9], byArray4[30], byArray4[51], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[31], byArray4[52], byArray4[10], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[53], byArray4[11], byArray4[32], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[12], byArray4[33], byArray4[54], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[34], byArray4[55], byArray4[13], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[56], byArray4[14], byArray4[35], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[15], byArray4[36], byArray4[57], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[37], byArray4[58], byArray4[16], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[59], byArray4[17], byArray4[38], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[18], byArray4[39], byArray4[60], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[40], byArray4[61], byArray4[19], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit(byArray4[62], byArray4[20], byArray4[41], 4));
        stringBuffer.append(Sha512Crypt.b64_from_24bit((byte)0, (byte)0, byArray4[63], 2));
        messageDigest.reset();
        return stringBuffer.toString();
    }

    private static final String b64_from_24bit(byte by, byte by2, byte by3, int n) {
        int n2 = (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
        StringBuffer stringBuffer = new StringBuffer();
        while (--n >= 0) {
            stringBuffer.append(itoa64.charAt(n2 & 0x3F));
            n2 >>>= 6;
        }
        return stringBuffer.toString();
    }

    public static final boolean verifyPassword(String string, String string2) {
        if (string2.startsWith(sha512_salt_prefix)) {
            String string3 = string2.substring(0, string2.lastIndexOf("$"));
            return string2.equals(Sha512Crypt.Sha512_crypt(string, string3, 0));
        }
        throw new RuntimeException("Bad sha512CryptText");
    }

    public static final boolean verifyHashTextFormat(String string) {
        if (!string.startsWith(sha512_salt_prefix)) {
            return false;
        }
        if ((string = string.substring(sha512_salt_prefix.length())).startsWith(sha512_rounds_prefix)) {
            String string2 = string.substring(sha512_rounds_prefix.length(), string.indexOf(36));
            try {
                Integer.valueOf(string2).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            string = string.substring(string.indexOf(36) + 1);
        }
        if (string.indexOf(36) > 17) {
            return false;
        }
        string = string.substring(string.indexOf(36) + 1);
        for (int i = 0; i < string.length(); ++i) {
            if (itoa64.indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    private static void selfTest() {
        System.out.println("Verify Password Test: " + Sha512Crypt.verifyPassword("Hello world!", "$6$saltstring$svn8UoSVapNtMuq1ukKS4tPQd8iKwSMHWjl/O817G3uBnIFNjnQJuesI68u4OTLiBFdcbYEdFCoEOfaS35inz1"));
        String[] stringArray = new String[]{"$6$saltstring", "Hello world!", "$6$saltstring$svn8UoSVapNtMuq1ukKS4tPQd8iKwSMHWjl/O817G3uBnIFNjnQJuesI68u4OTLiBFdcbYEdFCoEOfaS35inz1", "$6$rounds=10000$saltstringsaltstring", "Hello world!", "$6$rounds=10000$saltstringsaltst$OW1/O6BYHV6BcXZu8QVeXbDWra3Oeqh0sbHbbMCVNSnCM/UrjmM0Dp8vOuZeHBy/YTBmSK6H9qs/y3RnOaw5v.", "$6$rounds=5000$toolongsaltstring", "This is just a test", "$6$rounds=5000$toolongsaltstrin$lQ8jolhgVRVhY4b5pZKaysCLi0QBxGoNeKQzQ3glMhwllF7oGDZxUhx1yxdYcz/e1JSbq3y6JMxxl8audkUEm0", "$6$rounds=1400$anotherlongsaltstring", "a very much longer text to encrypt.  This one even stretches over morethan one line.", "$6$rounds=1400$anotherlongsalts$POfYwTEok97VWcjxIiSOjiykti.o/pQs.wPvMxQ6Fm7I6IoYN3CmLs66x9t0oSwbtEW7o7UmJEiDwGqd8p4ur1", "$6$rounds=77777$short", "we have a short salt string but not a short password", "$6$rounds=77777$short$WuQyW2YR.hBNpjjRhpYD/ifIw05xdfeEyQoMxIXbkvr0gge1a1x3yRULJ5CCaUeOxFmtlcGZelFl5CxtgfiAc0", "$6$rounds=123456$asaltof16chars..", "a short string", "$6$rounds=123456$asaltof16chars..$BtCwjqMJGx5hrJhZywWvt0RLE8uZ4oPwcelCjmw2kSYu.Ec6ycULevoBK25fs2xXgMNrCzIMVcgEJAstJeonj1", "$6$rounds=10$roundstoolow", "the minimum number is still observed", "$6$rounds=1000$roundstoolow$kUMsbe306n21p9R.FRkW3IGn.S9NPN0x50YhH1xhLsPuWGsUSklZt58jaTfF4ZEQpyUNGc0dqbpBYYBaHHrsX."};
        System.out.println("Starting Sha512Crypt tests now...");
        for (int i = 0; i < 7; ++i) {
            String string = Sha512Crypt.Sha512_crypt(stringArray[i * 3 + 1], stringArray[i * 3], 0);
            System.out.println("test " + i + " result is:" + string);
            System.out.println("test " + i + " should be:" + stringArray[i * 3 + 2]);
            if (string.equals(stringArray[i * 3 + 2])) {
                System.out.println("Passed well");
                continue;
            }
            System.out.println("Failed Badly");
        }
    }

    public static void main(String[] stringArray) {
        Sha512Crypt.selfTest();
    }
}

