/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.Attributes;
import marauroa.common.game.Definition;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.IRPZone;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPClass;
import marauroa.common.game.RPEvent;
import marauroa.common.game.RPLink;
import marauroa.common.game.RPSlot;
import marauroa.common.game.SlotAlreadyAddedException;
import marauroa.common.game.SlotOwner;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.Serializable;

public class RPObject
extends SlotOwner {
    private static final Logger logger = Log4J.getLogger(RPObject.class);
    private boolean modified;
    private List<RPEvent> events;
    private List<RPLink> links;
    private Map<String, Attributes> maps;
    private SlotOwner container;
    private RPSlot containerSlot;
    private List<String> addedSlots;
    private List<String> deletedSlots;
    private List<String> addedLinks;
    private List<String> deletedLinks;
    private List<String> addedMaps;
    private List<String> deletedMaps;
    public static final ID INVALID_ID = new ID(-1, "");
    private static final List<RPEvent> EMPTY = Collections.unmodifiableList(new ArrayList());
    private boolean hidden;
    private boolean storable;

    public RPObject() {
        super(RPClass.getBaseRPObjectDefault());
        this.clear();
    }

    public RPObject(RPClass rPClass) {
        super(rPClass);
        this.clear();
    }

    public RPObject(String string) {
        super(RPClass.getRPClass(string));
        RPClass rPClass = RPClass.getRPClass(string);
        if (rPClass == null) {
            logger.error("RPClass '" + string + "' was not defined.", new Throwable());
        }
    }

    RPObject(boolean bl) {
        super(RPClass.getBaseRPObjectDefault());
        if (bl) {
            this.clear();
        }
    }

    private void clear() {
        this.slots = null;
        this.addedSlots = null;
        this.deletedSlots = null;
        this.events = null;
        this.links = null;
        this.addedLinks = null;
        this.deletedLinks = null;
        this.maps = null;
        this.addedMaps = null;
        this.deletedMaps = null;
        this.modified = false;
        this.container = null;
        this.containerSlot = null;
        this.hidden = false;
        this.storable = false;
    }

    public RPObject(RPObject rPObject) {
        this();
        this.fill(rPObject);
    }

    public void fill(RPObject rPObject) {
        Cloneable cloneable;
        super.fill(rPObject);
        this.hidden = rPObject.hidden;
        this.storable = rPObject.storable;
        this.modified = rPObject.modified;
        this.container = rPObject.container;
        this.containerSlot = rPObject.containerSlot;
        if (rPObject.events != null) {
            if (this.events == null) {
                this.events = new LinkedList<RPEvent>();
            }
            for (RPEvent object : rPObject.events) {
                cloneable = (RPEvent)object.clone();
                ((RPEvent)cloneable).setOwner(this);
                this.events.add((RPEvent)cloneable);
            }
        }
        if (rPObject.links != null) {
            if (this.links == null) {
                this.links = new LinkedList<RPLink>();
            }
            for (RPLink rPLink : rPObject.links) {
                cloneable = (RPLink)rPLink.clone();
                ((RPLink)cloneable).setOwner(this);
                this.links.add((RPLink)cloneable);
            }
        }
        if (rPObject.maps != null) {
            this.maps = new HashMap<String, Attributes>();
            try {
                for (Map.Entry entry : rPObject.maps.entrySet()) {
                    cloneable = (Attributes)((Attributes)entry.getValue()).clone();
                    this.maps.put((String)entry.getKey(), (Attributes)cloneable);
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                logger.error(cloneNotSupportedException, cloneNotSupportedException);
            }
        }
        if (rPObject.addedSlots != null) {
            if (this.addedSlots == null) {
                this.addedSlots = new LinkedList<String>();
            }
            for (String string : rPObject.addedSlots) {
                this.addedSlots.add(string);
            }
        }
        if (rPObject.deletedSlots != null) {
            if (this.deletedSlots == null) {
                this.deletedSlots = new LinkedList<String>();
            }
            for (String string : rPObject.deletedSlots) {
                this.deletedSlots.add(string);
            }
        }
        if (rPObject.addedLinks != null) {
            if (this.addedLinks == null) {
                this.addedLinks = new LinkedList<String>();
            }
            for (String string : rPObject.addedLinks) {
                this.addedLinks.add(string);
            }
        }
        if (rPObject.deletedLinks != null) {
            if (this.deletedLinks == null) {
                this.deletedLinks = new LinkedList<String>();
            }
            for (String string : rPObject.deletedLinks) {
                this.deletedLinks.add(string);
            }
        }
        if (rPObject.addedMaps != null) {
            if (this.addedMaps == null) {
                this.addedMaps = new LinkedList<String>();
            }
            for (String string : rPObject.addedMaps) {
                this.addedMaps.add(string);
            }
        }
        if (rPObject.deletedMaps != null) {
            if (this.deletedMaps == null) {
                this.deletedMaps = new LinkedList<String>();
            }
            for (String string : rPObject.deletedMaps) {
                this.deletedMaps.add(string);
            }
        }
    }

    RPObject(ID iD) {
        this();
        this.setID(iD);
    }

    public ID getID() {
        return new ID(this);
    }

    public void setID(ID iD) {
        this.put("id", iD.getObjectID());
        if (iD.getZoneID() != null) {
            this.put("zoneid", iD.getZoneID());
        }
    }

    public void hide() {
        this.hidden = true;
    }

    public void unhide() {
        this.hidden = false;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void store() {
        this.storable = true;
    }

    public void unstore() {
        this.storable = false;
    }

    public boolean isStorable() {
        return this.storable;
    }

    public boolean isContained() {
        return this.container != null;
    }

    @Override
    public void setContainer(SlotOwner slotOwner, RPSlot rPSlot) {
        this.container = slotOwner;
        this.containerSlot = rPSlot;
    }

    public RPObject getContainer() {
        return (RPObject)this.container;
    }

    public RPObject getBaseContainer() {
        if (this.container != null) {
            return (RPObject)this.container.getContainerBaseOwner();
        }
        return this;
    }

    @Override
    public SlotOwner getContainerOwner() {
        return this.container;
    }

    @Override
    public SlotOwner getContainerBaseOwner() {
        if (this.container != null) {
            return this.container.getContainerBaseOwner();
        }
        return this;
    }

    public RPSlot getContainerSlot() {
        return this.containerSlot;
    }

    public RPObject getFromSlots(int n) {
        if (this.isContained() && this.getInt("id") == n) {
            return this;
        }
        RPObject rPObject = null;
        if (this.slots != null) {
            for (RPSlot rPSlot : this.slots) {
                for (RPObject rPObject2 : rPSlot) {
                    rPObject = rPObject2.getFromSlots(n);
                    if (rPObject == null) continue;
                    return rPObject;
                }
            }
        }
        return rPObject;
    }

    @Override
    public void addSlot(String string) throws SlotAlreadyAddedException {
        super.addSlot(string);
        if (this.addedSlots == null) {
            this.addedSlots = new LinkedList<String>();
        }
        this.addedSlots.add(string);
        this.modified = true;
    }

    @Override
    public void addSlot(RPSlot rPSlot) throws SlotAlreadyAddedException {
        super.addSlot(rPSlot);
        if (this.addedSlots == null) {
            this.addedSlots = new LinkedList<String>();
        }
        this.addedSlots.add(rPSlot.getName());
        this.modified = true;
    }

    @Override
    public RPSlot removeSlot(String string) {
        Iterator<RPSlot> iterator = this.slotsIterator();
        while (iterator.hasNext()) {
            RPSlot rPSlot = iterator.next();
            if (!string.equals(rPSlot.getName())) continue;
            if (this.deletedSlots == null) {
                this.deletedSlots = new LinkedList<String>();
            }
            this.deletedSlots.add(string);
            this.modified = true;
            iterator.remove();
            return rPSlot;
        }
        return null;
    }

    public void addEvent(RPEvent rPEvent) {
        rPEvent.setOwner(this);
        if (this.events == null) {
            this.events = new LinkedList<RPEvent>();
        }
        this.events.add(rPEvent);
    }

    public void clearEvents() {
        if (this.events != null) {
            this.events.clear();
        }
    }

    public Iterator<RPEvent> eventsIterator() {
        if (this.events == null) {
            return EMPTY.iterator();
        }
        return this.events.iterator();
    }

    public List<RPEvent> events() {
        if (this.events == null) {
            return EMPTY;
        }
        return Collections.unmodifiableList(this.events);
    }

    public void addLink(String string, RPObject rPObject) {
        if (this.hasLink(string)) {
            throw new SlotAlreadyAddedException(string);
        }
        RPLink rPLink = new RPLink(string, rPObject);
        rPLink.setOwner(this);
        if (this.links == null) {
            this.links = new LinkedList<RPLink>();
        }
        this.links.add(rPLink);
        if (this.addedLinks == null) {
            this.addedLinks = new LinkedList<String>();
        }
        this.addedLinks.add(string);
        this.modified = true;
    }

    public void addLink(RPLink rPLink) {
        if (this.hasLink(rPLink.getName())) {
            throw new SlotAlreadyAddedException(rPLink.getName());
        }
        rPLink.setOwner(this);
        if (this.links == null) {
            this.links = new LinkedList<RPLink>();
        }
        this.links.add(rPLink);
        if (this.addedLinks == null) {
            this.addedLinks = new LinkedList<String>();
        }
        this.addedLinks.add(rPLink.getName());
        this.modified = true;
    }

    public RPLink getLink(String string) {
        if (this.links == null) {
            return null;
        }
        for (RPLink rPLink : this.links) {
            if (!string.equals(rPLink.getName())) continue;
            return rPLink;
        }
        return null;
    }

    public RPObject getLinkedObject(String string) {
        RPLink rPLink = this.getLink(string);
        if (rPLink != null) {
            return rPLink.getObject();
        }
        return null;
    }

    public boolean hasLink(String string) {
        return this.getLink(string) != null;
    }

    public RPLink removeLink(String string) {
        if (this.links == null) {
            return null;
        }
        Iterator<RPLink> iterator = this.links.iterator();
        while (iterator.hasNext()) {
            RPLink rPLink = iterator.next();
            if (!string.equals(rPLink.getName())) continue;
            if (this.deletedLinks == null) {
                this.deletedLinks = new LinkedList<String>();
            }
            this.deletedLinks.add(string);
            this.modified = true;
            iterator.remove();
            return rPLink;
        }
        return null;
    }

    public void put(String string, String string2, String string3) {
        if (this.maps == null || !this.maps.containsKey(string)) {
            this.addMap(string);
        }
        if (string2.equals("id") || string2.equals("zoneid")) {
            throw new IllegalArgumentException("\"id\" and \"zoneid\" are reserved keys that may not be used.");
        }
        this.maps.get(string).put(string2, string3);
        if (this.addedMaps == null) {
            this.addedMaps = new LinkedList<String>();
        }
        if (!this.addedMaps.contains(string)) {
            this.addedMaps.add(string);
        }
    }

    public void put(String string, String string2, int n) {
        this.put(string, string2, Integer.toString(n));
    }

    public void put(String string, String string2, double d) {
        this.put(string, string2, Double.toString(d));
    }

    public void put(String string, String string2, boolean bl) {
        this.put(string, string2, Boolean.toString(bl));
    }

    public boolean has(String string, String string2) {
        if (this.maps == null || !this.maps.containsKey(string)) {
            return false;
        }
        return this.maps.get(string).has(string2);
    }

    public String get(String string, String string2) {
        if (this.maps == null || !this.maps.containsKey(string)) {
            Definition definition = this.getRPClass().getDefinition(Definition.DefinitionClass.STATIC, string);
            if (definition != null) {
                return definition.getValue();
            }
            return null;
        }
        return this.maps.get(string).get(string2);
    }

    public int getInt(String string, String string2) {
        if (this.maps == null || !this.maps.containsKey(string)) {
            throw new IllegalArgumentException("Map " + string + " not found");
        }
        return this.maps.get(string).getInt(string2);
    }

    public double getDouble(String string, String string2) {
        if (this.maps == null || !this.maps.containsKey(string)) {
            throw new IllegalArgumentException("Map " + string + " not found");
        }
        return this.maps.get(string).getDouble(string2);
    }

    public boolean getBoolean(String string, String string2) {
        if (this.maps == null || !this.maps.containsKey(string)) {
            throw new IllegalArgumentException("Map " + string + " not found");
        }
        return this.maps.get(string).getBool(string2);
    }

    public Map<String, String> getMap(String string) {
        if (this.maps != null && this.maps.containsKey(string)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Attributes attributes = this.maps.get(string);
            for (String string2 : attributes) {
                if (string2.equals("id") || string2.equals("zoneid")) continue;
                hashMap.put(string2, attributes.get(string2));
            }
            return hashMap;
        }
        return null;
    }

    public Attributes removeMap(String string) {
        if (this.maps != null && this.maps.containsKey(string)) {
            Attributes attributes = this.maps.get(string);
            if (this.deletedMaps == null) {
                this.deletedMaps = new LinkedList<String>();
            }
            this.deletedMaps.add(string);
            this.modified = true;
            return attributes;
        }
        return null;
    }

    public void addMap(String string) {
        if (this.maps == null) {
            this.maps = new HashMap<String, Attributes>();
        }
        if (this.maps.containsKey(string)) {
            throw new SlotAlreadyAddedException(string);
        }
        if (this.getRPClass() != null && this.getRPClass().getDefinition(Definition.DefinitionClass.ATTRIBUTE, string).getType() != Definition.Type.MAP) {
            throw new IllegalArgumentException("The type of the attribute " + string + " is not MAP type.");
        }
        RPObject rPObject = new RPObject();
        rPObject.setID(INVALID_ID);
        this.maps.put(string, rPObject);
        if (this.addedMaps == null) {
            this.addedMaps = new LinkedList<String>();
        }
        this.addedMaps.add(string);
        this.modified = true;
    }

    public String remove(String string, String string2) {
        if (string2.equals("id") || string2.equals("zoneid")) {
            throw new IllegalArgumentException("\"id\" and \"zoneid\" are reserved keys that may not be used");
        }
        if (this.maps != null && this.maps.containsKey(string) && this.maps.get(string).has(string2)) {
            this.modified = true;
            if (this.deletedMaps == null) {
                this.deletedMaps = new LinkedList<String>();
            }
            if (!this.deletedMaps.contains(string)) {
                this.deletedMaps.add(string);
            }
            return this.maps.get(string).remove(string2);
        }
        return null;
    }

    public Map<String, Map<String, String>> maps() {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        if (this.maps != null) {
            for (String string : this.maps.keySet()) {
                hashMap.put(string, this.getMap(string));
            }
        }
        return hashMap;
    }

    public boolean hasMap(String string) {
        return this.maps != null && this.maps.containsKey(string);
    }

    public boolean containsKey(String string, String string2) {
        if (this.hasMap(string)) {
            return this.getMap(string).containsKey(string2);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("RPObject with ");
        stringBuilder.append(super.toString());
        if (this.maps != null && !this.maps.isEmpty()) {
            stringBuilder.append(" with maps");
            for (Map.Entry object : this.maps.entrySet()) {
                stringBuilder.append(" " + (String)object.getKey());
                stringBuilder.append("=[" + ((Attributes)object.getValue()).toAttributeString() + "]");
            }
        }
        if (this.links != null && !this.links.isEmpty()) {
            stringBuilder.append(" and RPLink ");
            for (RPLink rPLink : this.links) {
                stringBuilder.append("[" + rPLink.toString() + "]");
            }
        }
        if (this.events != null && !this.events.isEmpty()) {
            stringBuilder.append(" and RPEvents ");
            for (RPEvent rPEvent : this.events) {
                stringBuilder.append("[" + rPEvent.toString() + "]");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        try {
            this.writeObject(outputSerializer, DetailLevel.NORMAL);
        }
        catch (NullPointerException nullPointerException) {
            logger.warn(this, nullPointerException);
            throw nullPointerException;
        }
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer, DetailLevel detailLevel) throws IOException {
        Definition definition;
        super.writeObject(outputSerializer, detailLevel);
        if (detailLevel == DetailLevel.FULL) {
            outputSerializer.write((byte)1);
            outputSerializer.write((byte)(this.hidden ? 1 : 0));
            outputSerializer.write((byte)(this.storable ? 1 : 0));
        } else {
            outputSerializer.write((byte)0);
        }
        this.serializeRPSlots(outputSerializer, detailLevel);
        int n = 0;
        if (this.links != null) {
            for (RPLink object : this.links) {
                if (!this.shouldSerialize(Definition.DefinitionClass.RPLINK, object.getName(), detailLevel)) continue;
                ++n;
            }
            outputSerializer.write(n);
            for (RPLink rPLink : this.links) {
                definition = this.getRPClass().getDefinition(Definition.DefinitionClass.RPLINK, rPLink.getName());
                if (!this.shouldSerialize(definition, detailLevel)) continue;
                rPLink.writeObject(outputSerializer, detailLevel);
            }
        } else {
            outputSerializer.write(0);
        }
        if (outputSerializer.getProtocolVersion() >= 33) {
            n = 0;
            if (this.maps != null) {
                for (Map.Entry entry : this.maps.entrySet()) {
                    definition = this.getRPClass().getDefinition(Definition.DefinitionClass.ATTRIBUTE, (String)entry.getKey());
                    if (!this.shouldSerialize(definition, detailLevel)) continue;
                    ++n;
                }
                outputSerializer.write(n);
                for (String string : this.maps.keySet()) {
                    definition = this.getRPClass().getDefinition(Definition.DefinitionClass.ATTRIBUTE, string);
                    if (!this.shouldSerialize(definition, detailLevel)) continue;
                    outputSerializer.write(string);
                }
                for (String string : this.maps.keySet()) {
                    definition = this.getRPClass().getDefinition(Definition.DefinitionClass.ATTRIBUTE, string);
                    if (!this.shouldSerialize(definition, detailLevel)) continue;
                    this.maps.get(string).writeObject(outputSerializer, detailLevel);
                }
            } else {
                outputSerializer.write(0);
            }
        }
        n = 0;
        if (this.events != null) {
            for (RPEvent rPEvent : this.events) {
                if (!this.shouldSerialize(Definition.DefinitionClass.RPEVENT, rPEvent.getName(), detailLevel)) continue;
                ++n;
            }
            outputSerializer.write(n);
            for (RPEvent rPEvent : this.events) {
                definition = this.getRPClass().getDefinition(Definition.DefinitionClass.RPEVENT, rPEvent.getName());
                if (!this.shouldSerialize(definition, detailLevel)) continue;
                rPEvent.writeObject(outputSerializer, detailLevel);
            }
        } else {
            outputSerializer.write(0);
        }
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder, DetailLevel detailLevel) {
        Definition definition;
        boolean bl;
        super.writeToJson(stringBuilder, detailLevel);
        if (this.maps != null && !this.maps.isEmpty()) {
            stringBuilder.append(",\"m\":{");
            bl = true;
            for (Map.Entry object : this.maps.entrySet()) {
                definition = this.getRPClass().getDefinition(Definition.DefinitionClass.ATTRIBUTE, (String)object.getKey());
                if (!this.shouldSerialize(definition, detailLevel)) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                OutputSerializer.writeJson(stringBuilder, (String)object.getKey());
                stringBuilder.append(":{");
                ((Attributes)object.getValue()).writeToJson(stringBuilder, detailLevel);
                stringBuilder.append("}");
            }
            stringBuilder.append("}");
        }
        if (this.links != null && !this.links.isEmpty()) {
            stringBuilder.append(",\"l\":{");
            bl = true;
            for (RPLink rPLink : this.links) {
                definition = this.getRPClass().getDefinition(Definition.DefinitionClass.RPLINK, rPLink.getName());
                if (!this.shouldSerialize(definition, detailLevel)) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                OutputSerializer.writeJson(stringBuilder, rPLink.getName());
                stringBuilder.append(":{");
                rPLink.getObject().writeToJson(stringBuilder, detailLevel);
                stringBuilder.append("}");
            }
            stringBuilder.append("}");
        }
        if (this.events != null && !this.events.isEmpty()) {
            stringBuilder.append(",\"e\":[");
            bl = true;
            for (RPEvent rPEvent : this.events) {
                definition = this.getRPClass().getDefinition(Definition.DefinitionClass.RPEVENT, rPEvent.getName());
                if (!this.shouldSerialize(definition, detailLevel)) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append("{");
                rPEvent.writeToJson(stringBuilder, detailLevel);
                stringBuilder.append("}");
            }
            stringBuilder.append("]");
        }
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        Cloneable cloneable;
        int n;
        super.readObject(inputSerializer);
        this.modified = true;
        if (inputSerializer.readByte() == 1) {
            this.hidden = inputSerializer.readByte() == 1;
            this.storable = inputSerializer.readByte() == 1;
        }
        this.deserializeRPSlots(inputSerializer);
        int n2 = inputSerializer.readInt();
        if (n2 > 262144) {
            throw new IOException("Illegal request of an list of " + String.valueOf(n2) + " size");
        }
        if (n2 > 0) {
            this.links = new LinkedList<RPLink>();
            for (n = 0; n < n2; ++n) {
                cloneable = new RPLink(null, null);
                ((RPLink)cloneable).setOwner(this);
                cloneable = (RPLink)inputSerializer.readObject((Serializable)((Object)cloneable));
                this.links.add((RPLink)cloneable);
            }
        }
        if (inputSerializer.getProtocolVersion() >= 33) {
            int n3;
            n = inputSerializer.readInt();
            cloneable = new ArrayList();
            for (n3 = 0; n3 < n; ++n3) {
                cloneable.add(inputSerializer.readString());
            }
            for (n3 = 0; n3 < n; ++n3) {
                RPObject rPObject = new RPObject();
                rPObject = (RPObject)inputSerializer.readObject(rPObject);
                if (this.maps == null) {
                    this.maps = new HashMap<String, Attributes>();
                }
                this.maps.put((String)cloneable.get(n3), rPObject);
            }
        }
        if ((n2 = inputSerializer.readInt()) > 262144) {
            throw new IOException("Illegal request of an list of " + String.valueOf(n2) + " size");
        }
        if (n2 > 0) {
            this.events = new LinkedList<RPEvent>();
            for (n = 0; n < n2; ++n) {
                cloneable = new RPEvent();
                ((RPEvent)cloneable).setOwner(this);
                cloneable = (RPEvent)inputSerializer.readObject((Serializable)((Object)cloneable));
                this.events.add((RPEvent)cloneable);
            }
        } else {
            this.events = null;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RPObject) {
            RPObject rPObject = (RPObject)object;
            if (!(super.equals(object) && RPObject.collectionIsEqualTreaingNullAsEmpty(this.slots, rPObject.slots) && RPObject.collectionIsEqualTreaingNullAsEmpty(this.events, rPObject.events) && RPObject.collectionIsEqualTreaingNullAsEmpty(this.links, rPObject.links))) {
                return false;
            }
            if (this.maps == null || this.maps.isEmpty()) {
                return rPObject.maps == null || rPObject.maps.isEmpty();
            }
            return this.maps.equals(rPObject.maps);
        }
        return false;
    }

    private static boolean collectionIsEqualTreaingNullAsEmpty(Collection<?> collection, Collection<?> collection2) {
        if (collection == null || collection.isEmpty()) {
            return collection2 == null || collection2.isEmpty();
        }
        return collection.equals(collection2);
    }

    @Override
    public int hashCode() {
        String string = this.get("id");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 31;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.slots != null && !this.slots.isEmpty() || this.events != null && !this.events.isEmpty() || this.links != null && !this.links.isEmpty() || this.maps != null && !this.maps.isEmpty());
    }

    @Override
    public int size() {
        try {
            int n = super.size();
            if (this.events != null) {
                n += this.events.size();
            }
            if (this.slots != null) {
                for (RPSlot cloneable : this.slots) {
                    for (RPObject rPObject : cloneable) {
                        n += rPObject.size();
                    }
                }
            }
            if (this.links != null) {
                for (RPLink rPLink : this.links) {
                    n += rPLink.getObject().size();
                }
            }
            return n;
        }
        catch (Exception exception) {
            logger.error("Cannot determine size", exception);
            return -1;
        }
    }

    @Override
    public void clearVisible(boolean bl) {
        Object object;
        Iterator<Cloneable> iterator;
        super.clearVisible(bl);
        if (this.events != null) {
            iterator = this.events.iterator();
            while (iterator.hasNext()) {
                object = (RPEvent)iterator.next();
                Definition definition = this.getRPClass().getDefinition(Definition.DefinitionClass.RPEVENT, ((RPEvent)object).getName());
                if (definition == null) {
                    logger.warn("Null Definition for event: " + ((RPEvent)object).getName() + " of RPClass: " + this.getRPClass().getName());
                    continue;
                }
                if (!definition.isVisible()) continue;
                iterator.remove();
            }
        }
        iterator = this.slotsIterator();
        while (iterator.hasNext()) {
            object = (RPSlot)iterator.next();
            ((RPSlot)object).clearVisible(bl);
            boolean bl2 = this.getRPClass().getDefinition(Definition.DefinitionClass.RPSLOT, ((RPSlot)object).getName()).isVisible();
            if (bl || !bl2 || ((RPSlot)object).size() != 0) continue;
            iterator.remove();
            if (this.addedSlots != null) {
                this.addedSlots.remove(((RPSlot)object).getName());
            }
            if (this.deletedSlots != null) {
                this.deletedSlots.remove(((RPSlot)object).getName());
            }
            this.modified = true;
        }
        if (this.links != null) {
            object = this.links.iterator();
            while (object.hasNext()) {
                RPLink rPLink = (RPLink)object.next();
                rPLink.getObject().clearVisible(bl);
                if (!rPLink.getObject().isEmpty()) continue;
                object.remove();
                if (this.addedLinks != null) {
                    this.addedLinks.remove(rPLink.getName());
                }
                if (this.deletedLinks != null) {
                    this.deletedLinks.remove(rPLink.getName());
                }
                this.modified = true;
            }
        }
    }

    @Override
    public Object clone() {
        try {
            RPObject rPObject = (RPObject)super.clone();
            rPObject.clear();
            rPObject.fill(this);
            return rPObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error(cloneNotSupportedException, cloneNotSupportedException);
            return null;
        }
    }

    public void resetAddedAndDeleted() {
        this.resetAddedAndDeletedAttributes();
        this.resetAddedAndDeletedRPSlot();
        this.resetAddedAndDeletedRPLink();
        this.resetAddedAndDeletedMaps();
        this.clearEvents();
        if (this.modified) {
            this.modified = false;
        }
    }

    public void resetAddedAndDeletedRPSlot() {
        if (this.slots != null) {
            for (RPSlot rPSlot : this.slots) {
                rPSlot.resetAddedAndDeletedRPObjects();
                for (RPObject rPObject : rPSlot) {
                    rPObject.resetAddedAndDeleted();
                }
            }
        }
        if (this.modified) {
            if (this.addedSlots != null) {
                this.addedSlots.clear();
            }
            if (this.deletedSlots != null) {
                this.deletedSlots.clear();
            }
        }
    }

    public void resetAddedAndDeletedRPLink() {
        if (this.links != null) {
            for (RPLink rPLink : this.links) {
                rPLink.getObject().resetAddedAndDeleted();
            }
        }
        if (this.modified) {
            if (this.addedLinks != null) {
                this.addedLinks.clear();
            }
            if (this.deletedLinks != null) {
                this.deletedLinks.clear();
            }
        }
    }

    public void resetAddedAndDeletedMaps() {
        if (this.maps != null) {
            for (Attributes attributes : this.maps.values()) {
                attributes.resetAddedAndDeletedAttributes();
            }
        }
        if (this.addedMaps != null) {
            this.addedMaps.clear();
        }
        if (this.deletedMaps != null) {
            this.deletedMaps.clear();
        }
    }

    public void setAddedRPSlot(RPObject rPObject) {
        if (rPObject.addedSlots != null) {
            for (String string : rPObject.addedSlots) {
                this.addSlot(string);
            }
        }
    }

    public void setDeletedRPSlot(RPObject rPObject) {
        if (rPObject.deletedSlots != null) {
            for (String string : rPObject.deletedSlots) {
                this.addSlot(string);
            }
        }
    }

    public void setAddedMaps(RPObject rPObject) {
        if (rPObject.addedMaps != null) {
            for (String string : rPObject.addedMaps) {
                this.addMap(string);
            }
        }
    }

    public void setDeletedMaps(RPObject rPObject) {
        if (rPObject.deletedMaps != null) {
            for (String string : rPObject.deletedMaps) {
                this.addMap(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void getDifferences(RPObject rPObject, RPObject rPObject2) {
        Object object;
        Object object2;
        rPObject.setAddedAttributes(this);
        rPObject2.setDeletedAttributes(this);
        if (this.events != null) {
            if (rPObject.events == null) {
                rPObject.events = new LinkedList<RPEvent>();
            }
            for (RPEvent object3 : this.events) {
                rPObject.events.add(object3);
            }
        }
        if (this.addedLinks != null) {
            if (rPObject.addedLinks == null) {
                rPObject.addedLinks = new LinkedList<String>();
            }
            for (String string : this.addedLinks) {
                rPObject.addLink(string, this.getLinkedObject(string));
            }
        }
        if (this.deletedLinks != null) {
            if (rPObject2.deletedLinks == null) {
                rPObject2.deletedLinks = new LinkedList<String>();
            }
            for (String string : this.deletedLinks) {
                rPObject2.addLink(string, new RPObject());
            }
        }
        if (this.links != null) {
            for (RPLink rPLink : this.links) {
                object2 = new RPObject();
                RPObject rPObject3 = new RPObject();
                rPLink.getObject().getDifferences((RPObject)object2, rPObject3);
                if (!((RPObject)object2).isEmpty()) {
                    rPObject.addLink(rPLink.getName(), (RPObject)object2);
                }
                if (rPObject3.isEmpty()) continue;
                rPObject2.addLink(rPLink.getName(), rPObject3);
            }
        }
        rPObject.setAddedRPSlot(this);
        rPObject2.setDeletedRPSlot(this);
        if (this.slots != null && !this.slots.isEmpty()) {
            Object object5 = new RPObject();
            RPObject rPObject4 = new RPObject();
            for (RPSlot rPSlot : this.slots) {
                RPSlot rPSlot2;
                Object object3;
                object = this.getRPClass().getDefinition(Definition.DefinitionClass.RPSLOT, rPSlot.getName());
                if (((Definition)object).isHidden()) continue;
                RPSlot rPSlot3 = new RPSlot(rPSlot.getName());
                if (rPSlot3.setAddedRPObject(rPSlot)) {
                    if (!rPObject.hasSlot(rPSlot.getName())) {
                        rPObject.addSlot(rPSlot.getName());
                    }
                    RPSlot rPSlot4 = rPObject.getSlot(rPSlot.getName());
                    object3 = rPSlot3.iterator();
                    while (object3.hasNext()) {
                        Object object4 = object3.next();
                        rPSlot4.add((RPObject)object4, false);
                    }
                }
                if ((rPSlot2 = new RPSlot(rPSlot.getName())).setDeletedRPObject(rPSlot)) {
                    if (!rPObject2.hasSlot(rPSlot.getName())) {
                        rPObject2.addSlot(rPSlot.getName());
                    }
                    object3 = rPObject2.getSlot(rPSlot.getName());
                    for (Cloneable cloneable : rPSlot2) {
                        ((RPSlot)object3).add((RPObject)cloneable, false);
                    }
                }
                for (Object object4 : rPSlot) {
                    void var4_12;
                    Cloneable cloneable;
                    if (rPSlot3.has(((RPObject)object4).getID())) continue;
                    ((RPObject)object4).getDifferences((RPObject)object5, (RPObject)var4_12);
                    if (!((RPObject)object5).isEmpty()) {
                        if (!rPObject.hasSlot(rPSlot.getName())) {
                            rPObject.addSlot(rPSlot.getName());
                        }
                        cloneable = rPObject.getSlot(rPSlot.getName());
                        ((Attributes)object5).put("id", ((Attributes)object4).get("id"));
                        ((RPSlot)cloneable).add((RPObject)object5, false);
                        object5 = new RPObject();
                    }
                    if (var4_12.isEmpty()) continue;
                    if (!rPObject2.hasSlot(rPSlot.getName())) {
                        rPObject2.addSlot(rPSlot.getName());
                    }
                    cloneable = rPObject2.getSlot(rPSlot.getName());
                    var4_12.put("id", ((Attributes)object4).get("id"));
                    ((RPSlot)cloneable).add((RPObject)var4_12, false);
                    RPObject rPObject5 = new RPObject();
                }
            }
        }
        rPObject.setAddedMaps(this);
        rPObject2.setDeletedMaps(this);
        if (this.maps != null) {
            for (Map.Entry entry : this.maps.entrySet()) {
                object = ((Attributes)entry.getValue()).added;
                synchronized (object) {
                    for (Map.Entry entry2 : ((Attributes)entry.getValue()).added.entrySet()) {
                        if (((String)entry2.getKey()).equals("id") || ((String)entry2.getKey()).equals("zoneid")) continue;
                        rPObject.put((String)entry.getKey(), (String)entry2.getKey(), (String)entry2.getValue());
                    }
                }
                object = ((Attributes)entry.getValue()).deleted;
                synchronized (object) {
                    for (Map.Entry<String, String> entry3 : ((Attributes)entry.getValue()).deleted.entrySet()) {
                        if (entry3.getKey().equals("id") || entry3.getKey().equals("zoneid")) continue;
                        rPObject2.put((String)entry.getKey(), entry3.getKey(), entry3.getValue());
                    }
                }
            }
        }
        if (!rPObject.isEmpty()) {
            rPObject.put("id", this.get("id"));
            object2 = this.get("zoneid");
            if (object2 != null) {
                rPObject.put("zoneid", (String)object2);
            }
        }
        if (!rPObject2.isEmpty()) {
            rPObject2.put("id", this.get("id"));
            object2 = this.get("zoneid");
            if (object2 != null) {
                rPObject2.put("zoneid", (String)object2);
            }
        }
    }

    public void applyDifferences(RPObject rPObject, RPObject rPObject2) {
        RPObject rPObject3;
        Cloneable cloneable;
        super.applyDifferences(rPObject, rPObject2);
        if (rPObject2 != null) {
            if (rPObject2.links != null) {
                for (RPLink object : rPObject2.links) {
                    if (object.getObject().isEmpty()) {
                        this.removeLink(object.getName());
                        continue;
                    }
                    this.getLinkedObject(object.getName()).applyDifferences(null, object.getObject());
                }
            }
            if (rPObject2.maps != null && this.maps != null) {
                for (Map.Entry entry : rPObject2.maps.entrySet()) {
                    if (((Attributes)entry.getValue()).isEmpty()) {
                        this.removeMap((String)entry.getKey());
                        continue;
                    }
                    this.maps.get(entry.getKey()).applyDifferences(null, (Attributes)entry.getValue());
                }
            }
            if (rPObject2.slots != null) {
                for (RPSlot rPSlot : rPObject2.slots) {
                    if (rPSlot.size() == 0) {
                        this.removeSlot(rPSlot.getName());
                        continue;
                    }
                    cloneable = this.getSlot(rPSlot.getName());
                    for (RPObject rPObject4 : rPSlot) {
                        if (rPObject4.size() > 1) {
                            rPObject3 = ((RPSlot)cloneable).get(rPObject4.getID());
                            rPObject3.applyDifferences(null, rPObject4);
                            continue;
                        }
                        ((RPSlot)cloneable).remove(rPObject4.getID());
                    }
                }
            }
        }
        if (rPObject != null) {
            if (rPObject.events != null) {
                if (this.events == null) {
                    this.events = new LinkedList<RPEvent>();
                }
                for (RPEvent rPEvent : rPObject.events) {
                    this.events.add(rPEvent);
                }
            }
            if (rPObject.links != null) {
                if (this.links == null) {
                    this.links = new LinkedList<RPLink>();
                }
                for (RPLink rPLink : rPObject.links) {
                    if (!this.hasLink(rPLink.getName())) {
                        this.links.add(rPLink);
                        continue;
                    }
                    this.getLinkedObject(rPLink.getName()).applyDifferences(rPLink.getObject(), null);
                }
            }
            if (rPObject.maps != null) {
                for (Map.Entry entry : rPObject.maps.entrySet()) {
                    if (this.maps == null) {
                        this.maps = new HashMap<String, Attributes>();
                    }
                    if (!this.maps.containsKey(entry.getKey())) {
                        cloneable = new Attributes(RPClass.getBaseRPObjectDefault());
                        ((Attributes)cloneable).fill((Attributes)entry.getValue());
                        this.maps.put((String)entry.getKey(), (Attributes)cloneable);
                        continue;
                    }
                    this.maps.get(entry.getKey()).applyDifferences((Attributes)entry.getValue(), null);
                }
            }
            if (rPObject.slots != null) {
                for (RPSlot rPSlot : rPObject.slots) {
                    if (!this.hasSlot(rPSlot.getName())) {
                        this.addSlot(rPSlot.getName());
                    }
                    cloneable = this.getSlot(rPSlot.getName());
                    for (RPObject rPObject4 : rPSlot) {
                        rPObject3 = ((RPSlot)cloneable).get(rPObject4.getID());
                        if (rPObject3 != null) {
                            rPObject3.applyDifferences(rPObject4, null);
                            continue;
                        }
                        ((RPSlot)cloneable).add(rPObject4, false);
                    }
                }
            }
        }
    }

    @Override
    public boolean hasSlot(String string) {
        return super.hasSlot(string);
    }

    @Override
    public RPSlot getSlot(String string) {
        return super.getSlot(string);
    }

    @Override
    public Iterator<RPSlot> slotsIterator() {
        return super.slotsIterator();
    }

    @Override
    public List<RPSlot> slots() {
        return super.slots();
    }

    public static class ID {
        private final int id;
        private String zoneid;

        public ID(int n, String string) {
            this.id = n;
            this.zoneid = string;
        }

        public ID(int n, IRPZone.ID iD) {
            this.id = n;
            this.zoneid = iD.getID();
        }

        public ID(RPObject rPObject) {
            this.id = rPObject.getInt("id");
            this.zoneid = rPObject.get("zoneid");
        }

        public ID(RPAction rPAction) {
            this.id = rPAction.getInt("sourceid");
            this.zoneid = rPAction.get("zoneid");
        }

        public int getObjectID() {
            return this.id;
        }

        public String getZoneID() {
            return this.zoneid;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof ID) {
                ID iD = (ID)object;
                if (this.id == iD.id) {
                    if (this.zoneid == null) {
                        return iD.zoneid == null;
                    }
                    return this.zoneid.equals(iD.zoneid);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "RPObject.ID [id=" + this.id + " zoneid=" + this.zoneid + "]";
        }
    }
}

