/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.Serializable;

public class Message
implements Serializable {
    public static final int CLIENTID_INVALID = -1;
    protected MessageType type;
    protected int clientid = -1;
    protected int timestampMessage;
    protected int protocolVersion = 35;
    protected Channel channel;
    private InetAddress inetAddres;

    protected Message(MessageType messageType, Channel channel) {
        this.type = messageType;
        this.clientid = -1;
        this.channel = channel;
        if (channel != null) {
            this.inetAddres = channel.getInetAddress();
        }
        this.timestampMessage = (int)System.currentTimeMillis();
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
        this.inetAddres = channel != null ? channel.getInetAddress() : null;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public InetAddress getAddress() {
        return this.inetAddres;
    }

    public MessageType getType() {
        return this.type;
    }

    public void setClientID(int n) {
        this.clientid = n;
    }

    public int getClientID() {
        return this.clientid;
    }

    public int getMessageTimestamp() {
        return this.timestampMessage;
    }

    public boolean isSkippable() {
        return false;
    }

    public boolean isPerception() {
        return false;
    }

    public boolean requiresPerception() {
        return false;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int n) {
        this.protocolVersion = Math.min(35, n);
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        outputSerializer.write((byte)Math.min(this.protocolVersion, 35));
        outputSerializer.write((byte)this.type.ordinal());
        outputSerializer.write(this.clientid);
        outputSerializer.write(this.timestampMessage);
    }

    public void writeToJson(StringBuilder stringBuilder) {
        stringBuilder.append("\"t\": \"");
        stringBuilder.append(this.type.ordinal());
        stringBuilder.append("\",\"c\": \"");
        stringBuilder.append(this.clientid);
        stringBuilder.append("\",\"s\": \"");
        stringBuilder.append(this.timestampMessage);
        stringBuilder.append("\"");
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        this.protocolVersion = inputSerializer.readByte();
        if (this.protocolVersion < 31 || this.protocolVersion > 80) {
            throw new IOException("Unsupported protocol version.");
        }
        this.type = MessageType.values()[inputSerializer.readByte()];
        this.clientid = inputSerializer.readInt();
        this.timestampMessage = inputSerializer.readInt();
    }

    public void readFromMap(Map<String, Object> map) throws IOException {
        this.type = MessageType.values()[Byte.parseByte((String)map.get("t"))];
        this.clientid = Integer.parseInt((String)map.get("c"));
        this.timestampMessage = Integer.parseInt((String)map.get("s"));
    }

    protected void internalToString(StringBuilder stringBuilder) {
        stringBuilder.append(", channel=");
        stringBuilder.append(this.channel);
        stringBuilder.append(", clientid=");
        stringBuilder.append(this.clientid);
        stringBuilder.append(", timestampMessage=");
        stringBuilder.append(this.timestampMessage);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[");
        stringBuilder.append("type=");
        stringBuilder.append((Object)this.type);
        this.internalToString(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static enum MessageType {
        C2S_ACTION,
        C2S_CHOOSECHARACTER,
        C2S_LOGIN_REQUESTKEY,
        C2S_LOGIN_SENDNONCENAMEANDPASSWORD,
        C2S_LOGIN_SENDPROMISE,
        C2S_LOGOUT,
        C2S_OUTOFSYNC,
        C2S_TRANSFER_ACK,
        C2S_KEEPALIVE,
        S2C_CHARACTERLIST,
        S2C_CHOOSECHARACTER_ACK,
        S2C_CHOOSECHARACTER_NACK,
        S2C_INVALIDMESSAGE,
        S2C_LOGIN_ACK,
        S2C_LOGIN_NACK,
        S2C_LOGIN_SENDKEY,
        S2C_LOGIN_SENDNONCE,
        S2C_LOGOUT_ACK,
        S2C_LOGOUT_NACK,
        S2C_PERCEPTION,
        S2C_SERVERINFO,
        S2C_TRANSFER,
        S2C_TRANSFER_REQ,
        C2S_CREATEACCOUNT,
        S2C_CREATEACCOUNT_ACK,
        S2C_CREATEACCOUNT_NACK,
        C2S_CREATECHARACTER,
        S2C_CREATECHARACTER_ACK,
        S2C_CREATECHARACTER_NACK,
        S2C_CONNECT_NACK,
        C2S_LOGIN_SENDNONCENAMEPASSWORDANDSEED,
        S2C_LOGIN_MESSAGE_NACK,
        P2S_CREATECHARACTER,
        P2S_CREATEACCOUNT,
        C2S_LOGIN_SENDUSERNAMEANDPASSWORD,
        S2C_UPDATE,
        C2S_UPDATE_RESPONSE,
        C2S_LOGIN_WITH_TOKEN,
        C2S_CREATE_ACCOUNT_WITH_TOKEN;

    }
}

