/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import marauroa.common.Utility;
import marauroa.common.crypto.Hash;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageSendByteArray;

public class MessageC2SLoginSendNonceNamePasswordAndSeed
extends MessageSendByteArray {
    private String username;
    private byte[] password;
    private byte[] seed;

    public MessageC2SLoginSendNonceNamePasswordAndSeed() {
        super(Message.MessageType.C2S_LOGIN_SENDNONCENAMEPASSWORDANDSEED);
    }

    public MessageC2SLoginSendNonceNamePasswordAndSeed(Channel channel, byte[] byArray, String string, byte[] byArray2, byte[] byArray3) {
        super(Message.MessageType.C2S_LOGIN_SENDNONCENAMEPASSWORDANDSEED, channel, byArray);
        this.username = string;
        this.password = Utility.copy(byArray2);
        this.seed = Utility.copy(byArray3);
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getPassword() {
        return Utility.copy(this.password);
    }

    public byte[] getSeed() {
        return this.seed;
    }

    @Override
    public String toString() {
        return "Message (C2S Login) from (" + this.getAddress() + ") CONTENTS: (nonce:" + Hash.toHexString(this.hash) + "\tusername:" + this.username + "\tseed:" + Hash.toHexString(this.seed) + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write(this.username);
        outputSerializer.write(this.password);
        outputSerializer.write(this.seed);
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.username = inputSerializer.readString();
        this.password = inputSerializer.readByteArray();
        this.seed = inputSerializer.readByteArray();
        if (this.type != Message.MessageType.C2S_LOGIN_SENDNONCENAMEPASSWORDANDSEED) {
            throw new IOException();
        }
    }
}

