/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import marauroa.common.Utility;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

public class MessageC2SLoginWithToken
extends Message {
    private byte[] nonce;
    private byte[] encryptedSessionKey;
    private byte[] initVector;
    private String username;
    private String tokenType;
    private byte[] encryptedToken;

    public MessageC2SLoginWithToken() {
        super(Message.MessageType.C2S_LOGIN_WITH_TOKEN, null);
    }

    public MessageC2SLoginWithToken(Channel channel, byte[] byArray, byte[] byArray2, byte[] byArray3, String string, String string2, byte[] byArray4) {
        super(Message.MessageType.C2S_LOGIN_WITH_TOKEN, channel);
        this.nonce = Utility.copy(byArray);
        this.encryptedSessionKey = Utility.copy(byArray2);
        this.initVector = Utility.copy(byArray3);
        this.username = string;
        this.tokenType = string2;
        this.encryptedToken = Utility.copy(byArray4);
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public byte[] getEncryptedSessionKey() {
        return this.encryptedSessionKey;
    }

    public byte[] getInitVector() {
        return this.initVector;
    }

    public String getUsername() {
        return this.username;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public byte[] getEncryptedToken() {
        return Utility.copy(this.encryptedToken);
    }

    @Override
    public String toString() {
        return "Message (C2S Login With Token) from (" + this.getAddress() + ") CONTENTS: (username:" + this.username + "\ttokenType:" + this.tokenType + "token:<encrypted>)";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write(this.nonce);
        outputSerializer.write(this.encryptedSessionKey);
        outputSerializer.write(this.initVector);
        if (this.username != null) {
            outputSerializer.write(this.username);
        } else {
            outputSerializer.write("");
        }
        outputSerializer.write(this.tokenType);
        outputSerializer.write(this.encryptedToken);
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.nonce = inputSerializer.readByteArray();
        this.encryptedSessionKey = inputSerializer.readByteArray();
        this.initVector = inputSerializer.readByteArray();
        this.username = inputSerializer.readString();
        this.tokenType = inputSerializer.readString();
        this.encryptedToken = inputSerializer.readByteArray();
        if (this.type != Message.MessageType.C2S_LOGIN_WITH_TOKEN) {
            throw new IOException();
        }
    }
}

