/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

public class MessageS2CLoginMessageNACK
extends Message {
    private String reason;

    public MessageS2CLoginMessageNACK() {
        super(Message.MessageType.S2C_LOGIN_MESSAGE_NACK, null);
    }

    public MessageS2CLoginMessageNACK(Channel channel, String string) {
        super(Message.MessageType.S2C_LOGIN_MESSAGE_NACK, channel);
        this.reason = string;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public String toString() {
        return "Message (S2C Login NACK) from (" + this.getAddress() + ") CONTENTS: (" + this.reason + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        if (outputSerializer.getProtocolVersion() >= 34) {
            outputSerializer.write65536LongString(this.reason);
        } else {
            String string = this.reason;
            if (string.length() > 250) {
                string = string.substring(0, 250);
            }
            outputSerializer.write255LongString(string);
        }
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.reason = this.getProtocolVersion() >= 34 ? inputSerializer.read65536LongString() : inputSerializer.read255LongString();
        if (this.type != Message.MessageType.S2C_LOGIN_MESSAGE_NACK) {
            throw new IOException();
        }
    }
}

