/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import marauroa.common.i18n.I18N;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

public class MessageS2CLoginNACK
extends Message {
    private static String[] text = new String[]{"Username/Password incorrect.", "There have been too many failed login attempts for your account or network. Please wait a couple of minutes or contact support.", "Account is banned.", "Server is full.", "Server is running an incompatible version of game. Please update.", "Invalid network protocol version.", "The hash you sent does not correspond to the nonce you sent.", "You account has been marked as inactive, please contact support.", "There have been too many failed login attempts for your account. Please wait a couple of minutes or contact support.", "There have been too many failed login attempts from your network. Please wait a couple of minutes or contact support.", "Login expired. Please click again on your character on the web page.", "This account was merged into another account. Please use the username of the other account to login or contact support."};
    private Reasons reason;

    public MessageS2CLoginNACK() {
        super(Message.MessageType.S2C_LOGIN_NACK, null);
    }

    public MessageS2CLoginNACK(Channel channel, Reasons reasons) {
        super(Message.MessageType.S2C_LOGIN_NACK, channel);
        this.reason = reasons;
    }

    public Reasons getResolutionCode() {
        return this.reason;
    }

    public String getResolution() {
        return I18N.translate(text[this.reason.ordinal()], new Object[0]);
    }

    @Override
    public String toString() {
        return "Message (S2C Login NACK) from (" + this.getAddress() + ") CONTENTS: (" + this.getResolution() + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write((byte)this.reason.ordinal());
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.reason = Reasons.values()[inputSerializer.readByte()];
        if (this.type != Message.MessageType.S2C_LOGIN_NACK) {
            throw new IOException();
        }
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",\"reason\":\"");
        stringBuilder.append(this.reason.name());
        stringBuilder.append("\",\"text\":");
        OutputSerializer.writeJson(stringBuilder, text[this.reason.ordinal()]);
    }

    public static enum Reasons {
        USERNAME_WRONG,
        TOO_MANY_TRIES,
        USERNAME_BANNED,
        SERVER_IS_FULL,
        GAME_MISMATCH,
        PROTOCOL_MISMATCH,
        INVALID_NONCE,
        USERNAME_INACTIVE,
        TOO_MANY_TRIES_USERNAME,
        TOO_MANY_TRIES_IP,
        SEED_WRONG,
        ACCOUNT_MERGED;

    }
}

