/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.TransferContent;

public class MessageS2CTransferREQ
extends Message {
    private List<TransferContent> contents;

    public MessageS2CTransferREQ() {
        super(Message.MessageType.S2C_TRANSFER_REQ, null);
    }

    public MessageS2CTransferREQ(Channel channel, List<TransferContent> list) {
        super(Message.MessageType.S2C_TRANSFER_REQ, channel);
        this.contents = list;
    }

    public List<TransferContent> getContents() {
        return this.contents;
    }

    @Override
    public boolean requiresPerception() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Message (S2C Transfer REQ) from (" + this.getAddress() + ") CONTENTS: (");
        for (TransferContent transferContent : this.contents) {
            stringBuilder.append("[");
            stringBuilder.append(transferContent.name);
            stringBuilder.append(":");
            stringBuilder.append(transferContent.timestamp);
            stringBuilder.append("]");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        int n = this.contents.size();
        outputSerializer.write(n);
        for (TransferContent transferContent : this.contents) {
            transferContent.writeREQ(outputSerializer);
        }
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",\"contents\":[");
        boolean bl = true;
        for (TransferContent transferContent : this.contents) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            transferContent.writeREQToJson(stringBuilder);
        }
        stringBuilder.append("]");
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        int n = inputSerializer.readInt();
        this.contents = new LinkedList<TransferContent>();
        for (int i = 0; i < n; ++i) {
            TransferContent transferContent = new TransferContent();
            transferContent.readREQ(inputSerializer);
            this.contents.add(transferContent);
        }
        if (this.type != Message.MessageType.S2C_TRANSFER_REQ) {
            throw new IOException();
        }
    }
}

