/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db;

import java.sql.SQLException;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.DBTransaction;

public class UpdateScript {
    private static Logger logger = Log4J.getLogger(UpdateScript.class);

    public void update(DBTransaction dBTransaction) throws SQLException {
        logger.info("Checking database structure and updating it if needed.");
        if (!dBTransaction.doesColumnExist("loginEvent", "service")) {
            dBTransaction.execute("ALTER TABLE loginEvent ADD COLUMN (service CHAR(10));", null);
        }
        if (!dBTransaction.doesColumnExist("loginEvent", "seed")) {
            dBTransaction.execute("ALTER TABLE loginEvent ADD COLUMN (seed VARCHAR(120));", null);
        }
        if (!dBTransaction.doesColumnExist("passwordChange", "result")) {
            dBTransaction.execute("ALTER TABLE passwordChange ADD COLUMN (result TINYINT);", null);
            dBTransaction.execute("UPDATE passwordChange SET result=1 WHERE result IS NULL", null);
        }
        if (!dBTransaction.doesColumnExist("statistics", "ips_online")) {
            dBTransaction.execute("ALTER TABLE statistics ADD COLUMN (ips_online INTEGER);", null);
        }
        if (!dBTransaction.doesColumnExist("loginEvent", "account_link_id")) {
            dBTransaction.execute("ALTER TABLE loginEvent ADD COLUMN (account_link_id INTEGER);", null);
        }
        if (!dBTransaction.doesColumnExist("characters", "timedate")) {
            dBTransaction.execute("ALTER TABLE characters ADD COLUMN (timedate TIMESTAMP default CURRENT_TIMESTAMP);", null);
            dBTransaction.execute("UPDATE characters SET characters.timedate = (SELECT account.timedate FROM account WHERE characters.player_id=account.id);", null);
        }
        if (!dBTransaction.doesColumnExist("rpobject", "protocol_version")) {
            dBTransaction.execute("ALTER TABLE rpobject ADD COLUMN (protocol_version INTEGER);", null);
        }
        if (!dBTransaction.doesColumnExist("rpzone", "protocol_version")) {
            dBTransaction.execute("ALTER TABLE rpzone ADD COLUMN (protocol_version INTEGER);", null);
        }
        if (!dBTransaction.doesColumnExist("characters", "id")) {
            dBTransaction.execute("ALTER TABLE characters DROP PRIMARY KEY;", null);
            dBTransaction.execute("ALTER TABLE characters ADD COLUMN(id integer auto_increment not null, PRIMARY KEY(id));", null);
            dBTransaction.execute("CREATE UNIQUE INDEX i_characters ON characters(charname);", null);
        }
        if (!dBTransaction.doesColumnExist("characters", "status")) {
            dBTransaction.execute("ALTER TABLE characters ADD COLUMN(status char(8) not null default 'active');", null);
            dBTransaction.execute("UPDATE characters SET status='active' WHERE status IS NULL;", null);
        }
        if (!dBTransaction.doesColumnExist("accountLink", "secret")) {
            dBTransaction.execute("ALTER TABLE accountLink ADD COLUMN (secret varchar(255));", null);
        }
        if (dBTransaction.doesColumnExist("account", "email")) {
            dBTransaction.execute("INSERT INTO email (player_id, email, timedate) SELECT id, email, timedate FROM account WHERE email IS NOT NULL and email != ''", null);
            dBTransaction.execute("ALTER TABLE account DROP COLUMN (email);", null);
        }
        logger.info("Completed database update.");
    }
}

