/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.command;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import marauroa.common.i18n.I18N;
import marauroa.server.db.command.DBCommand;
import marauroa.server.db.command.DBCommandMetaData;
import marauroa.server.db.command.DBCommandPriority;
import marauroa.server.db.command.DBCommandQueueBackgroundThread;
import marauroa.server.db.command.ResultHandle;

public final class DBCommandQueue {
    private static DBCommandQueue instance;
    private PriorityBlockingQueue<DBCommandMetaData> pendingCommands = new PriorityBlockingQueue();
    private List<DBCommandMetaData> processedCommands = Collections.synchronizedList(new LinkedList());
    private boolean finished;

    public static DBCommandQueue get() {
        if (instance == null) {
            instance = new DBCommandQueue();
        }
        return instance;
    }

    private DBCommandQueue() {
        Thread thread = new Thread((Runnable)new DBCommandQueueBackgroundThread(), "DBCommandQueue");
        thread.start();
    }

    public void enqueue(DBCommand dBCommand) {
        this.enqueue(dBCommand, DBCommandPriority.CRITICAL);
    }

    public void enqueue(DBCommand dBCommand, DBCommandPriority dBCommandPriority) {
        this.pendingCommands.add(new DBCommandMetaData(dBCommand, null, Thread.currentThread(), false, I18N.getLocale(), dBCommandPriority));
    }

    public void enqueueAndAwaitResult(DBCommand dBCommand, ResultHandle resultHandle) {
        this.enqueueAndAwaitResult(dBCommand, DBCommandPriority.CRITICAL, resultHandle);
    }

    public void enqueueAndAwaitResult(DBCommand dBCommand, DBCommandPriority dBCommandPriority, ResultHandle resultHandle) {
        this.pendingCommands.add(new DBCommandMetaData(dBCommand, resultHandle, Thread.currentThread(), true, I18N.getLocale(), dBCommandPriority));
    }

    protected DBCommandMetaData getNextCommand() throws InterruptedException {
        return this.pendingCommands.poll(1L, TimeUnit.SECONDS);
    }

    protected void addResult(DBCommandMetaData dBCommandMetaData) {
        this.processedCommands.add(dBCommandMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DBCommand> List<T> getResults(Class<T> clazz, ResultHandle resultHandle) {
        LinkedList<DBCommand> linkedList = new LinkedList<DBCommand>();
        List<DBCommandMetaData> list = this.processedCommands;
        synchronized (list) {
            Iterator<DBCommandMetaData> iterator = this.processedCommands.iterator();
            while (iterator.hasNext()) {
                DBCommandMetaData dBCommandMetaData = iterator.next();
                DBCommand dBCommand = dBCommandMetaData.getCommand();
                if (!clazz.isAssignableFrom(dBCommand.getClass()) || dBCommandMetaData.getResultHandle() != resultHandle) continue;
                linkedList.add(dBCommand);
                iterator.remove();
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DBCommand> T getOneResult(Class<T> clazz, ResultHandle resultHandle) {
        List<DBCommandMetaData> list = this.processedCommands;
        synchronized (list) {
            Iterator<DBCommandMetaData> iterator = this.processedCommands.iterator();
            while (iterator.hasNext()) {
                DBCommandMetaData dBCommandMetaData = iterator.next();
                DBCommand dBCommand = dBCommandMetaData.getCommand();
                if (!clazz.isAssignableFrom(dBCommand.getClass()) || dBCommandMetaData.getResultHandle() != resultHandle) continue;
                iterator.remove();
                return (T)dBCommand;
            }
        }
        return null;
    }

    public void finish() {
        this.finished = true;
    }

    protected boolean isFinished() {
        return this.finished;
    }

    public int size() {
        return this.pendingCommands.size();
    }

    protected Timestamp getOldestEnqueueTimestamp() {
        DBCommandMetaData dBCommandMetaData = this.pendingCommands.peek();
        if (dBCommandMetaData == null) {
            return null;
        }
        return dBCommandMetaData.getCommand().getEnqueueTime();
    }

    protected DBCommandMetaData[] dumpQueue() {
        DBCommandMetaData[] dBCommandMetaDataArray = new DBCommandMetaData[this.pendingCommands.size() + 2];
        return this.pendingCommands.toArray(dBCommandMetaDataArray);
    }
}

