/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game;

import java.util.LinkedList;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.crypto.RSAKey;
import marauroa.common.net.Channel;
import marauroa.common.net.message.Message;
import marauroa.server.game.Statistics;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.PlayerEntryContainer;
import marauroa.server.game.messagehandler.DelayedEventHandlerThread;
import marauroa.server.game.messagehandler.DisconnectHandler;
import marauroa.server.game.messagehandler.MessageDispatcher;
import marauroa.server.game.rp.DebugInterface;
import marauroa.server.game.rp.RPServerManager;
import marauroa.server.net.IDisconnectedListener;
import marauroa.server.net.INetworkServerManager;

public final class GameServerManager
extends Thread
implements IDisconnectedListener {
    private static final Logger logger = Log4J.getLogger(GameServerManager.class);
    private final INetworkServerManager netMan;
    private final RPServerManager rpMan;
    private final PlayerEntryContainer playerContainer;
    private boolean keepRunning = true;
    private boolean isfinished = false;
    private final DelayedEventHandlerThread delayedEventHandler;
    private final MessageDispatcher messageDispatcher;
    private final DisconnectHandler disconnectHandler = new DisconnectHandler();

    public GameServerManager(RSAKey rSAKey, INetworkServerManager iNetworkServerManager, RPServerManager rPServerManager) throws Exception {
        super("GameServerManager");
        this.netMan = iNetworkServerManager;
        this.rpMan = rPServerManager;
        iNetworkServerManager.registerDisconnectedListener(this);
        this.playerContainer = PlayerEntryContainer.getContainer();
        this.delayedEventHandler = new DelayedEventHandlerThread(rPServerManager);
        this.messageDispatcher = new MessageDispatcher();
        this.messageDispatcher.init(iNetworkServerManager, rPServerManager, this.playerContainer, Statistics.getStatistics(), rSAKey);
    }

    @Override
    public synchronized void start() {
        super.start();
        this.delayedEventHandler.start();
    }

    public void finish() {
        this.storeConnectedPlayers();
        this.rpMan.finish();
        this.keepRunning = false;
        this.interrupt();
        this.delayedEventHandler.setKeepRunning(false);
        while (!this.isfinished) {
            Thread.yield();
        }
    }

    private void storeConnectedPlayers() {
        LinkedList<PlayerEntry> linkedList = new LinkedList<PlayerEntry>();
        for (PlayerEntry playerEntry : this.playerContainer) {
            linkedList.add(playerEntry);
        }
        for (PlayerEntry playerEntry : linkedList) {
            logger.info("STORING (" + playerEntry.username + ") :" + playerEntry.object);
            this.onDisconnect(playerEntry.channel);
        }
    }

    @Override
    public void run() {
        try {
            while (this.keepRunning) {
                Message message = this.netMan.getMessage();
                if (message != null) {
                    DebugInterface.get().onMessage(message);
                    this.messageDispatcher.dispatchMessage(message);
                }
                this.playerContainer.dumpStatistics();
            }
        }
        catch (Throwable throwable) {
            logger.error("Unhandled exception, server will shut down.", throwable);
            System.exit(1);
        }
        this.isfinished = true;
    }

    @Override
    public void onDisconnect(Channel channel) {
        logger.info("GAME Disconnecting " + channel.getInetSocketAddress());
        this.delayedEventHandler.addDelayedEvent(this.disconnectHandler, channel);
    }
}

