/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.container;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.RPObject;
import marauroa.common.net.Channel;
import marauroa.server.RWLock;
import marauroa.server.game.Statistics;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;

public class PlayerEntryContainer
implements Iterable<PlayerEntry> {
    private static final Logger logger = Log4J.getLogger(PlayerEntryContainer.class);
    private final RWLock lock;
    private final Random rand;
    Map<Integer, PlayerEntry> clientidMap;
    private static PlayerEntryContainer playerEntryContainer;
    private final Statistics stats = Statistics.getStatistics();

    protected PlayerEntryContainer() {
        this.rand = new Random();
        this.rand.setSeed(new Date().getTime());
        this.lock = new RWLock();
        this.clientidMap = Collections.synchronizedMap(new HashMap());
    }

    public static PlayerEntryContainer getContainer() {
        if (playerEntryContainer == null) {
            playerEntryContainer = new PlayerEntryContainer();
        }
        return playerEntryContainer;
    }

    @Override
    public Iterator<PlayerEntry> iterator() {
        return new LinkedList<PlayerEntry>(this.clientidMap.values()).iterator();
    }

    public RWLock getLock() {
        return this.lock;
    }

    public int size() {
        return this.clientidMap.size();
    }

    public boolean has(int n) {
        return this.clientidMap.containsKey(n);
    }

    public PlayerEntry get(int n) {
        return this.clientidMap.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerEntry get(Channel channel) {
        Map<Integer, PlayerEntry> map = this.clientidMap;
        synchronized (map) {
            for (PlayerEntry playerEntry : this.clientidMap.values()) {
                if (playerEntry.channel != channel) continue;
                return playerEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerEntry get(String string) {
        Map<Integer, PlayerEntry> map = this.clientidMap;
        synchronized (map) {
            for (PlayerEntry playerEntry : this.clientidMap.values()) {
                if (!string.equalsIgnoreCase(playerEntry.username)) continue;
                return playerEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerEntry getOldEntry(PlayerEntry playerEntry) {
        Map<Integer, PlayerEntry> map = this.clientidMap;
        synchronized (map) {
            for (PlayerEntry playerEntry2 : this.clientidMap.values()) {
                if (!playerEntry.character.equalsIgnoreCase(playerEntry2.character) || playerEntry2 == playerEntry) continue;
                return playerEntry2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerEntry get(RPObject rPObject) {
        Map<Integer, PlayerEntry> map = this.clientidMap;
        synchronized (map) {
            for (PlayerEntry playerEntry : this.clientidMap.values()) {
                if (playerEntry.object != rPObject) continue;
                return playerEntry;
            }
        }
        return null;
    }

    public PlayerEntry remove(int n) {
        return this.clientidMap.remove(n);
    }

    public PlayerEntry add(Channel channel) {
        PlayerEntry playerEntry = new PlayerEntry(channel);
        playerEntry.clientid = this.generateClientID();
        this.clientidMap.put(playerEntry.clientid, playerEntry);
        return playerEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateClientID() {
        int n = this.rand.nextInt();
        Map<Integer, PlayerEntry> map = this.clientidMap;
        synchronized (map) {
            while (this.has(n) && n > 0) {
                n = this.rand.nextInt();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerEntry getIdleEntry() {
        Map<Integer, PlayerEntry> map = this.clientidMap;
        synchronized (map) {
            for (PlayerEntry playerEntry : this.clientidMap.values()) {
                if (!playerEntry.isRemovable()) continue;
                return playerEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpStatistics() {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        int n = 0;
        Map<Integer, PlayerEntry> map = this.clientidMap;
        synchronized (map) {
            for (PlayerEntry playerEntry : this.clientidMap.values()) {
                if (playerEntry.state != ClientState.GAME_BEGIN) continue;
                hashSet.add(playerEntry.getAddress());
                ++n;
            }
        }
        logger.debug("PlayerEntryContainer size: " + n);
        this.stats.set("Players online", n);
        this.stats.set("Ips online", hashSet.size());
    }

    public String toString() {
        return "PlayerEntryContainer [clientidMap=" + this.clientidMap + "]";
    }
}

