/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.container;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.sql.Timestamp;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.Utility;
import marauroa.common.crypto.Hash;
import marauroa.common.crypto.RSAKey;
import marauroa.common.net.message.MessageS2CLoginNACK;
import marauroa.server.db.DBTransaction;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.PlayerEntryContainer;
import marauroa.server.game.db.AccountDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.db.LoginEventDAO;

public class SecuredLoginInfo {
    private static Logger logger = Log4J.getLogger(SecuredLoginInfo.class);
    public byte[] serverNonce;
    public byte[] clientNonce;
    public byte[] clientNonceHash;
    public String username;
    public byte[] password;
    public RSAKey key;
    public InetAddress address;
    public String seed;
    public MessageS2CLoginNACK.Reasons reason;
    public boolean usingSecureChannel = true;
    public String tokenType;
    public String token;

    public SecuredLoginInfo(RSAKey rSAKey, byte[] byArray, byte[] byArray2, InetAddress inetAddress) {
        this.key = rSAKey;
        this.clientNonceHash = Utility.copy(byArray);
        this.serverNonce = Utility.copy(byArray2);
        this.address = inetAddress;
    }

    public SecuredLoginInfo(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public void addLoginEvent(DBTransaction dBTransaction, InetAddress inetAddress, int n, Timestamp timestamp) throws SQLException {
        String string = null;
        try {
            Configuration configuration = Configuration.getConfiguration();
            string = configuration.has("server_service") ? configuration.get("server_service") : configuration.get("server_typeGame");
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
        }
        DAORegister.get().get(LoginEventDAO.class).addLoginEvent(dBTransaction, this.username, inetAddress, string, this.seed, n, timestamp);
    }

    public int countConnectionsFromSameIPAddress(PlayerEntryContainer playerEntryContainer) {
        if (this.address == null) {
            return 0;
        }
        int n = 0;
        for (PlayerEntry playerEntry : playerEntryContainer) {
            try {
                if (playerEntry.getAddress() == null || !this.address.getHostAddress().equals(playerEntry.getAddress().getHostAddress())) continue;
                ++n;
            }
            catch (NullPointerException nullPointerException) {
                logger.error(this.address);
                logger.error(this.address.getHostAddress());
                logger.error(playerEntry);
                logger.error(playerEntry);
                logger.error(playerEntry.getAddress());
                logger.error(nullPointerException, nullPointerException);
            }
        }
        return n;
    }

    public boolean isBlocked(DBTransaction dBTransaction) throws SQLException {
        LoginEventDAO loginEventDAO = DAORegister.get().get(LoginEventDAO.class);
        boolean bl = loginEventDAO.isAddressBlocked(dBTransaction, this.address.getHostAddress());
        if (bl) {
            return bl;
        }
        if (this.username == null) {
            return false;
        }
        return loginEventDAO.isAccountBlocked(dBTransaction, this.username);
    }

    public String getStatus(DBTransaction dBTransaction) throws SQLException {
        String string = null;
        if (DAORegister.get().get(AccountDAO.class).hasPlayer(dBTransaction, this.username)) {
            string = DAORegister.get().get(AccountDAO.class).getAccountBanMessage(dBTransaction, this.username);
        }
        return string;
    }

    public boolean isUsingSecureChannel() {
        return this.usingSecureChannel;
    }

    public byte[] getDecryptedPasswordHash() {
        if (!this.usingSecureChannel) {
            return this.password;
        }
        if (this.password == null) {
            return null;
        }
        byte[] byArray = this.key.decodeByteArray(this.password);
        byte[] byArray2 = Hash.xor(this.clientNonce, this.serverNonce);
        if (byArray2 == null) {
            logger.debug("B2 is null");
            return null;
        }
        byte[] byArray3 = Hash.xor(byArray, byArray2);
        if (this.password == null) {
            logger.debug("Password is null");
            return null;
        }
        return byArray3;
    }

    public String toString() {
        return "SecuredLoginInfo [username=" + this.username + ", address=" + this.address + ", seed=" + this.seed + ", reason=" + (Object)((Object)this.reason) + "]";
    }
}

