/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.TransactionPool;
import marauroa.server.net.validator.InetAddressMask;

public class BanListDAO {
    private static Logger logger = Log4J.getLogger(BanListDAO.class);

    public List<InetAddressMask> getBannedAddresses(DBTransaction dBTransaction) throws SQLException {
        LinkedList<InetAddressMask> linkedList = new LinkedList<InetAddressMask>();
        String string = "select address, mask from banlist";
        logger.debug("getBannedAddresses is executing query " + string);
        ResultSet resultSet = dBTransaction.query(string, null);
        linkedList.clear();
        while (resultSet.next()) {
            String string2 = resultSet.getString("address");
            String string3 = resultSet.getString("mask");
            InetAddressMask inetAddressMask = new InetAddressMask(string2, string3);
            linkedList.add(inetAddressMask);
        }
        resultSet.close();
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<InetAddressMask> getBannedAddresses() throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            List<InetAddressMask> list;
            List<InetAddressMask> list2 = list = this.getBannedAddresses(dBTransaction);
            return list2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }
}

