/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.db;

import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.RPObject;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.StringChecker;
import marauroa.server.db.TransactionPool;
import marauroa.server.game.db.AccountDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.db.RPObjectDAO;

public class CharacterDAO {
    private static final Logger logger = Log4J.getLogger(CharacterDAO.class);

    protected CharacterDAO() {
    }

    @Deprecated
    public void addCharacter(DBTransaction dBTransaction, String string, String string2, RPObject rPObject) throws SQLException, IOException {
        this.addCharacter(dBTransaction, string, string2, rPObject, new Timestamp(new java.util.Date().getTime()));
    }

    public void addCharacter(DBTransaction dBTransaction, String string, String string2, RPObject rPObject, Timestamp timestamp) throws SQLException, IOException {
        try {
            if (!StringChecker.validString(string) || !StringChecker.validString(string2)) {
                throw new SQLException("Invalid string username=(" + string + ") character=(" + string2 + ")");
            }
            int n = DAORegister.get().get(AccountDAO.class).getDatabasePlayerId(dBTransaction, string);
            int n2 = DAORegister.get().get(RPObjectDAO.class).storeRPObject(dBTransaction, rPObject);
            String string3 = "insert into characters(player_id, charname, object_id, status, timedate)values([player_id], '[character]', [object_id], '[status]', '[timedate]')";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("player_id", n);
            hashMap.put("object_id", n2);
            hashMap.put("character", string2);
            hashMap.put("status", Configuration.getConfiguration().get("character_creation_status", "active"));
            hashMap.put("timedate", timestamp);
            logger.debug("addCharacter is executing query " + string3);
            logger.debug("Character: " + rPObject);
            dBTransaction.execute(string3, hashMap);
        }
        catch (SQLException sQLException) {
            logger.error("Can't add player \"" + string + "\" character \"" + string2 + "\" to database", sQLException);
            throw sQLException;
        }
        catch (IOException iOException) {
            logger.error("Can't add player \"" + string + "\" character \"" + string2 + "\" to database", iOException);
            throw iOException;
        }
    }

    public boolean removeCharacter(DBTransaction dBTransaction, String string, String string2) throws SQLException {
        try {
            int n = DAORegister.get().get(AccountDAO.class).getDatabasePlayerId(dBTransaction, string);
            if (n < 0) {
                return false;
            }
            String string3 = "select object_id from characters where player_id=[player_id] and charname='[character]'";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("player_id", n);
            hashMap.put("character", string2);
            ResultSet resultSet = dBTransaction.query(string3, hashMap);
            if (!resultSet.next()) {
                resultSet.close();
                return false;
            }
            int n2 = resultSet.getInt("object_id");
            resultSet.close();
            DAORegister.get().get(RPObjectDAO.class).removeRPObject(dBTransaction, n2);
            string3 = "delete from characters where player_id=[player_id] and charname='[character]'";
            logger.debug("removeCharacter is using query: " + string3);
            dBTransaction.execute(string3, hashMap);
            return true;
        }
        catch (SQLException sQLException) {
            logger.error("Can't remove player \"" + string + "\" character \"" + string2 + "\" from database", sQLException);
            throw sQLException;
        }
    }

    public boolean hasCharacter(DBTransaction dBTransaction, String string) throws SQLException {
        try {
            String string2 = "SELECT charname FROM characters WHERE charname = '[character]'";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("character", string);
            logger.debug("hasCharacter is executing query " + string2);
            ResultSet resultSet = dBTransaction.query(string2, hashMap);
            String string3 = null;
            if (resultSet.next()) {
                string3 = resultSet.getString("charname");
            }
            resultSet.close();
            return string3 != null && string3.equalsIgnoreCase(string);
        }
        catch (SQLException sQLException) {
            logger.error("Can't query for character \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public boolean hasCharacter(DBTransaction dBTransaction, String string, String string2) throws SQLException {
        try {
            String string3 = "SELECT charname, username FROM characters, account  WHERE account.username='[username]' AND account.id=characters.player_id AND charname='[character]'";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            hashMap.put("character", string2);
            logger.debug("hasCharacter is executing query " + string3);
            ResultSet resultSet = dBTransaction.query(string3, hashMap);
            String string4 = null;
            String string5 = null;
            if (resultSet.next()) {
                string4 = resultSet.getString("charname");
                string5 = resultSet.getString("username");
            }
            resultSet.close();
            return string4 != null && string4.equalsIgnoreCase(string2) && string5 != null && string5.equalsIgnoreCase(string);
        }
        catch (SQLException sQLException) {
            logger.error("Can't query for player \"" + string + "\" character \"" + string2 + "\"", sQLException);
            throw sQLException;
        }
    }

    public boolean hasActiveCharacter(DBTransaction dBTransaction, String string, String string2) throws SQLException {
        try {
            String string3 = "SELECT charname, username FROM characters, account  WHERE account.username='[username]' AND account.id=characters.player_id  AND account.status='active' AND characters.status='active' AND charname='[character]'";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", string);
            hashMap.put("character", string2);
            logger.debug("hasCharacter is executing query " + string3);
            ResultSet resultSet = dBTransaction.query(string3, hashMap);
            String string4 = null;
            String string5 = null;
            if (resultSet.next()) {
                string4 = resultSet.getString("charname");
                string5 = resultSet.getString("username");
            }
            resultSet.close();
            return string4 != null && string4.equalsIgnoreCase(string2) && string5 != null && string5.equalsIgnoreCase(string);
        }
        catch (SQLException sQLException) {
            logger.error("Can't query for player \"" + string + "\" character \"" + string2 + "\"", sQLException);
            throw sQLException;
        }
    }

    public List<String> getCharacters(DBTransaction dBTransaction, String string) throws SQLException {
        try {
            int n = DAORegister.get().get(AccountDAO.class).getDatabasePlayerId(dBTransaction, string);
            if (n == -1) {
                throw new SQLException("Unable to find player(" + string + ")");
            }
            String string2 = "select charname from characters where player_id=[player_id] order by charname";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("player_id", n);
            logger.debug("getCharacterList is executing query " + string2);
            ResultSet resultSet = dBTransaction.query(string2, hashMap);
            LinkedList<String> linkedList = new LinkedList<String>();
            while (resultSet.next()) {
                linkedList.add(resultSet.getString("charname"));
            }
            resultSet.close();
            return linkedList;
        }
        catch (SQLException sQLException) {
            logger.error("Can't query for player \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    @Deprecated
    public void storeCharacter(DBTransaction dBTransaction, String string, String string2, RPObject rPObject) throws SQLException, IOException {
        this.storeCharacter(dBTransaction, string, string2, rPObject, new Timestamp(new java.util.Date().getTime()));
    }

    public void storeCharacter(DBTransaction dBTransaction, String string, String string2, RPObject rPObject, Timestamp timestamp) throws SQLException, IOException {
        try {
            if (!StringChecker.validString(string) || !StringChecker.validString(string2)) {
                throw new SQLException("Invalid string username=(" + string + ") character=(" + string2 + ")");
            }
            int n = DAORegister.get().get(RPObjectDAO.class).storeRPObject(dBTransaction, rPObject);
            int n2 = DAORegister.get().get(AccountDAO.class).getDatabasePlayerId(dBTransaction, string);
            String string3 = "update characters set object_id=[object_id] where charname='[character]' and player_id=[player_id]";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("object_id", n);
            hashMap.put("player_id", n2);
            hashMap.put("character", string2);
            logger.debug("storeCharacter is executing query " + string3);
            logger.debug("Character: " + rPObject);
            dBTransaction.execute(string3, hashMap);
        }
        catch (SQLException sQLException) {
            logger.warn("Error storing character: " + rPObject, sQLException);
            throw sQLException;
        }
        catch (IOException iOException) {
            logger.warn("Error storing character: " + rPObject, iOException);
            throw iOException;
        }
    }

    public RPObject loadCharacter(DBTransaction dBTransaction, String string, String string2) throws SQLException, IOException {
        try {
            int n = DAORegister.get().get(AccountDAO.class).getDatabasePlayerId(dBTransaction, string);
            String string3 = "select object_id from characters where charname='[character]' and player_id=[player_id]";
            logger.debug("loadCharacter is executing query " + string3);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("player_id", n);
            hashMap.put("character", string2);
            ResultSet resultSet = dBTransaction.query(string3, hashMap);
            RPObject rPObject = null;
            if (resultSet.next()) {
                int n2 = resultSet.getInt("object_id");
                rPObject = DAORegister.get().get(RPObjectDAO.class).loadRPObject(dBTransaction, n2);
                logger.debug("Character: " + rPObject);
            } else {
                logger.warn("No object for character " + string2 + " on account " + n + " username " + string);
            }
            resultSet.close();
            return rPObject;
        }
        catch (SQLException sQLException) {
            logger.warn("Error loading character: " + string2, sQLException);
            throw sQLException;
        }
        catch (IOException iOException) {
            logger.warn("Error loading character: " + string2, iOException);
            throw iOException;
        }
    }

    private Map<String, RPObject> loadAllCharacters(DBTransaction dBTransaction, String string, String string2) throws SQLException, IOException {
        try {
            LinkedHashMap<String, RPObject> linkedHashMap = new LinkedHashMap<String, RPObject>();
            int n = DAORegister.get().get(AccountDAO.class).getDatabasePlayerId(dBTransaction, string);
            String string3 = "SELECT characters.charname As charname, rpobject.data As data, rpobject.protocol_version As protocol_version, rpobject.object_id As object_id from characters, rpobject where rpobject.object_id=characters.object_id AND player_id=[player_id]" + string2 + " ORDER BY characters.charname";
            logger.debug("loadAllCharacters is executing query " + string3);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("player_id", n);
            ResultSet resultSet = dBTransaction.query(string3, hashMap);
            while (resultSet.next()) {
                int n2 = resultSet.getInt("object_id");
                String string4 = resultSet.getString("charname");
                byte[] byArray = resultSet.getBytes("data");
                int n3 = 32;
                Object object = resultSet.getObject("protocol_version");
                if (object != null) {
                    n3 = (Integer)object;
                }
                RPObject rPObject = DAORegister.get().get(RPObjectDAO.class).readRPObject(n2, byArray, n3, false);
                logger.debug("Character: " + rPObject);
                linkedHashMap.put(string4, rPObject);
            }
            resultSet.close();
            return linkedHashMap;
        }
        catch (SQLException sQLException) {
            logger.warn("Error loading characters for account: " + string, sQLException);
            throw sQLException;
        }
        catch (IOException iOException) {
            logger.warn("Error loading characters for account: " + string, iOException);
            throw iOException;
        }
    }

    public Map<String, RPObject> loadAllCharacters(DBTransaction dBTransaction, String string) throws SQLException, IOException {
        return this.loadAllCharacters(dBTransaction, string, "");
    }

    public Map<String, RPObject> loadAllActiveCharacters(DBTransaction dBTransaction, String string) throws SQLException, IOException {
        return this.loadAllCharacters(dBTransaction, string, " AND characters.status='active' ");
    }

    public String getAccountName(DBTransaction dBTransaction, String string) throws SQLException {
        String string2 = null;
        String string3 = "SELECT username FROM account, characters WHERE characters.charname='[charname]' AND characters.player_id=account.id";
        logger.debug("getAccountName is executing query " + string3);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("charname", string);
        ResultSet resultSet = dBTransaction.query(string3, hashMap);
        if (resultSet.next()) {
            string2 = resultSet.getString("username");
        }
        resultSet.close();
        return string2;
    }

    public String getCanonicalName(DBTransaction dBTransaction, String string) throws SQLException {
        String string2 = null;
        String string3 = "SELECT charname FROM characters WHERE charname='[charname]'";
        logger.debug("getCanonicalName is executing query " + string3);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("charname", string);
        ResultSet resultSet = dBTransaction.query(string3, hashMap);
        if (resultSet.next()) {
            string2 = resultSet.getString("charname");
        }
        resultSet.close();
        return string2;
    }

    public boolean isCharacterCreationLimitReached(DBTransaction dBTransaction, String string, String string2) throws IOException, SQLException {
        Configuration configuration = Configuration.getConfiguration();
        String string3 = "," + configuration.get("ip_whitelist", "127.0.0.1") + ",";
        if (string3.indexOf("," + string2 + ",") > -1) {
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("address", string2);
        hashMap.put("username", string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(13, -1 * configuration.getInt("character_creation_counting_time", 3600));
        hashMap.put("timestamp", new Timestamp(gregorianCalendar.getTimeInMillis()).toString());
        String string4 = "SELECT count(DISTINCT charname) FROM characters, account WHERE characters.player_id=account.id AND account.username='[username]' AND characters.timedate>'[timestamp]'";
        int n = dBTransaction.querySingleCellInt(string4, hashMap);
        if (n > configuration.getInt("character_creation_limit", 5)) {
            return true;
        }
        string4 = "SELECT count(DISTINCT charname) FROM characters, account, loginEvent WHERE characters.player_id=account.id AND account.id=loginEvent.player_id AND address='[address]' AND characters.timedate>'[timestamp]'";
        n = dBTransaction.querySingleCellInt(string4, hashMap);
        return n > configuration.getInt("character_creation_limit", 5);
    }

    public java.util.Date getCreationDate(DBTransaction dBTransaction, String string) throws SQLException {
        try {
            String string2 = "SELECT timedate FROM characters WHERE charname = '[character]'";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("character", string);
            logger.debug("getCreationDate is executing query " + string2);
            ResultSet resultSet = dBTransaction.query(string2, hashMap);
            Date date = null;
            if (resultSet.next()) {
                date = resultSet.getDate("timedate");
            }
            resultSet.close();
            return date;
        }
        catch (SQLException sQLException) {
            logger.error("Can't query date for character \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public void setCharacterStatus(DBTransaction dBTransaction, String string, String string2, String string3) throws SQLException, IOException {
        if (!this.hasCharacter(dBTransaction, string, string2)) {
            throw new SQLException("User: " + string + " doesn't have character: " + string2);
        }
        int n = DAORegister.get().get(AccountDAO.class).getDatabasePlayerId(dBTransaction, string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string4 = "update characters set status ='[status]' where charname = '[character]'and player_id = [player_id]";
        hashMap.put("player_id", n);
        hashMap.put("character", string2);
        hashMap.put("status", string3);
        logger.debug("setCharacterStatus is executing query " + string4);
        dBTransaction.execute(string4, hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addCharacter(String string, String string2, RPObject rPObject) throws SQLException, IOException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.addCharacter(dBTransaction, string, string2, rPObject);
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean removeCharacter(String string, String string2) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.removeCharacter(dBTransaction, string, string2);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean hasCharacter(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.hasCharacter(dBTransaction, string);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean hasCharacter(String string, String string2) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.hasCharacter(dBTransaction, string, string2);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean hasActiveCharacter(String string, String string2) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.hasActiveCharacter(dBTransaction, string, string2);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<String> getCharacters(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            List<String> list;
            List<String> list2 = list = this.getCharacters(dBTransaction, string);
            return list2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void storeCharacter(String string, String string2, RPObject rPObject) throws SQLException, IOException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.storeCharacter(dBTransaction, string, string2, rPObject);
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public RPObject loadCharacter(String string, String string2) throws SQLException, IOException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            RPObject rPObject;
            RPObject rPObject2 = rPObject = this.loadCharacter(dBTransaction, string, string2);
            return rPObject2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Map<String, RPObject> loadAllCharacters(String string) throws SQLException, IOException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            Map<String, RPObject> map;
            Map<String, RPObject> map2 = map = this.loadAllCharacters(dBTransaction, string);
            return map2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Map<String, RPObject> loadAllActiveCharacters(String string) throws SQLException, IOException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            Map<String, RPObject> map;
            Map<String, RPObject> map2 = map = this.loadAllActiveCharacters(dBTransaction, string);
            return map2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getAccountName(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            String string2;
            String string3 = string2 = this.getAccountName(dBTransaction, string);
            return string3;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getCanonicalName(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            String string2;
            String string3 = string2 = this.getCanonicalName(dBTransaction, string);
            return string3;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isCharacterCreationLimitReached(String string, String string2) throws IOException, SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl = this.isCharacterCreationLimitReached(dBTransaction, string, string2);
            return bl;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public java.util.Date getCreationDate(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            java.util.Date date;
            java.util.Date date2 = date = this.getCreationDate(dBTransaction, string);
            return date2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setCharacterStatus(String string, String string2, String string3) throws SQLException, IOException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.setCharacterStatus(dBTransaction, string, string2, string3);
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }
}

