/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.db;

import java.net.InetAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.Pair;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.TransactionPool;
import marauroa.server.game.db.AccountDAO;
import marauroa.server.game.db.DAORegister;

public class LoginEventDAO {
    private static final Logger logger = Log4J.getLogger(LoginEventDAO.class);

    protected LoginEventDAO() {
    }

    @Deprecated
    public void addLoginEvent(DBTransaction dBTransaction, String string, InetAddress inetAddress, String string2, String string3, int n) throws SQLException {
        this.addLoginEvent(dBTransaction, string, inetAddress, string2, string3, n, new Timestamp(new Date().getTime()));
    }

    public void addLoginEvent(DBTransaction dBTransaction, String string, InetAddress inetAddress, String string2, String string3, int n, Timestamp timestamp) throws SQLException {
        try {
            int n2 = DAORegister.get().get(AccountDAO.class).getDatabasePlayerId(dBTransaction, string);
            String string4 = "insert into loginEvent(player_id, address, service, seed, result, timedate) values ([player_id], '[address]', '[service]', '[seed]', [result], '[timedate]')";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("player_id", n2);
            hashMap.put("address", inetAddress.getHostAddress());
            hashMap.put("result", n);
            if (string2 != null) {
                hashMap.put("service", string2);
            }
            if (string3 == null) {
                hashMap.put("seed", "");
            } else {
                hashMap.put("seed", string3);
            }
            hashMap.put("timedate", timestamp);
            dBTransaction.execute(string4, hashMap);
        }
        catch (SQLException sQLException) {
            logger.error("Can't query for player \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public List<String> getLoginEvents(DBTransaction dBTransaction, String string, int n) throws SQLException {
        try {
            int n2 = DAORegister.get().get(AccountDAO.class).getDatabasePlayerId(dBTransaction, string);
            if (n2 == -1) {
                throw new SQLException("Unable to find player(" + string + ")");
            }
            String string2 = "select address, timedate, result from loginEvent where player_id=[player_id] order by timedate desc limit [events]";
            logger.debug("getLoginEvents is executing query " + string2);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("player_id", n2);
            hashMap.put("events", n);
            ResultSet resultSet = dBTransaction.query(string2, hashMap);
            LinkedList<String> linkedList = new LinkedList<String>();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            while (resultSet.next()) {
                LoginEvent loginEvent = new LoginEvent(resultSet.getString("address"), simpleDateFormat.format(resultSet.getTimestamp("timedate")), resultSet.getBoolean("result"));
                linkedList.add(loginEvent.toString());
            }
            resultSet.close();
            return linkedList;
        }
        catch (SQLException sQLException) {
            logger.error("Can't query for player \"" + string + "\"", sQLException);
            throw sQLException;
        }
    }

    public LoginEvent getLastSuccessfulLoginEvent(DBTransaction dBTransaction, int n, String string) throws SQLException {
        try {
            String string2 = "";
            if (string != null) {
                string2 = " AND service='[service]'";
            }
            String string3 = "SELECT id, player_id, service, address, timedate, result FROM loginEvent WHERE player_id=[player_id] AND result=1" + string2 + " ORDER BY timedate desc LIMIT 2";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("service", string);
            hashMap.put("player_id", Integer.toString(n));
            logger.debug("getLastSuccessfulLoginEvent is executing query " + string3);
            ResultSet resultSet = dBTransaction.query(string3, hashMap);
            if (!resultSet.next()) {
                resultSet.close();
                return null;
            }
            if (!resultSet.next()) {
                resultSet.close();
                return null;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            LoginEvent loginEvent = new LoginEvent(resultSet.getLong("id"), resultSet.getLong("player_id"), resultSet.getString("service"), resultSet.getString("address"), simpleDateFormat.format(resultSet.getTimestamp("timedate")), resultSet.getBoolean("result"));
            resultSet.close();
            return loginEvent;
        }
        catch (SQLException sQLException) {
            logger.error("Can't query for player \"" + n + "\"", sQLException);
            throw sQLException;
        }
    }

    public List<Pair<String, Long>> getAmountOfFailedLogins(DBTransaction dBTransaction, long l, int n) throws SQLException {
        try {
            String string = "SELECT service, count(*) FROM loginEvent WHERE player_id=[player_id] + AND id > [id] AND result = 0 GROUP BY service";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", Long.toString(l));
            hashMap.put("player_id", Integer.toString(n));
            logger.debug("getAmountOfFailedLogins is executing query " + string);
            ResultSet resultSet = dBTransaction.query(string, hashMap);
            LinkedList<Pair<String, Long>> linkedList = new LinkedList<Pair<String, Long>>();
            while (resultSet.next()) {
                linkedList.add(new Pair<String, Long>(resultSet.getString(1), resultSet.getLong(2)));
            }
            resultSet.close();
            return linkedList;
        }
        catch (SQLException sQLException) {
            logger.error("Can't query for player \"" + n + "\"", sQLException);
            throw sQLException;
        }
    }

    public boolean isAccountBlocked(DBTransaction dBTransaction, String string) throws SQLException {
        String string2 = "SELECT count(*) as amount FROM loginEvent, account WHERE loginEvent.player_id=account.id AND username='[username]' AND loginEvent.result != 1 and loginEvent.timedate > '[timestamp]'";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("username", string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(13, -600);
        hashMap.put("timestamp", new Timestamp(gregorianCalendar.getTimeInMillis()).toString());
        int n = dBTransaction.querySingleCellInt(string2, hashMap);
        return n > 10;
    }

    public boolean isAddressBlocked(DBTransaction dBTransaction, String string) throws SQLException {
        String string2 = "SELECT count(*) as amount FROM loginEvent WHERE address='[address]' AND result != 1 and timedate > '[timestamp]'";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("address", string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(13, -600);
        hashMap.put("timestamp", new Timestamp(gregorianCalendar.getTimeInMillis()).toString());
        int n = dBTransaction.querySingleCellInt(string2, hashMap);
        return n > 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addLoginEvent(String string, InetAddress inetAddress, String string2, String string3, int n) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.addLoginEvent(dBTransaction, string, inetAddress, string2, string3, n);
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<String> getLoginEvents(String string, int n) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            List<String> list;
            List<String> list2 = list = this.getLoginEvents(dBTransaction, string, n);
            return list2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isAccountBlocked(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.isAccountBlocked(dBTransaction, string);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isAddressBlocked(String string) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.isAddressBlocked(dBTransaction, string);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    public static class LoginEvent {
        private long id = -1L;
        private long playerId = -1L;
        private String service = null;
        public String address;
        public String date;
        public boolean correct;

        public LoginEvent(String string, String string2, boolean bl) {
            this.address = string;
            this.date = string2;
            this.correct = bl;
        }

        public LoginEvent(long l, long l2, String string, String string2, String string3, boolean bl) {
            this(string2, string3, bl);
            this.id = l;
            this.playerId = l2;
            this.service = string;
        }

        public String toString() {
            return "Login " + (this.correct ? "successful" : "FAILED") + " at " + this.date + " server time from " + this.address;
        }

        public long getId() {
            return this.id;
        }

        public long getPlayerId() {
            return this.playerId;
        }

        public String getService() {
            return this.service;
        }

        public String getAddress() {
            return this.address;
        }

        public String getDate() {
            return this.date;
        }

        public boolean isSuccessful() {
            return this.correct;
        }
    }
}

