/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.RPObject;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.TransactionPool;
import marauroa.server.game.rp.RPObjectFactory;

public class RPObjectDAO {
    private static final Logger logger = Log4J.getLogger(RPObjectDAO.class);
    protected RPObjectFactory factory;

    protected RPObjectDAO(RPObjectFactory rPObjectFactory) {
        this.factory = rPObjectFactory;
    }

    public RPObject loadRPObject(DBTransaction dBTransaction, int n) throws SQLException, IOException {
        return this.loadRPObject(dBTransaction, n, true);
    }

    public RPObject loadRPObject(DBTransaction dBTransaction, int n, boolean bl) throws SQLException, IOException {
        String string = "select data, protocol_version from rpobject where object_id=[objectid]";
        logger.debug("loadRPObject is executing query " + string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("objectid", n);
        ResultSet resultSet = dBTransaction.query(string, hashMap);
        if (resultSet.next()) {
            byte[] byArray = resultSet.getBytes("data");
            int n2 = 32;
            Object object = resultSet.getObject("protocol_version");
            if (object != null) {
                n2 = (Integer)object;
            }
            RPObject rPObject = this.readRPObject(n, byArray, n2, bl);
            resultSet.close();
            return rPObject;
        }
        resultSet.close();
        return null;
    }

    public RPObject readRPObject(int n, byte[] byArray, int n2, boolean bl) throws SQLException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        int n3 = 0;
        while ((n3 = byteArrayInputStream.read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n3);
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        ((InputStream)byteArrayInputStream).close();
        byteArrayOutputStream.close();
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray3);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream2, new Inflater());
        InputSerializer inputSerializer = new InputSerializer(inflaterInputStream);
        inputSerializer.setProtocolVersion(n2);
        RPObject rPObject = (RPObject)inputSerializer.readObject(new RPObject());
        if (bl) {
            rPObject = this.factory.transform(rPObject);
        }
        rPObject.put("#db_id", n);
        return rPObject;
    }

    public int removeRPObject(DBTransaction dBTransaction, int n) throws SQLException {
        String string = "delete from rpobject where object_id=[objectid]";
        logger.debug("removeRPObject is executing query " + string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("objectid", n);
        dBTransaction.execute(string, hashMap);
        return n;
    }

    public boolean hasRPObject(DBTransaction dBTransaction, int n) throws SQLException {
        String string = "select count(*) as amount from rpobject where object_id=[objectid]";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("objectid", n);
        logger.debug("hasRPObject is executing query " + string);
        int n2 = dBTransaction.querySingleCellInt(string, hashMap);
        return n2 > 0;
    }

    public int storeRPObject(DBTransaction dBTransaction, RPObject rPObject) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        OutputSerializer outputSerializer = new OutputSerializer(deflaterOutputStream);
        int n = outputSerializer.getProtocolVersion();
        try {
            rPObject.writeObject(outputSerializer, DetailLevel.FULL);
            deflaterOutputStream.close();
        }
        catch (IOException iOException) {
            logger.warn("Error while serializing rpobject: " + rPObject, iOException);
            throw iOException;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        int n2 = -1;
        if (rPObject.has("#db_id")) {
            n2 = rPObject.getInt("#db_id");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("object_id", n2);
        hashMap.put("protocolVersion", n);
        String string = n2 != -1 && this.hasRPObject(dBTransaction, n2) ? "update rpobject set data=?, protocol_version=[protocolVersion] where object_id=[object_id]" : "insert into rpobject (data, protocol_version) values(?, [protocolVersion])";
        logger.debug("storeRPObject is executing query " + string);
        dBTransaction.execute(string, hashMap, byteArrayInputStream);
        if (n2 == -1) {
            n2 = dBTransaction.getLastInsertId("rpobject", "object_id");
            rPObject.put("#db_id", n2);
        } else {
            n2 = rPObject.getInt("#db_id");
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public RPObject loadRPObject(int n, boolean bl) throws SQLException, IOException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            RPObject rPObject;
            RPObject rPObject2 = rPObject = this.loadRPObject(dBTransaction, n, bl);
            return rPObject2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public RPObject loadRPObject(int n) throws SQLException, IOException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            RPObject rPObject;
            RPObject rPObject2 = rPObject = this.loadRPObject(dBTransaction, n, true);
            return rPObject2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int removeRPObject(int n) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            int n2;
            int n3 = n2 = this.removeRPObject(dBTransaction, n);
            return n3;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean hasRPObject(int n) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.hasRPObject(dBTransaction, n);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int storeRPObject(RPObject rPObject) throws IOException, SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            int n;
            int n2 = n = this.storeRPObject(dBTransaction, rPObject);
            return n2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }
}

