/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.dbcommand;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import marauroa.common.net.Channel;
import marauroa.common.net.message.MessageS2CLoginNACK;
import marauroa.server.db.DBTransaction;
import marauroa.server.game.container.SecuredLoginInfo;
import marauroa.server.game.db.AccountDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.db.LoginEventDAO;
import marauroa.server.game.dbcommand.DBCommandWithCallback;
import marauroa.server.game.messagehandler.DelayedEventHandler;

public class LoginCommand
extends DBCommandWithCallback {
    private SecuredLoginInfo info;
    private MessageS2CLoginNACK.Reasons failReason = null;
    private String failMessage = null;
    private List<String> previousLogins;

    public LoginCommand(SecuredLoginInfo securedLoginInfo) {
        this.info = securedLoginInfo;
    }

    public LoginCommand(SecuredLoginInfo securedLoginInfo, DelayedEventHandler delayedEventHandler, int n, Channel channel, int n2) {
        super(delayedEventHandler, n, channel, n2);
        this.info = securedLoginInfo;
    }

    @Override
    public void execute(DBTransaction dBTransaction) throws SQLException, IOException {
        if (!this.blockCheck(dBTransaction)) {
            return;
        }
        if (!this.credentialsCheck(dBTransaction)) {
            return;
        }
        if (!this.accountStatusCheck(dBTransaction)) {
            return;
        }
        this.processSuccessfulLogin(dBTransaction);
    }

    protected boolean blockCheck(DBTransaction dBTransaction) throws SQLException {
        if (this.info.isBlocked(dBTransaction)) {
            this.failReason = MessageS2CLoginNACK.Reasons.TOO_MANY_TRIES;
            this.info.addLoginEvent(dBTransaction, this.info.address, 4, this.getEnqueueTime());
            return false;
        }
        return true;
    }

    protected boolean verify(DBTransaction dBTransaction) throws SQLException, IOException {
        return DAORegister.get().get(AccountDAO.class).verify(dBTransaction, this.info);
    }

    protected boolean credentialsCheck(DBTransaction dBTransaction) throws SQLException, IOException {
        boolean bl = this.verify(dBTransaction);
        if (!bl) {
            if (this.info.reason == null) {
                this.info.reason = MessageS2CLoginNACK.Reasons.USERNAME_WRONG;
            }
            this.failReason = this.info.reason;
            this.info.addLoginEvent(dBTransaction, this.info.address, 0, this.getEnqueueTime());
            return false;
        }
        return true;
    }

    protected boolean accountStatusCheck(DBTransaction dBTransaction) throws SQLException {
        String string = DAORegister.get().get(AccountDAO.class).getAccountBanMessage(dBTransaction, this.info.username);
        if (string != null) {
            String string2 = DAORegister.get().get(AccountDAO.class).getAccountStatus(dBTransaction, this.info.username);
            if (string2 != null) {
                if (string2.equals("banned")) {
                    this.info.addLoginEvent(dBTransaction, this.info.address, 2, this.getEnqueueTime());
                } else if (string2.equals("inactive")) {
                    this.info.addLoginEvent(dBTransaction, this.info.address, 3, this.getEnqueueTime());
                } else if (string2.equals("merged")) {
                    this.info.addLoginEvent(dBTransaction, this.info.address, 5, this.getEnqueueTime());
                }
            }
            this.failMessage = string;
            return false;
        }
        return true;
    }

    protected void processSuccessfulLogin(DBTransaction dBTransaction) throws SQLException {
        this.previousLogins = DAORegister.get().get(LoginEventDAO.class).getLoginEvents(dBTransaction, this.info.username, 1);
        this.info.addLoginEvent(dBTransaction, this.info.address, 1, this.getEnqueueTime());
    }

    public SecuredLoginInfo getInfo() {
        return this.info;
    }

    public MessageS2CLoginNACK.Reasons getFailReason() {
        return this.failReason;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public List<String> getPreviousLogins() {
        return new LinkedList<String>(this.previousLogins);
    }

    public String toString() {
        return "LoginCommand [info=" + this.info + ", failReason=" + (Object)((Object)this.failReason) + ", failMessage=" + this.failMessage + ", previousLogins=" + this.previousLogins + "]";
    }
}

