/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.dbcommand;

import java.io.IOException;
import java.sql.SQLException;
import marauroa.common.game.RPObject;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.command.AbstractDBCommand;
import marauroa.server.db.command.DBCommandPriority;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.db.CharacterDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.dbcommand.SetCharacterStatusCommand;
import org.apache.log4j.Logger;

public class StoreCharacterCommand
extends AbstractDBCommand {
    private Logger logger = Logger.getLogger(StoreCharacterCommand.class);
    private final String username;
    private final String character;
    private final RPObject frozenObject;

    public StoreCharacterCommand(String string, String string2, RPObject rPObject) {
        this.username = string;
        this.character = string2;
        this.frozenObject = (RPObject)rPObject.clone();
    }

    @Override
    public void execute(DBTransaction dBTransaction) throws SQLException, IOException {
        try {
            DAORegister.get().get(CharacterDAO.class).storeCharacter(dBTransaction, this.username, this.character, this.frozenObject, this.getEnqueueTime());
        }
        catch (SQLException sQLException) {
            if (!dBTransaction.isConnectionError(sQLException)) {
                this.handleStorageFailure();
            }
            throw sQLException;
        }
        catch (IOException iOException) {
            this.handleStorageFailure();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleStorageFailure();
            throw runtimeException;
        }
    }

    private void handleStorageFailure() throws SQLException, IOException {
        this.logger.error((Object)("Disabling character " + this.character + " because of storage error."));
        DBCommandQueue.get().enqueue(new SetCharacterStatusCommand(this.username, this.character, "inactive"), DBCommandPriority.CRITICAL);
    }

    public String toString() {
        return "StoreCharacterCommand [username=" + this.username + ", character=" + this.character + "]";
    }
}

