/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.AccountResult;
import marauroa.common.game.Result;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SCreateAccount;
import marauroa.common.net.message.MessageP2SCreateAccount;
import marauroa.common.net.message.MessageS2CCreateAccountACK;
import marauroa.common.net.message.MessageS2CCreateAccountNACK;
import marauroa.server.game.messagehandler.MessageHandler;

class CreateAccountHandler
extends MessageHandler {
    private static final Logger logger = Log4J.getLogger(CreateAccountHandler.class);

    CreateAccountHandler() {
    }

    @Override
    public void process(Message message) {
        try {
            Object object;
            if (this.rpMan == null || message == null || message.getAddress() == null) {
                logger.error("Unexpected null value in CreateAccountHandler.process: rpMan=" + this.rpMan + " msg=" + message);
                if (message != null) {
                    logger.error("addres=" + message.getAddress());
                }
                return;
            }
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (message instanceof MessageC2SCreateAccount) {
                object = (MessageC2SCreateAccount)message;
                string = ((MessageC2SCreateAccount)object).getUsername();
                string2 = ((MessageC2SCreateAccount)object).getPassword();
                string3 = ((MessageC2SCreateAccount)object).getEmail();
                string4 = ((Message)object).getAddress().getHostAddress();
            } else {
                object = (MessageP2SCreateAccount)message;
                if (((MessageP2SCreateAccount)object).getCredentials() == null || !((MessageP2SCreateAccount)object).getCredentials().equals(Configuration.getConfiguration().get("proxy_credentials"))) {
                    logger.warn("Invalid credentials for proxy method.");
                    return;
                }
                string = ((MessageP2SCreateAccount)object).getUsername();
                string2 = ((MessageP2SCreateAccount)object).getPassword();
                string3 = ((MessageP2SCreateAccount)object).getEmail();
                string4 = ((MessageP2SCreateAccount)object).getForwardedFor();
            }
            object = this.rpMan.createAccount(string, string2, string3, string4);
            Result result = ((AccountResult)object).getResult();
            if (result == Result.OK_CREATED) {
                logger.debug("Account (" + string + ") created.");
                MessageS2CCreateAccountACK messageS2CCreateAccountACK = new MessageS2CCreateAccountACK(message.getChannel(), ((AccountResult)object).getUsername());
                messageS2CCreateAccountACK.setProtocolVersion(message.getProtocolVersion());
                this.netMan.sendMessage(messageS2CCreateAccountACK);
            } else {
                MessageS2CCreateAccountNACK messageS2CCreateAccountNACK = new MessageS2CCreateAccountNACK(message.getChannel(), string, result);
                messageS2CCreateAccountNACK.setProtocolVersion(message.getProtocolVersion());
                this.netMan.sendMessage(messageS2CCreateAccountNACK);
            }
        }
        catch (Exception exception) {
            logger.error("Unable to create an account", exception);
        }
    }
}

