/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.rp;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.IRPZone;
import marauroa.common.game.Perception;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPObjectInvalidException;
import marauroa.server.db.command.DBCommandPriority;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.db.RPZoneDAO;
import marauroa.server.game.dbcommand.StoreZoneCommand;

public class MarauroaRPZone
implements IRPZone {
    private static final Logger logger = Log4J.getLogger(MarauroaRPZone.class);
    protected IRPZone.ID zoneid;
    protected Map<RPObject.ID, RPObject> objects;
    private Set<RPObject> modified;
    private Perception perception;
    private Perception prebuildDeltaPerception = null;
    private Perception prebuildSyncPerception = null;
    private int lastNonPermanentIdAssigned = 0;
    private static Random rand = new Random();

    public MarauroaRPZone(String string) {
        this.zoneid = new IRPZone.ID(string);
        rand.setSeed(new Date().getTime());
        this.objects = new ConcurrentHashMap<RPObject.ID, RPObject>();
        this.modified = new HashSet<RPObject>();
        this.perception = new Perception(0, this.zoneid);
    }

    @Override
    public IRPZone.ID getID() {
        return this.zoneid;
    }

    @Override
    public void onFinish() throws Exception {
        this.storeToDatabase();
    }

    public void storeToDatabase() {
        LinkedList<RPObject> linkedList = new LinkedList<RPObject>();
        for (RPObject rPObject : this.objects.values()) {
            linkedList.add((RPObject)rPObject.clone());
        }
        DBCommandQueue.get().enqueue(new StoreZoneCommand(this, linkedList), DBCommandPriority.CRITICAL);
    }

    @Override
    public void onInit() throws Exception {
        DAORegister.get().get(RPZoneDAO.class).loadRPZone(this);
    }

    @Override
    public void add(RPObject rPObject) throws RPObjectInvalidException {
        try {
            RPObject.ID iD = rPObject.getID();
            rPObject.resetAddedAndDeleted();
            this.objects.put(iD, rPObject);
            if (!rPObject.isHidden()) {
                this.perception.added(rPObject);
            }
        }
        catch (Exception exception) {
            throw new RPObjectInvalidException(exception);
        }
    }

    @Override
    public void modify(RPObject rPObject) throws RPObjectInvalidException {
        try {
            this.modified.add(rPObject);
        }
        catch (Exception exception) {
            throw new RPObjectInvalidException(exception.getMessage());
        }
    }

    @Override
    public RPObject remove(RPObject.ID iD) {
        RPObject rPObject = this.objects.remove(iD);
        if (rPObject != null) {
            RPObject rPObject2 = new RPObject();
            rPObject2.setID(rPObject.getID());
            rPObject2.setRPClass(rPObject.getRPClass());
            this.modified.remove(rPObject);
            this.perception.removed(rPObject2);
        }
        return rPObject;
    }

    @Override
    public void hide(RPObject rPObject) {
        rPObject.hide();
        RPObject rPObject2 = new RPObject();
        rPObject2.setID(rPObject.getID());
        rPObject2.setRPClass(rPObject.getRPClass());
        this.perception.removed(rPObject2);
    }

    @Override
    public void unhide(RPObject rPObject) {
        rPObject.unhide();
        rPObject.resetAddedAndDeleted();
        this.perception.added(rPObject);
    }

    @Override
    public RPObject get(RPObject.ID iD) {
        return this.objects.get(iD);
    }

    @Override
    public boolean has(RPObject.ID iD) {
        return this.objects.containsKey(iD);
    }

    @Override
    public void assignRPObjectID(RPObject rPObject) {
        RPObject.ID iD = new RPObject.ID(++this.lastNonPermanentIdAssigned, this.zoneid);
        while (this.has(iD)) {
            iD = new RPObject.ID(++this.lastNonPermanentIdAssigned, this.zoneid);
        }
        rPObject.put("id", iD.getObjectID());
        rPObject.put("zoneid", this.zoneid.getID());
    }

    @Override
    public Iterator<RPObject> iterator() {
        return this.objects.values().iterator();
    }

    @Override
    public Perception getPerception(RPObject rPObject, byte by) {
        if (by == 0) {
            if (this.prebuildDeltaPerception == null) {
                this.prebuildDeltaPerception = this.perception;
                for (RPObject rPObject2 : this.modified) {
                    if (rPObject2.isHidden()) continue;
                    try {
                        if (logger.isDebugEnabled() && !this.has(rPObject2.getID())) {
                            logger.debug("Modifying a non existing object: " + rPObject2);
                        }
                        this.prebuildDeltaPerception.modified(rPObject2);
                    }
                    catch (Exception exception) {
                        logger.error("cannot add object to modified list (object is: [" + rPObject2 + "])", exception);
                    }
                }
            }
            return this.prebuildDeltaPerception;
        }
        if (this.prebuildSyncPerception == null) {
            this.prebuildSyncPerception = new Perception(1, this.getID());
            this.prebuildSyncPerception.addedList = new ArrayList<RPObject>(this.objects.size());
            for (RPObject rPObject3 : this.objects.values()) {
                if (rPObject3.isHidden()) continue;
                this.prebuildSyncPerception.addedList.add(rPObject3);
            }
        }
        return this.prebuildSyncPerception;
    }

    protected void reset() {
        for (RPObject rPObject : this.modified) {
            rPObject.resetAddedAndDeleted();
        }
    }

    @Override
    public long size() {
        return this.objects.size();
    }

    public void print(PrintStream printStream) {
        for (RPObject rPObject : this.objects.values()) {
            printStream.println(rPObject);
        }
    }

    @Override
    public void nextTurn() {
        this.reset();
        this.prebuildSyncPerception = null;
        this.prebuildDeltaPerception = null;
        this.modified.clear();
        this.perception.clear();
    }
}

