/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.rp;

import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.crypto.Hash;
import marauroa.common.game.AccountResult;
import marauroa.common.game.CharacterResult;
import marauroa.common.game.IRPZone;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.common.game.Result;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.TransactionPool;
import marauroa.server.game.db.AccountDAO;
import marauroa.server.game.db.CharacterDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.rp.IRPRuleProcessor;
import marauroa.server.game.rp.RPServerManager;
import marauroa.server.game.rp.RPWorld;

public class RPRuleProcessorImpl
implements IRPRuleProcessor {
    private static RPRuleProcessorImpl instance;
    protected RPServerManager manager;
    private static Logger logger;

    public static IRPRuleProcessor get() {
        if (instance == null) {
            instance = new RPRuleProcessorImpl();
        }
        return instance;
    }

    @Override
    public void setContext(RPServerManager rPServerManager) {
        this.manager = rPServerManager;
    }

    @Override
    public boolean checkGameVersion(String string, String string2) {
        return true;
    }

    @Override
    public synchronized void onTimeout(RPObject rPObject) {
        this.onExit(rPObject);
    }

    @Override
    public synchronized boolean onExit(RPObject rPObject) {
        RPWorld.get().remove(rPObject.getID());
        return true;
    }

    @Override
    public synchronized boolean onInit(RPObject rPObject) {
        IRPZone iRPZone = RPWorld.get().getDefaultZone();
        iRPZone.add(rPObject);
        return true;
    }

    @Override
    public synchronized void beginTurn() {
    }

    @Override
    public boolean onActionAdd(RPObject rPObject, RPAction rPAction, List<RPAction> list) {
        return true;
    }

    @Override
    public synchronized void endTurn() {
    }

    @Override
    public void execute(RPObject rPObject, RPAction rPAction) {
        logger.info(rPObject + " executed action " + rPAction);
    }

    @Override
    public AccountResult createAccount(String string, String string2, String string3) {
        TransactionPool transactionPool = TransactionPool.get();
        DBTransaction dBTransaction = transactionPool.beginWork();
        AccountDAO accountDAO = DAORegister.get().get(AccountDAO.class);
        try {
            if (accountDAO.hasPlayer(dBTransaction, string)) {
                return new AccountResult(Result.FAILED_PLAYER_EXISTS, string);
            }
            accountDAO.addPlayer(dBTransaction, string, Hash.hash(string2), string3, new Timestamp(new Date().getTime()));
            transactionPool.commit(dBTransaction);
            return new AccountResult(Result.OK_CREATED, string);
        }
        catch (SQLException sQLException) {
            logger.error(sQLException, sQLException);
            transactionPool.rollback(dBTransaction);
            return new AccountResult(Result.FAILED_EXCEPTION, string);
        }
    }

    @Override
    public AccountResult createAccountWithToken(String string, String string2, String string3) {
        return new AccountResult(Result.FAILED_EXCEPTION, string);
    }

    @Override
    public CharacterResult createCharacter(String string, String string2, RPObject rPObject) {
        TransactionPool transactionPool = TransactionPool.get();
        DBTransaction dBTransaction = transactionPool.beginWork();
        CharacterDAO characterDAO = DAORegister.get().get(CharacterDAO.class);
        try {
            if (characterDAO.hasCharacter(dBTransaction, string, string2)) {
                return new CharacterResult(Result.FAILED_CHARACTER_EXISTS, string2, rPObject);
            }
            RPObject rPObject2 = this.createCharacterObject(string, string2, rPObject);
            IRPZone iRPZone = RPWorld.get().getDefaultZone();
            iRPZone.assignRPObjectID(rPObject2);
            characterDAO.addCharacter(dBTransaction, string, string2, rPObject2, new Timestamp(new Date().getTime()));
            transactionPool.commit(dBTransaction);
            return new CharacterResult(Result.OK_CREATED, string2, rPObject2);
        }
        catch (Exception exception) {
            logger.error(exception, exception);
            transactionPool.rollback(dBTransaction);
            return new CharacterResult(Result.FAILED_EXCEPTION, string2, rPObject);
        }
    }

    protected RPObject createCharacterObject(String string, String string2, RPObject rPObject) {
        RPObject rPObject2 = new RPObject(rPObject);
        rPObject2.put("name", string2);
        return rPObject2;
    }

    @Override
    public String getMimeTypeForResource(String string) {
        if (string.endsWith(".tmx")) {
            return "text/xml";
        }
        if (string.endsWith(".tmx")) {
            return "audio/ogg";
        }
        if (string.endsWith(".png")) {
            return "image/png";
        }
        if (string.endsWith(".js")) {
            return "text/javascript";
        }
        if (string.endsWith(".css")) {
            return "text/css";
        }
        return null;
    }

    @Override
    public InputStream getResource(String string) {
        return null;
    }

    static {
        logger = Log4J.getLogger(RPRuleProcessorImpl.class);
    }
}

