/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.Channel;
import marauroa.common.net.ConnectionManager;
import marauroa.common.net.message.Message;
import marauroa.server.net.IDisconnectedListener;
import marauroa.server.net.INetworkServerManager;
import marauroa.server.net.IServerManager;
import marauroa.server.net.nio.NIONetworkConnectionManager;
import marauroa.server.net.validator.ConnectionValidator;

public final class NetworkServerManager
implements IServerManager,
INetworkServerManager {
    private static final Logger logger = Log4J.getLogger(NetworkServerManager.class);
    private final List<ConnectionManager> connectionManagers;
    private final BlockingQueue<Message> messages;
    private final ConnectionValidator connectionValidator = new ConnectionValidator();
    private final List<IDisconnectedListener> listeners;
    private final Map<Object, Channel> channels;

    public NetworkServerManager() throws IOException {
        this.messages = new LinkedBlockingQueue<Message>();
        this.channels = Collections.synchronizedMap(new HashMap());
        this.listeners = new LinkedList<IDisconnectedListener>();
        this.connectionManagers = new LinkedList<ConnectionManager>();
        logger.debug("NetworkServerManager started successfully");
        NIONetworkConnectionManager nIONetworkConnectionManager = new NIONetworkConnectionManager(this);
        nIONetworkConnectionManager.start();
        this.connectionManagers.add(nIONetworkConnectionManager);
    }

    @Override
    public void start() {
    }

    @Override
    public void addServer(ConnectionManager connectionManager) {
        this.connectionManagers.add(connectionManager);
    }

    @Override
    public void finish() {
        boolean bl;
        logger.debug("shutting down NetworkServerManager");
        this.connectionValidator.finish();
        for (ConnectionManager object : this.connectionManagers) {
            object.finish();
        }
        do {
            bl = false;
            for (ConnectionManager connectionManager : this.connectionManagers) {
                if (connectionManager.isFinished()) continue;
                bl = true;
                break;
            }
            Thread.yield();
        } while (bl);
        logger.debug("NetworkServerManager is down");
    }

    @Override
    public Message getMessage() {
        try {
            return this.messages.take();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Override
    public void sendMessage(Message message) {
        if (logger.isDebugEnabled()) {
            logger.debug("send message(type=" + (Object)((Object)message.getType()) + ") from " + message.getClientID() + " full [" + message + "]");
        }
        Channel channel = message.getChannel();
        if (message.requiresPerception()) {
            channel.setWaitingForPerception(true);
        }
        channel.getConnectionManager().send(channel.getInternalChannel(), message, channel.isWaitingForPerception());
        if (message.isPerception()) {
            channel.setWaitingForPerception(false);
        }
    }

    @Override
    public void disconnectClient(Channel channel) {
        try {
            channel.getConnectionManager().close(channel.getInternalChannel());
        }
        catch (Exception exception) {
            logger.error("Unable to disconnect a client " + channel.getInetAddress(), exception);
        }
    }

    @Override
    public ConnectionValidator getValidator() {
        return this.connectionValidator;
    }

    @Override
    public void registerDisconnectedListener(IDisconnectedListener iDisconnectedListener) {
        this.listeners.add(iDisconnectedListener);
    }

    @Override
    public Channel getChannel(Object object) {
        return this.channels.get(object);
    }

    @Override
    public Channel onConnect(ConnectionManager connectionManager, InetSocketAddress inetSocketAddress, Object object) {
        if (this.connectionValidator.checkBanned(inetSocketAddress.getAddress())) {
            logger.debug("Reject connection from banned IP: " + inetSocketAddress);
            return null;
        }
        Channel channel = new Channel(connectionManager, inetSocketAddress, object);
        this.channels.put(object, channel);
        return channel;
    }

    @Override
    public void onDisconnect(ConnectionManager connectionManager, Object object) {
        Channel channel = this.channels.get(object);
        if (channel == null) {
            logger.warn("Cannot disconnect internalChannel " + object + " because it is unknown. (Happens on connection by a banned ip-address)");
            return;
        }
        for (IDisconnectedListener iDisconnectedListener : this.listeners) {
            iDisconnectedListener.onDisconnect(channel);
        }
        this.channels.remove(object);
    }

    @Override
    public void onMessage(ConnectionManager connectionManager, Object object, Message message) {
        Channel channel = this.channels.get(object);
        if (channel == null) {
            logger.warn("Ignoring message from unknown channel: " + message + " from" + object);
            return;
        }
        message.setChannel(channel);
        this.messages.add(message);
    }
}

