/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.web;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.Channel;
import marauroa.common.net.ConnectionManager;
import marauroa.common.net.MessageFactory;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SLoginRequestKey;
import marauroa.server.db.command.DBCommandPriority;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.PlayerEntryContainer;
import marauroa.server.game.dbcommand.LoadAllActiveCharactersCommand;
import marauroa.server.game.messagehandler.SendCharacterListHandler;
import marauroa.server.marauroad;
import marauroa.server.net.INetworkServerManager;
import marauroa.server.net.IServerManager;
import marauroa.server.net.web.WebSocketChannel;
import org.json.simple.JSONValue;

public class WebSocketConnectionManager
implements ConnectionManager {
    private static Logger logger = Log4J.getLogger(WebSocketConnectionManager.class);
    private final IServerManager serverManager;
    private final Set<WebSocketChannel> channels = Collections.synchronizedSet(new HashSet());
    private static WebSocketConnectionManager instance;

    static synchronized WebSocketConnectionManager get() {
        if (instance == null) {
            instance = new WebSocketConnectionManager((IServerManager)((Object)marauroad.getMarauroa().getNetMan()));
        }
        return instance;
    }

    WebSocketConnectionManager(IServerManager iServerManager) {
        this.serverManager = iServerManager;
    }

    void onConnect(WebSocketChannel webSocketChannel) {
        this.channels.add(webSocketChannel);
        Channel channel = this.serverManager.onConnect(this, webSocketChannel.getAddress(), webSocketChannel);
        PlayerEntry playerEntry = PlayerEntryContainer.getContainer().add(channel);
        if (webSocketChannel.getUsername() != null) {
            playerEntry.state = ClientState.LOGIN_COMPLETE;
            playerEntry.username = webSocketChannel.getUsername();
            playerEntry.disableTimeout();
            LoadAllActiveCharactersCommand loadAllActiveCharactersCommand = new LoadAllActiveCharactersCommand(playerEntry.username, new SendCharacterListHandler((INetworkServerManager)((Object)this.serverManager), 0), playerEntry.clientid, channel, 0);
            DBCommandQueue.get().enqueue(loadAllActiveCharactersCommand, DBCommandPriority.CRITICAL);
        } else {
            playerEntry.state = ClientState.CONNECTION_ACCEPTED;
            playerEntry.disableTimeout();
            MessageC2SLoginRequestKey messageC2SLoginRequestKey = new MessageC2SLoginRequestKey(channel, true);
            messageC2SLoginRequestKey.setClientID(playerEntry.clientid);
            this.serverManager.onMessage(this, webSocketChannel, messageC2SLoginRequestKey);
        }
    }

    public void onDisconnect(WebSocketChannel webSocketChannel) {
        this.channels.remove(webSocketChannel);
        this.serverManager.onDisconnect(this, webSocketChannel);
    }

    public void onMessage(WebSocketChannel webSocketChannel, String string) {
        logger.debug(" message: " + string);
        Map map = (Map)JSONValue.parse((String)string);
        try {
            Message message = MessageFactory.getFactory().getMessage(map);
            this.serverManager.onMessage(this, webSocketChannel, message);
        }
        catch (IOException iOException) {
            logger.error(map);
        }
        catch (RuntimeException runtimeException) {
            logger.error(map);
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isFinished() {
        return true;
    }

    @Override
    public void send(Object object, Message message, boolean bl) {
        if (!bl && message.isSkippable()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        message.writeToJson(stringBuilder);
        stringBuilder.append("}");
        if (stringBuilder.length() > 2) {
            ((WebSocketChannel)object).sendMessage(stringBuilder.toString());
        }
    }

    @Override
    public void close(Object object) {
        ((WebSocketChannel)object).close();
    }
}

