/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.web;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.crypto.Hash;
import marauroa.common.io.UnicodeSupportingInputStreamReader;

public class WebSocketRequestWrapper
extends HttpServletRequestWrapper {
    public static final String SECRET = Hash.toHexString(Hash.random(255));
    private static Logger logger = Log4J.getLogger(WebSocketRequestWrapper.class);
    private HttpServletRequest request;

    public WebSocketRequestWrapper(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        this.request = httpServletRequest;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("secret", new String[]{SECRET});
        hashMap.put("useragent", new String[]{this.request.getHeader("User-Agent")});
        hashMap.put("origin", new String[]{this.request.getHeader("Origin")});
        hashMap.put("address", new String[]{this.extractAddress()});
        hashMap.put("marauroa_authenticated_usernam", new String[]{this.extractUsernameFromSession()});
        return hashMap;
    }

    private String extractAddress() {
        String string;
        InetAddress inetAddress;
        String string2 = this.request.getRemoteAddr();
        try {
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
        if (inetAddress.isLoopbackAddress() && (string = this.request.getHeader("X-Forwarded-For")) != null) {
            int n = string.lastIndexOf(" ");
            if (n > -1) {
                string = string.substring(n + 1);
            }
            string2 = string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String extractUsernameFromSession() {
        Object object;
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession != null && (object = (String)httpSession.getAttribute("marauroa_authenticated_username")) != null) {
            return object;
        }
        object = this.request.getCookies();
        if (object == null) {
            return null;
        }
        for (Cookie cookie : object) {
            if (!cookie.getName().equals("PHPSESSID")) continue;
            String string = cookie.getValue();
            if (!string.matches("[A-Za-z0-9]+")) {
                logger.warn("Invalid PHPSESSID=" + string);
                continue;
            }
            BufferedReader bufferedReader = null;
            try {
                String string2 = Configuration.getConfiguration().get("php_session_file_prefix", "/var/lib/php5/sess_");
                String string3 = string2 + string;
                if (new File(string3).canRead()) {
                    String string4;
                    bufferedReader = new BufferedReader(new UnicodeSupportingInputStreamReader(new FileInputStream(string3)));
                    while ((string4 = bufferedReader.readLine()) != null) {
                        int n = string4.indexOf("marauroa_authenticated_username|s:");
                        if (n < 0) continue;
                        n = string4.indexOf("\"", n);
                        int n2 = string4.indexOf("\"", n + 2);
                        if (n <= -1 || n2 <= -1) continue;
                        logger.debug("php session username: " + string4.substring(n + 1, n2));
                        String string5 = string4.substring(n + 1, n2);
                        return string5;
                    }
                    continue;
                }
                logger.warn("Cannot read php session file: " + string3);
            }
            catch (IOException iOException) {
                logger.error(iOException, iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        logger.error(iOException, iOException);
                    }
                }
            }
        }
        return null;
    }
}

