/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.web;

import jakarta.servlet.Servlet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import marauroa.common.Configuration;
import marauroa.server.game.rp.RPServerManager;
import marauroa.server.marauroad;
import marauroa.server.net.web.WebServletForStaticContent;
import marauroa.server.net.web.WebSocketServlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.scan.StandardJarScanner;

public class WebSocketServer {
    public static void main(String[] stringArray) throws Exception {
        System.err.println("The instructions, you followed, are outdated.");
        System.err.println("Please use the normal marauroa.server.marauroad as main class");
    }

    private static String createTemporaryFolder() throws IOException {
        Path path = Files.createTempDirectory("maraurora", new FileAttribute[0]);
        path.toFile().deleteOnExit();
        return path.toAbsolutePath().toString();
    }

    public static void startWebSocketServer() throws Exception {
        Configuration configuration = Configuration.getConfiguration();
        String string = configuration.get("http_host", "127.0.0.1");
        int n = configuration.getInt("http_port", -1);
        if (n < 0) {
            return;
        }
        Tomcat tomcat = new Tomcat();
        tomcat.setBaseDir(WebSocketServer.createTemporaryFolder());
        Connector connector = new Connector();
        connector.setPort(n);
        connector.setProperty("address", string);
        tomcat.setConnector(connector);
        StandardHost standardHost = (StandardHost)tomcat.getHost();
        standardHost.setErrorReportValveClass("marauroa.server.net.web.DetaillessErrorReportValve");
        Context context = tomcat.addContext("", WebSocketServer.createTemporaryFolder());
        StandardJarScanner standardJarScanner = (StandardJarScanner)context.getJarScanner();
        standardJarScanner.setScanClassPath(true);
        standardJarScanner.setScanBootstrapClassPath(true);
        standardJarScanner.setScanAllDirectories(false);
        standardJarScanner.setScanAllFiles(false);
        ContextConfig contextConfig = new ContextConfig();
        context.addLifecycleListener((LifecycleListener)contextConfig);
        tomcat.addServlet("", "websocket", (Servlet)new WebSocketServlet());
        context.addServletMappingDecoded("/ws/*", "websocket");
        RPServerManager rPServerManager = marauroad.getMarauroa().getRPServerManager();
        tomcat.addServlet("", "static", (Servlet)new WebServletForStaticContent(rPServerManager));
        context.addServletMappingDecoded("/*", "static");
        tomcat.start();
    }
}

