/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.update;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;

class UpdateProgressBarMetaRefreshSupport
implements PropertyChangeListener,
Runnable {
    private JEditorPane browser;
    private String url;
    private int delay;

    UpdateProgressBarMetaRefreshSupport() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.browser = (JEditorPane)propertyChangeEvent.getSource();
        String string = this.browser.getText();
        if (this.parseHtml(string)) {
            Thread thread = new Thread((Runnable)this, "UpdateProgressBar");
            thread.setDaemon(true);
            thread.start();
        }
    }

    private boolean parseHtml(String string) {
        Pattern pattern = Pattern.compile("<meta http-equiv=\"refresh\" content=\"([^;]*); url=([\"]*)\">");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            pattern = Pattern.compile("<meta content=\"([^;]*); url=([^\"]*)\" http-equiv=\"refresh\">");
            matcher = pattern.matcher(string);
        }
        if (!matcher.find()) {
            return false;
        }
        this.delay = Integer.parseInt(matcher.group(1));
        this.url = matcher.group(2);
        return true;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.delay * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UpdateProgressBarMetaRefreshSupport.this.browser.setPage(UpdateProgressBarMetaRefreshSupport.this.url);
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
            }
        });
    }
}

