/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.EntityViewManager;
import games.stendhal.client.GameObjects;
import games.stendhal.client.GameScreenSpriteHelper;
import games.stendhal.client.IGameScreen;
import games.stendhal.client.StaticGameLayers;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.Zone;
import games.stendhal.client.entity.Corpse;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Item;
import games.stendhal.client.gui.DropTarget;
import games.stendhal.client.gui.EffectLayer;
import games.stendhal.client.gui.GroundContainer;
import games.stendhal.client.gui.j2d.AchievementBoxFactory;
import games.stendhal.client.gui.j2d.RemovableSprite;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.spellcasting.SpellCastingGroundContainerMouseState;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.stendhal;
import games.stendhal.common.MathHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.image.VolatileImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

public final class GameScreen
extends JComponent
implements IGameScreen,
DropTarget,
GameObjects.GameObjectListener,
StendhalClient.ZoneChangeListener {
    private static final long serialVersionUID = -4070406295913030925L;
    private static final Logger logger = Logger.getLogger(GameScreen.class);
    private static final Map<Integer, Integer> keyEventMapping = new HashMap<Integer, Integer>();
    private static final int PAN_SCALE = 8;
    private static final int PAN_INERTIA = 15;
    private static final int OFFLINE_MARGIN = 10;
    private static final Sprite offlineIcon;
    private final StaticGameLayers gameLayers;
    private static final Collection<EffectLayer> globalEffects;
    private final EntityViewManager viewManager = new EntityViewManager();
    private final GroundContainer ground;
    private final List<RemovableSprite> staticSprites;
    private boolean offline;
    private int blinkOffline;
    private int x;
    private int y;
    private int sw;
    private int sh;
    private int dvx;
    private int dvy;
    private int speed;
    private boolean useScaling = true;
    private boolean useTripleBuffer;
    private VolatileImage buffer;
    private AchievementBoxFactory achievementBoxFactory;
    private static GameScreen screen;

    public static GameScreen get(StendhalClient stendhalClient) {
        if (screen == null) {
            screen = new GameScreen(stendhalClient);
        }
        return screen;
    }

    public static GameScreen get() {
        return screen;
    }

    private GameScreen(StendhalClient stendhalClient) {
        this.setSize(stendhal.getDisplaySize());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GameScreen.this.onResized();
            }
        });
        this.gameLayers = stendhalClient.getStaticGameLayers();
        this.sw = this.getWidth();
        this.sh = this.getHeight();
        this.x = 0;
        this.y = 0;
        GameScreenSpriteHelper.setScreenViewX(-this.sw / 2);
        GameScreenSpriteHelper.setScreenViewY(-this.sh / 2);
        this.dvx = 0;
        this.dvy = 0;
        this.speed = 0;
        GameScreenSpriteHelper.setTexts(Collections.synchronizedList(new LinkedList()));
        this.staticSprites = Collections.synchronizedList(new LinkedList());
        GameScreenSpriteHelper.setEmojis(Collections.synchronizedList(new LinkedList()));
        this.ground = new GroundContainer(stendhalClient, this, this);
        this.addMouseListener(this.ground);
        this.addMouseWheelListener(this.ground);
        this.addMouseMotionListener(this.ground);
        this.setIgnoreRepaint(true);
        stendhalClient.getGameObjects().addGameObjectListener(this);
    }

    private void onResized() {
        Dimension dimension = stendhal.getDisplaySize();
        this.sw = this.getWidth();
        this.sh = this.getHeight();
        if (this.useScaling) {
            double d = (double)this.sw / dimension.getWidth();
            double d2 = (double)this.sh / dimension.getHeight();
            double d3 = Math.max(d, d2);
            GameScreenSpriteHelper.setScale(d3);
            if (Math.abs(d3 - 1.0) > 1.0E-4) {
                this.useTripleBuffer = true;
            } else {
                this.useTripleBuffer = false;
                this.buffer = null;
            }
        } else {
            this.sw = Math.min(this.sw, dimension.width);
            this.sh = Math.min(this.sh, dimension.height);
            this.useTripleBuffer = false;
            this.buffer = null;
        }
        this.calculateView(this.x, this.y);
        this.center();
    }

    public void setUseScaling(boolean bl) {
        this.useScaling = bl;
        if (!bl) {
            GameScreenSpriteHelper.setScale(1.0);
            this.useTripleBuffer = false;
            this.buffer = null;
        } else {
            this.onResized();
        }
    }

    public boolean isScaled() {
        return this.useScaling;
    }

    public static void setDefaultScreen(GameScreen gameScreen) {
        screen = gameScreen;
    }

    private int getViewWidth() {
        return (int)Math.ceil((double)this.sw / (32.0 * GameScreenSpriteHelper.getScale()));
    }

    private int getViewHeight() {
        return (int)Math.ceil((double)this.sh / (32.0 * GameScreenSpriteHelper.getScale()));
    }

    @Override
    public void nextFrame() {
        this.adjustView();
    }

    private AchievementBoxFactory getAchievementFactory() {
        if (this.achievementBoxFactory == null) {
            this.achievementBoxFactory = new AchievementBoxFactory();
        }
        return this.achievementBoxFactory;
    }

    @Override
    public void addEntity(IEntity iEntity) {
        EntityView<IEntity> entityView = this.viewManager.addEntity(iEntity);
        if (entityView != null) {
            if (entityView instanceof Entity2DView) {
                Entity2DView entity2DView = (Entity2DView)entityView;
                entity2DView.setInspector(this.ground);
            }
            if (iEntity.isUser()) {
                SwingUtilities.invokeLater(this::center);
            }
        }
    }

    public void addEffect(EffectLayer effectLayer) {
        SwingUtilities.invokeLater(() -> globalEffects.add(effectLayer));
    }

    @Override
    public void removeEntity(IEntity iEntity) {
        this.viewManager.removeEntity(iEntity);
    }

    private void adjustView() {
        if (this.dvx == 0 && this.dvy == 0) {
            return;
        }
        int n = GameScreenSpriteHelper.convertWorldXToScaledScreen(this.x) - GameScreenSpriteHelper.getScreenViewX() + 16;
        int n2 = GameScreenSpriteHelper.convertWorldYToScaledScreen(this.y) - GameScreenSpriteHelper.getScreenViewY() + 16;
        if (n < 0 || n >= this.sw || n2 < -32 || n2 > this.sh) {
            this.center();
        } else {
            this.calculatePanningSpeed();
            if (this.speed != 0) {
                int n3 = (Math.abs(this.dvx) + Math.abs(this.dvy)) * 8;
                int n4 = this.speed * this.dvx / n3;
                int n5 = this.speed * this.dvy / n3;
                n4 = this.limitMoveDelta(n4, this.dvx);
                n5 = this.limitMoveDelta(n5, this.dvy);
                GameScreenSpriteHelper.setScreenViewX(GameScreenSpriteHelper.getScreenViewX() + n4);
                this.dvx -= n4;
                GameScreenSpriteHelper.setScreenViewY(GameScreenSpriteHelper.getScreenViewY() + n5);
                this.dvy -= n5;
            }
        }
    }

    private int limitMoveDelta(int n, int n2) {
        if (n2 < 0) {
            n = MathHelper.clamp(n, n2, -1);
        } else if (n2 > 0) {
            n = MathHelper.clamp(n, 1, n2);
        }
        return n;
    }

    private void calculatePanningSpeed() {
        int n = this.dvx / 15;
        int n2 = this.dvy / 15;
        int n3 = (n * n + n2 * n2) * 8;
        if (this.speed > n3) {
            this.speed = (2 * this.speed + n3) / 3;
            if (this.dvx != 0 || this.dvy != 0) {
                this.speed = Math.max(this.speed, 1);
            }
        } else if (this.speed < n3) {
            this.speed += 2;
        }
    }

    private void calculateView(int n, int n2) {
        double d = GameScreenSpriteHelper.getScale();
        int n3 = (int)((double)(n * 32 + 16) - (double)(this.sw / 2) / d);
        int n4 = (int)((double)(n2 * 32 + 16) - (double)(this.sh / 2) / d);
        int n5 = (int)((double)(GameScreenSpriteHelper.getWorldWidth() * 32) - (double)this.sw / d);
        n3 = MathHelper.clamp(n3, 0, n5);
        int n6 = (int)((double)(GameScreenSpriteHelper.getWorldHeight() * 32) - (double)this.sh / d);
        n4 = MathHelper.clamp(n4, 0, n6);
        this.dvx = n3 - GameScreenSpriteHelper.getScreenViewX();
        this.dvy = n4 - GameScreenSpriteHelper.getScreenViewY();
    }

    @Override
    public void center() {
        GameScreenSpriteHelper.setScreenViewX(GameScreenSpriteHelper.getScreenViewX() + this.dvx);
        GameScreenSpriteHelper.setScreenViewY(GameScreenSpriteHelper.getScreenViewY() + this.dvy);
        this.dvx = 0;
        this.dvy = 0;
        this.speed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (StendhalClient.get().tryAcquireDrawingSemaphore()) {
            try {
                super.paintImmediately(n, n2, n3, n4);
            }
            finally {
                StendhalClient.get().releaseDrawingSemaphore();
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (StendhalClient.get().isInTransfer()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        if (graphics2D2.getClipBounds() == null) {
            graphics2D2.setClip(0, 0, this.getWidth(), this.getHeight());
        }
        Rectangle rectangle = graphics2D2.getClipBounds();
        boolean bl = rectangle.width == this.sw && rectangle.height == this.sh;
        int n = -GameScreenSpriteHelper.getScreenViewX();
        int n2 = -GameScreenSpriteHelper.getScreenViewY();
        if (this.useTripleBuffer) {
            double d = GameScreenSpriteHelper.getScale();
            graphics2D2.scale(d, d);
            graphics2D2.translate(n, n2);
            graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            int n3 = stendhal.getDisplaySize().width;
            int n4 = stendhal.getDisplaySize().height;
            do {
                GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
                if (this.buffer == null || this.buffer.validate(graphicsConfiguration) == 2) {
                    this.buffer = this.createVolatileImage(n3, n4);
                }
                Graphics2D graphics2D3 = this.buffer.createGraphics();
                graphics2D3.setColor(Color.BLACK);
                graphics2D3.fillRect(0, 0, n3, n4);
                graphics2D3.setClip(0, 0, n3, n4);
                this.renderScene(graphics2D3, n, n2, bl);
                graphics2D2.drawImage(this.buffer, -n, -n2, null);
                graphics2D3.dispose();
            } while (this.buffer.contentsLost());
        } else {
            this.renderScene(graphics2D2, n, n2, bl);
        }
        this.drawText(graphics2D);
        this.drawEmojis(graphics2D);
        this.paintOffLineIfNeeded(graphics2D);
        Toolkit.getDefaultToolkit().sync();
        graphics2D2.dispose();
    }

    private void renderScene(Graphics2D graphics2D, int n, int n2, boolean bl) {
        graphics2D.translate(n, n2);
        int n3 = Math.max(0, (int)this.getViewX());
        int n4 = Math.max(0, (int)this.getViewY());
        Rectangle rectangle = graphics2D.getClipBounds();
        n3 = Math.max(n3, rectangle.x / 32);
        n4 = Math.max(n4, rectangle.y / 32);
        int n5 = this.getViewWidth();
        int n6 = this.getViewHeight();
        n5 = Math.min(n5, rectangle.width / 32) + 2;
        n6 = Math.min(n6, rectangle.height / 32) + 2;
        this.viewManager.prepareViews(rectangle, bl);
        String string = this.gameLayers.getAreaName();
        this.gameLayers.drawLayers(graphics2D, string, "floor_bundle", n3, n4, n5, n6, "blend_ground", "0_floor", "1_terrain", "2_object");
        this.viewManager.draw(graphics2D);
        this.gameLayers.drawLayers(graphics2D, string, "roof_bundle", n3, n4, n5, n6, "blend_roof", "3_roof", "4_roof_add");
        this.gameLayers.drawWeather(graphics2D, n3, n4, n5, n6);
        this.viewManager.drawTop(graphics2D);
        Iterator<EffectLayer> iterator = globalEffects.iterator();
        while (iterator.hasNext()) {
            EffectLayer effectLayer = iterator.next();
            if (!effectLayer.isExpired()) {
                effectLayer.draw(graphics2D, n3, n4, n5, n6);
                continue;
            }
            iterator.remove();
        }
    }

    private void paintOffLineIfNeeded(Graphics graphics) {
        if (this.offline) {
            if (this.blinkOffline > 0) {
                offlineIcon.draw(graphics, this.getWidth() - offlineIcon.getWidth() - 10, this.getHeight() - offlineIcon.getHeight() - 10);
            }
            this.blinkOffline = this.blinkOffline < -10 ? 20 : --this.blinkOffline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawText(Graphics2D graphics2D) {
        RemovableSprite removableSprite;
        Iterator<RemovableSprite> iterator;
        List<RemovableSprite> list;
        graphics2D.translate(-GameScreenSpriteHelper.getScreenViewX(), -GameScreenSpriteHelper.getScreenViewY());
        List<RemovableSprite> list2 = list = GameScreenSpriteHelper.getTexts();
        synchronized (list2) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                removableSprite = iterator.next();
                if (!removableSprite.shouldBeRemoved()) {
                    removableSprite.draw(graphics2D);
                    continue;
                }
                iterator.remove();
            }
        }
        graphics2D.translate(GameScreenSpriteHelper.getScreenViewX(), GameScreenSpriteHelper.getScreenViewY());
        list2 = this.staticSprites;
        synchronized (list2) {
            iterator = this.staticSprites.iterator();
            while (iterator.hasNext()) {
                removableSprite = iterator.next();
                if (!removableSprite.shouldBeRemoved()) {
                    removableSprite.draw(graphics2D);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawEmojis(Graphics2D graphics2D) {
        List<RemovableSprite> list;
        List<RemovableSprite> list2 = list = GameScreenSpriteHelper.getEmojis();
        synchronized (list2) {
            Iterator<RemovableSprite> iterator = list.iterator();
            while (iterator.hasNext()) {
                RemovableSprite removableSprite = iterator.next();
                if (!removableSprite.shouldBeRemoved()) {
                    removableSprite.drawEmoji(graphics2D);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private double getViewX() {
        return (double)GameScreenSpriteHelper.getScreenViewX() / 32.0;
    }

    private double getViewY() {
        return (double)GameScreenSpriteHelper.getScreenViewY() / 32.0;
    }

    private void setMaxWorldSize(double d, double d2) {
        GameScreenSpriteHelper.setWorldWidth((int)d);
        GameScreenSpriteHelper.setWorldHeight((int)d2);
        this.calculateView(this.x, this.y);
        this.center();
    }

    @Override
    public void setOffline(boolean bl) {
        this.offline = bl;
    }

    public void addTextBox(Sprite sprite, double d, double d2, int n) {
        int n2 = GameScreenSpriteHelper.convertWorldXToScaledScreen(d);
        int n3 = GameScreenSpriteHelper.convertWorldYToScaledScreen(d2);
        n3 -= sprite.getHeight();
        n2 = GameScreenSpriteHelper.keepSpriteOnMapX(sprite, n2);
        n3 = GameScreenSpriteHelper.keepSpriteOnMapY(sprite, n3);
        n3 = GameScreenSpriteHelper.findFreeTextBoxPosition(sprite, n2, n3);
        GameScreenSpriteHelper.addText(new RemovableSprite(sprite, n2, n3, Math.max(5000L, (long)n * 5000L / 50L)));
    }

    public void addTextBox(Sprite sprite, Entity entity, int n) {
        GameScreenSpriteHelper.addText(new RemovableSprite(sprite, entity, Math.max(5000L, (long)n * 5000L / 50L)));
    }

    @Override
    public void removeText(RemovableSprite removableSprite) {
        GameScreenSpriteHelper.removeText(removableSprite);
        this.staticSprites.remove(removableSprite);
    }

    public void addEmoji(Sprite sprite, Entity entity) {
        GameScreenSpriteHelper.addEmoji(new RemovableSprite(sprite, entity, 5000L));
    }

    public void removeEmoji(RemovableSprite removableSprite) {
        GameScreenSpriteHelper.removeEmoji(removableSprite);
    }

    private void removeAllObjects() {
        logger.debug((Object)"CLEANING screen object list");
        GameScreenSpriteHelper.clearTexts();
        GameScreenSpriteHelper.clearEmojis();
    }

    @Override
    public void clearTexts() {
        GameScreenSpriteHelper.clearTexts();
        this.staticSprites.clear();
        this.clearEmojis();
    }

    public void clearEmojis() {
        GameScreenSpriteHelper.clearEmojis();
    }

    @Override
    public EntityView<?> getEntityViewAt(double d, double d2) {
        int n = GameScreenSpriteHelper.convertWorldToPixelUnits(d);
        int n2 = GameScreenSpriteHelper.convertWorldToPixelUnits(d2);
        return this.viewManager.getEntityViewAt(d, d2, n, n2);
    }

    @Override
    public EntityView<?> getMovableEntityViewAt(double d, double d2) {
        int n = GameScreenSpriteHelper.convertWorldToPixelUnits(d);
        int n2 = GameScreenSpriteHelper.convertWorldToPixelUnits(d2);
        return this.viewManager.getMovableEntityViewAt(d, d2, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemovableSprite getTextAt(int n, int n2) {
        Object object;
        List<RemovableSprite> list = this.staticSprites;
        synchronized (list) {
            ListIterator<RemovableSprite> listIterator = this.staticSprites.listIterator(this.staticSprites.size());
            while (listIterator.hasPrevious()) {
                object = listIterator.previous();
                if (!((RemovableSprite)object).getArea().contains(n, n2)) continue;
                return object;
            }
        }
        int n3 = n + GameScreenSpriteHelper.getScreenViewX();
        int n4 = n2 + GameScreenSpriteHelper.getScreenViewY();
        Object object2 = object = GameScreenSpriteHelper.getTexts();
        synchronized (object2) {
            ListIterator listIterator = object.listIterator(object.size());
            while (listIterator.hasPrevious()) {
                RemovableSprite removableSprite = (RemovableSprite)listIterator.previous();
                if (!removableSprite.getArea().contains(n3, n4)) continue;
                return removableSprite;
            }
        }
        return null;
    }

    @Override
    public Point2D convertScreenViewToWorld(Point point) {
        return this.convertScreenViewToWorld(point.x, point.y);
    }

    @Override
    public Point2D convertScreenViewToWorld(int n, int n2) {
        double d = GameScreenSpriteHelper.getScale();
        return new Point2D.Double(((double)n / d + (double)GameScreenSpriteHelper.getScreenViewX()) / 32.0, ((double)n2 / d + (double)GameScreenSpriteHelper.getScreenViewY()) / 32.0);
    }

    @Override
    public void positionChanged(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        if (n != this.x || n2 != this.y) {
            this.x = n;
            this.y = n2;
            this.calculateView(n, n2);
        }
    }

    @Override
    public void dropEntity(IEntity iEntity, int n, Point point) {
        this.ground.dropEntity(iEntity, n, point);
    }

    public void addAchievementBox(String string, String string2, String string3) {
        Sprite sprite = this.getAchievementFactory().createAchievementBox(string, string2, string3);
        this.addStaticSprite(sprite, 20000L, 0);
    }

    public void addStaticText(Sprite sprite, int n, int n2) {
        this.addStaticSprite(sprite, Math.max(5000L, (long)n * 5000L / 50L), n2);
    }

    private void addStaticSprite(Sprite sprite, long l, int n) {
        int n2 = (this.getWidth() - sprite.getWidth()) / 2;
        int n3 = this.getHeight() - sprite.getHeight();
        RemovableSprite removableSprite = new RemovableSprite(sprite, n2, n3, l);
        removableSprite.setPriority(n);
        this.staticSprites.add(removableSprite);
        Collections.sort(this.staticSprites);
    }

    @Override
    public void onZoneUpdate(Zone zone) {
        this.viewManager.resetViews();
    }

    @Override
    public void onZoneChange(Zone zone) {
        this.removeAllObjects();
        SwingUtilities.invokeLater(globalEffects::clear);
    }

    @Override
    public void onZoneChangeCompleted(Zone zone) {
        SwingUtilities.invokeLater(() -> this.setMaxWorldSize(zone.getWidth(), zone.getHeight()));
    }

    public void switchToSpellCasting(KeyEvent keyEvent) {
        RPObject rPObject = this.findSpell(keyEvent);
        if (rPObject != null) {
            this.switchToSpellCastingState(rPObject);
        }
    }

    public void switchToSpellCastingState(RPObject rPObject) {
        SpellCastingGroundContainerMouseState spellCastingGroundContainerMouseState = new SpellCastingGroundContainerMouseState(this.ground);
        this.ground.setNewMouseHandlerState(spellCastingGroundContainerMouseState);
        spellCastingGroundContainerMouseState.setSpell(rPObject);
    }

    private RPObject findSpell(KeyEvent keyEvent) {
        RPObject rPObject = StendhalClient.get().getPlayer();
        Integer n = keyEventMapping.get(keyEvent.getKeyCode());
        RPSlot rPSlot = rPObject.getSlot("spells");
        Integer n2 = 1;
        for (RPObject rPObject2 : rPSlot) {
            if (n2.equals(n)) {
                return rPObject2;
            }
            n2 = n2 + 1;
        }
        return null;
    }

    @Override
    public boolean canAccept(IEntity iEntity) {
        return iEntity instanceof Item || iEntity instanceof Corpse;
    }

    static {
        keyEventMapping.put(49, 1);
        keyEventMapping.put(50, 2);
        keyEventMapping.put(51, 3);
        keyEventMapping.put(52, 4);
        keyEventMapping.put(53, 5);
        keyEventMapping.put(54, 6);
        keyEventMapping.put(55, 7);
        keyEventMapping.put(56, 8);
        keyEventMapping.put(57, 9);
        keyEventMapping.put(48, 10);
        globalEffects = new LinkedList<EffectLayer>();
        offlineIcon = SpriteStore.get().getSprite("data/gui/offline.png");
    }
}

