/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.GameScreen;
import games.stendhal.client.gui.j2d.RemovableSprite;
import games.stendhal.client.sprite.Sprite;
import java.util.List;

public class GameScreenSpriteHelper {
    private static GameScreenSpriteHelper instance;
    private static int ww;
    private static int wh;
    private static int svx;
    private static int svy;
    private static double scale;
    private static List<RemovableSprite> texts;
    private static List<RemovableSprite> emojis;

    public static GameScreenSpriteHelper get() {
        if (instance == null) {
            instance = new GameScreenSpriteHelper();
        }
        return instance;
    }

    private GameScreenSpriteHelper() {
    }

    static void setScale(double d) {
        scale = d;
    }

    static double getScale() {
        return scale;
    }

    static void setWorldWidth(int n) {
        ww = n;
    }

    static int getWorldWidth() {
        return ww;
    }

    static void setWorldHeight(int n) {
        wh = n;
    }

    static int getWorldHeight() {
        return wh;
    }

    static void setScreenViewX(int n) {
        svx = n;
    }

    public static int getScreenViewX() {
        return svx;
    }

    static void setScreenViewY(int n) {
        svy = n;
    }

    public static int getScreenViewY() {
        return svy;
    }

    static void setTexts(List<RemovableSprite> list) {
        texts = list;
    }

    static List<RemovableSprite> getTexts() {
        return texts;
    }

    static void addText(RemovableSprite removableSprite) {
        texts.add(removableSprite);
    }

    static void removeText(RemovableSprite removableSprite) {
        texts.remove(removableSprite);
    }

    static void clearTexts() {
        texts.clear();
    }

    static void setEmojis(List<RemovableSprite> list) {
        emojis = list;
    }

    static List<RemovableSprite> getEmojis() {
        return emojis;
    }

    static void addEmoji(RemovableSprite removableSprite) {
        emojis.add(removableSprite);
    }

    static void removeEmoji(RemovableSprite removableSprite) {
        emojis.remove(removableSprite);
    }

    static void clearEmojis() {
        emojis.clear();
    }

    public static int convertWorldToPixelUnits(double d) {
        return (int)(d * 32.0);
    }

    public static int convertWorldXToScaledScreen(double d) {
        return (int)((double)GameScreenSpriteHelper.convertWorldToPixelUnits(d - (double)svx / 32.0) * scale) + svx;
    }

    public static int convertWorldYToScaledScreen(double d) {
        return (int)((double)GameScreenSpriteHelper.convertWorldToPixelUnits(d - (double)svy / 32.0) * scale) + svy;
    }

    public static int keepSpriteOnMapX(Sprite sprite, int n) {
        n = Math.max(n, 0);
        if (ww != 0) {
            n = Math.min(n, Math.max(GameScreen.get().getWidth() + svx, GameScreenSpriteHelper.convertWorldXToScaledScreen(ww)) - sprite.getWidth());
        }
        return n;
    }

    public static int keepSpriteOnMapY(Sprite sprite, int n) {
        n = Math.max(n, 0);
        if (wh != 0) {
            n = Math.min(n, Math.max(GameScreen.get().getHeight() + svy, GameScreenSpriteHelper.convertWorldYToScaledScreen(wh)) - sprite.getHeight());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findFreeTextBoxPosition(Sprite sprite, int n, int n2) {
        boolean bl = true;
        int n3 = 0;
        while (bl) {
            bl = false;
            List<RemovableSprite> list = texts;
            synchronized (list) {
                for (RemovableSprite removableSprite : texts) {
                    if (removableSprite.getX() != n || removableSprite.getY() != n2) continue;
                    bl = true;
                    n2 += 16;
                    n2 = GameScreenSpriteHelper.keepSpriteOnMapY(sprite, n2);
                    break;
                }
            }
            if (++n3 <= 20) continue;
            break;
        }
        return n2;
    }

    static {
        scale = 1.0;
    }
}

