/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import marauroa.common.Log4J;
import marauroa.common.Logger;

class LogUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static Logger logger = Log4J.getLogger(LogUncaughtExceptionHandler.class);
    private Thread.UncaughtExceptionHandler next;

    LogUncaughtExceptionHandler() {
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        logger.error((Object)("Exception in thread " + thread.getName()), throwable);
        System.err.println("Exception in thread " + thread.getName());
        throwable.printStackTrace();
        if (this.next != null) {
            this.next.uncaughtException(thread, throwable);
        }
    }

    static void setup() {
        LogUncaughtExceptionHandler logUncaughtExceptionHandler = new LogUncaughtExceptionHandler();
        logUncaughtExceptionHandler.next = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(logUncaughtExceptionHandler);
    }
}

