/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.client.sound.manager.SoundManagerNG;
import games.stendhal.common.constants.SoundLayer;
import java.awt.Color;
import java.awt.Composite;

public class ZoneInfo {
    private static final ZoneInfo instance = new ZoneInfo();
    private Composite colorBlend;
    private Composite effectBlend;
    private Color color;
    private static SoundManagerNG.Sound globalMusic = null;
    private static final Time fadeTime = new Time(1L, Time.Unit.SEC);

    private ZoneInfo() {
    }

    public static ZoneInfo get() {
        return instance;
    }

    void zoneChanged() {
        this.colorBlend = null;
        this.effectBlend = null;
        this.color = null;
    }

    void setColorMethod(Composite composite) {
        this.colorBlend = composite;
    }

    public Composite getColorMethod() {
        return this.colorBlend;
    }

    void setEffectBlend(Composite composite) {
        this.effectBlend = composite;
    }

    Composite getEffectBlend() {
        return this.effectBlend;
    }

    void setZoneColor(int n) {
        this.color = new Color(n);
    }

    public Color getZoneColor() {
        return this.color;
    }

    public void setSingleGlobalizedMusic(String string, float f) {
        if (globalMusic != null && globalMusic.getName().equals(string)) {
            return;
        }
        if (globalMusic != null) {
            ClientSingletonRepository.getSound().stop(globalMusic, fadeTime);
        }
        globalMusic = null;
        if (string != null) {
            globalMusic = (SoundManagerNG.Sound)ClientSingletonRepository.getSound().getGroup(SoundLayer.BACKGROUND_MUSIC.groupName).play(string, f, 0, null, fadeTime, true, false);
        }
    }
}

