/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.entity.ContentChangeListener;
import games.stendhal.client.entity.EntityChangeListener;
import games.stendhal.client.entity.IEntity;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;

public class Gate
implements IEntity {
    private double x;
    private double y;
    private double width;
    private double height;
    private RPObject rpObject;
    private double radius = 6.0;

    @Override
    public void addChangeListener(EntityChangeListener<?> entityChangeListener) {
    }

    @Override
    public Rectangle2D getArea() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public Rectangle2D getAudibleArea() {
        return new Rectangle2D.Double(this.getX() - this.radius / 2.0, this.getY() - this.radius / 2.0, this.radius, this.radius);
    }

    @Override
    public String getEntityClass() {
        if (this.rpObject == null) {
            return "";
        }
        return this.rpObject.get("class");
    }

    @Override
    public String getEntitySubclass() {
        if (this.rpObject == null) {
            return "";
        }
        return this.rpObject.get("subclass");
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public RPObject.ID getID() {
        if (this.rpObject == null) {
            return null;
        }
        return this.rpObject.getID();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public RPObject getRPObject() {
        return this.rpObject;
    }

    @Override
    public int getResistance() {
        if (this.rpObject == null) {
            return 0;
        }
        return this.rpObject.getInt("resistance");
    }

    @Override
    public int getResistance(IEntity iEntity) {
        return this.getResistance();
    }

    @Override
    public RPSlot getSlot(String string) {
        return null;
    }

    @Override
    public String getTitle() {
        if (this.rpObject == null) {
            return null;
        }
        return this.rpObject.get("title");
    }

    @Override
    public String getType() {
        if (this.rpObject == null) {
            return null;
        }
        return this.rpObject.getRPClass().getName();
    }

    @Override
    public int getVisibility() {
        return 100;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void initialize(RPObject rPObject) {
        this.x = rPObject.getInt("x");
        this.y = rPObject.getInt("y");
        this.width = rPObject.getInt("width");
        this.height = rPObject.getInt("height");
        this.rpObject = rPObject;
    }

    @Override
    public boolean isObstacle(IEntity iEntity) {
        return this.getResistance() > 0;
    }

    @Override
    public boolean isOnGround() {
        return true;
    }

    @Override
    public boolean isUser() {
        return false;
    }

    @Override
    public void release() {
    }

    @Override
    public void removeChangeListener(EntityChangeListener<?> entityChangeListener) {
    }

    public void setAudibleRange(double d) {
        this.radius = d;
    }

    @Override
    public void update(int n) {
    }

    @Override
    public String getCursor() {
        return "ACTIVITY";
    }

    @Override
    public List<String> getPath() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (RPObject rPObject = this.getRPObject(); rPObject != null; rPObject = rPObject.getContainer()) {
            linkedList.add(0, Integer.toString(rPObject.getID().getObjectID()));
            RPSlot rPSlot = rPObject.getContainerSlot();
            if (rPSlot == null) continue;
            linkedList.add(0, rPSlot.getName());
        }
        return linkedList;
    }

    @Override
    public void addContentChangeListener(ContentChangeListener contentChangeListener) {
    }

    @Override
    public void removeContentChangeListener(ContentChangeListener contentChangeListener) {
    }
}

