/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.common.MathHelper;

class SpeedPredictor {
    private static final double TURN_LENGTH = 300.0;
    private static final double INITIAL_PREDICTED_SPEED = 0.3;
    private static final double DISCARD_THRESHOLD = 2000.0;
    private static final double DISABLING_THRESHDOLD = 0.3;
    private static final int VECTOR_LENGTH = 4;
    private static final String SPEED_PROPERTY = "predictor.speed";
    private static final String JITTER_PROPERTY = "predictor.jitter";
    final double[] times;
    double prediction;
    private long timeStamp;
    private double jitter;

    SpeedPredictor() {
        this.times = new double[4];
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        this.prediction = MathHelper.parseDoubleDefault(wtWindowManager.getProperty(SPEED_PROPERTY, Double.toString(0.3)), 0.3);
        this.jitter = MathHelper.parseDouble(wtWindowManager.getProperty(JITTER_PROPERTY, "0.0"));
        double d = 300.0 / this.prediction;
        for (int i = 0; i < 4; ++i) {
            this.times[i] = d;
        }
    }

    SpeedPredictor(SpeedPredictor speedPredictor) {
        this.times = speedPredictor.times;
        this.prediction = speedPredictor.prediction;
        this.jitter = speedPredictor.jitter;
    }

    boolean isActive() {
        return this.timeStamp != 0L;
    }

    void startPrediction() {
        this.timeStamp = System.currentTimeMillis();
    }

    void onMoved() {
        double d = System.currentTimeMillis() - this.timeStamp;
        this.timeStamp = 0L;
        if (d > 2000.0) {
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < 4; ++i) {
            double d4 = this.times[i];
            double d5 = (d + d4) / 2.0;
            d2 += Math.abs(d4 - d);
            this.times[i] = d5;
            d = d4;
            d3 += d5;
        }
        this.jitter = (this.jitter + 2.0 * Math.max(this.jitter, d2 /= 8.0) + d2) / 4.0;
        this.prediction = 300.0 / (d3 / 4.0 + this.jitter);
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        wtWindowManager.setProperty(SPEED_PROPERTY, Double.toString(this.prediction));
        wtWindowManager.setProperty(JITTER_PROPERTY, Double.toString(this.jitter));
    }

    double getSpeed() {
        if (this.prediction > 0.3) {
            return this.prediction;
        }
        return 0.0;
    }
}

