/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.events;

import games.stendhal.client.GameScreen;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.events.Event;
import games.stendhal.client.gui.ScrolledViewport;
import games.stendhal.client.gui.imageviewer.ImageViewWindow;
import games.stendhal.client.gui.imageviewer.ItemListImageViewerEvent;
import games.stendhal.client.gui.imageviewer.ViewPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class BestiaryEvent
extends Event<RPEntity> {
    private static Logger logger = Logger.getLogger(BestiaryEvent.class);
    private boolean hasRare = false;
    private boolean hasAbnormal = false;

    @Override
    public void execute() {
        if (this.event.has("enemies")) {
            ViewPanel viewPanel = new ViewPanel(){
                private static final int PAD = 5;

                @Override
                public void prepareView(Dimension dimension) {
                    Object object;
                    Dimension dimension2 = GameScreen.get().getSize();
                    int n = dimension2.width - 80;
                    StringBuilder stringBuilder = new StringBuilder("\"???\" = unknown");
                    JLabel jLabel = new JLabel();
                    jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    this.add((Component)jLabel, "North");
                    JTable jTable = this.createTable();
                    jTable.setEnabled(false);
                    jTable.setFillsViewportHeight(true);
                    jTable.setAutoResizeMode(3);
                    TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
                    tableColumn.setCellRenderer(new DefaultTableCellRenderer());
                    DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                    defaultTableCellRenderer.setHorizontalAlignment(0);
                    tableColumn = jTable.getColumnModel().getColumn(1);
                    tableColumn.setCellRenderer(defaultTableCellRenderer);
                    tableColumn = jTable.getColumnModel().getColumn(2);
                    tableColumn.setCellRenderer(defaultTableCellRenderer);
                    ItemListImageViewerEvent.HeaderRenderer headerRenderer = new ItemListImageViewerEvent.HeaderRenderer();
                    Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        ((TableColumn)object).setHeaderRenderer(headerRenderer);
                    }
                    this.adjustColumnWidths(jTable);
                    this.adjustRowHeights(jTable);
                    object = new ScrolledViewport(jTable);
                    ((ScrolledViewport)object).getComponent().setPreferredSize(new Dimension(n, Math.min(dimension2.height - 100, jTable.getPreferredSize().height + headerRenderer.getPreferredSize().height + 20)));
                    ((ScrolledViewport)object).getComponent().setBackground(jTable.getBackground());
                    this.add((Component)((ScrolledViewport)object).getComponent(), "Center");
                    if (BestiaryEvent.this.hasRare || BestiaryEvent.this.hasAbnormal) {
                        stringBuilder.append("<br>");
                        if (!BestiaryEvent.this.hasRare) {
                            stringBuilder.append("\"abnormal\"");
                        } else {
                            stringBuilder.append("\"rare\"");
                            if (BestiaryEvent.this.hasAbnormal) {
                                stringBuilder.append(" and \"abnormal\"");
                            }
                        }
                        stringBuilder.append(" creatures not required for achievements");
                    }
                    jLabel.setText("<html><div width=" + (n - 10) + ">" + stringBuilder.toString() + "</div></html>");
                    this.setVisible(true);
                }

                private JTable createTable() {
                    Object[] objectArray = new String[]{"Name", "Solo", "Shared"};
                    List<String> list = Arrays.asList(BestiaryEvent.this.event.get("enemies").split(";"));
                    Object[][] objectArray2 = new Object[list.size()][];
                    int n = 0;
                    for (String string : list) {
                        objectArray2[n] = this.createDataRow(string.split(","));
                        ++n;
                    }
                    return new JTable(objectArray2, objectArray);
                }

                private Object[] createDataRow(String[] stringArray) {
                    Object[] objectArray = new Object[4];
                    String string = stringArray[0];
                    if (BestiaryEvent.this.isRare(string)) {
                        BestiaryEvent.this.hasRare = true;
                    } else if (BestiaryEvent.this.isAbnormal(string)) {
                        BestiaryEvent.this.hasAbnormal = true;
                    }
                    objectArray[0] = string;
                    objectArray[1] = "";
                    objectArray[2] = "";
                    if (stringArray[1].equals("true")) {
                        objectArray[1] = "\u2714";
                    }
                    if (stringArray[2].equals("true")) {
                        objectArray[2] = "\u2714";
                    }
                    return objectArray;
                }

                private void adjustColumnWidths(JTable jTable) {
                    TableColumnModel tableColumnModel = jTable.getColumnModel();
                    for (int i = 0; i < jTable.getColumnCount(); ++i) {
                        TableColumn tableColumn = tableColumnModel.getColumn(i);
                        int n = tableColumn.getWidth();
                        for (int j = 0; j < jTable.getRowCount(); ++j) {
                            Component component = jTable.prepareRenderer(jTable.getCellRenderer(j, i), j, i);
                            n = Math.max(n, component.getPreferredSize().width);
                        }
                        tableColumn.setPreferredWidth(n);
                    }
                }

                private void adjustRowHeights(JTable jTable) {
                    for (int i = 0; i < jTable.getRowCount(); ++i) {
                        int n = jTable.getRowHeight();
                        for (int j = 0; j < jTable.getColumnCount(); ++j) {
                            Component component = jTable.prepareRenderer(jTable.getCellRenderer(i, j), i, j);
                            n = Math.max(n, component.getPreferredSize().height);
                        }
                        jTable.setRowHeight(i, n);
                    }
                }
            };
            new ImageViewWindow("Bestiary", viewPanel);
        } else {
            logger.warn((Object)"Could not create bestiary: Event does not have \"enemies\" attribute");
        }
    }

    private boolean isRare(String string) {
        return string.endsWith("(rare)");
    }

    private boolean isAbnormal(String string) {
        return string.endsWith("(abnormal)");
    }
}

