/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.events;

import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.events.AttackEvent;
import games.stendhal.client.events.BestiaryEvent;
import games.stendhal.client.events.ChatOptionsEvent;
import games.stendhal.client.events.EntityMessageEvent;
import games.stendhal.client.events.Event;
import games.stendhal.client.events.ExamineEvent;
import games.stendhal.client.events.GlobalVisualEffectEvent;
import games.stendhal.client.events.GroupChangeEvent;
import games.stendhal.client.events.GroupInviteEvent;
import games.stendhal.client.events.ImageEffectEvent;
import games.stendhal.client.events.PlayerLoggedOnEvent;
import games.stendhal.client.events.PlayerLoggedOutEvent;
import games.stendhal.client.events.PrivateTextEvent;
import games.stendhal.client.events.ProgressStatusEvent;
import games.stendhal.client.events.PublicTextEvent;
import games.stendhal.client.events.ReachedAchievementEvent;
import games.stendhal.client.events.ShowItemListEvent;
import games.stendhal.client.events.ShowOutfitListEvent;
import games.stendhal.client.events.SoundEvent;
import games.stendhal.client.events.TradeStateChangeEvent;
import games.stendhal.client.events.TransitionGraphEvent;
import games.stendhal.client.events.UnknownEvent;
import games.stendhal.client.events.ViewChangeEvent;
import marauroa.common.game.RPEvent;
import org.apache.log4j.Logger;

class EventFactory {
    private static final Logger logger = Logger.getLogger(EventFactory.class);

    EventFactory() {
    }

    static Event<? extends Entity> create(Entity entity, RPEvent rPEvent) {
        Event<Entity> event = null;
        if (entity instanceof RPEntity) {
            event = EventFactory.createEventsForRPEntity((RPEntity)entity, rPEvent);
        }
        if (event == null) {
            event = EventFactory.createEventsForEntity(entity, rPEvent);
        }
        if (event == null) {
            UnknownEvent<RPEntity> unknownEvent = new UnknownEvent<RPEntity>();
            unknownEvent.init((RPEntity)entity, rPEvent);
            event = unknownEvent;
        }
        logger.debug((Object)("Created event: " + event));
        return event;
    }

    private static Event<RPEntity> createEventsForRPEntity(RPEntity rPEntity, RPEvent rPEvent) {
        String string = rPEvent.getName();
        Event event = null;
        if (string.equals("text")) {
            event = new PublicTextEvent();
        } else if (string.equals("private_text")) {
            event = new PrivateTextEvent();
        } else if (string.equals("attack")) {
            event = new AttackEvent();
        } else if (string.equals("chat_options")) {
            event = new ChatOptionsEvent();
        } else if (string.equals("trade_state_change_event")) {
            event = new TradeStateChangeEvent();
        } else if (string.equals("group_change_event")) {
            event = new GroupChangeEvent();
        } else if (string.equals("group_invite_event")) {
            event = new GroupInviteEvent();
        } else if (string.equals("progress_status_event")) {
            event = new ProgressStatusEvent();
        } else if (string.equals("reached_achievement")) {
            event = new ReachedAchievementEvent();
        } else if (string.equals("bestiary")) {
            event = new BestiaryEvent();
        }
        if (event != null) {
            event.init(rPEntity, rPEvent);
        }
        return event;
    }

    private static Event<Entity> createEventsForEntity(Entity entity, RPEvent rPEvent) {
        String string = rPEvent.getName();
        Event event = null;
        if (string.equals("examine")) {
            event = new ExamineEvent();
        } else if (string.equals("show_item_list")) {
            event = new ShowItemListEvent();
        } else if (string.equals("show_outfit_list")) {
            event = new ShowOutfitListEvent();
        } else if (string.equals("sound_event")) {
            event = new SoundEvent();
        } else if (string.equals("transition_graph")) {
            event = new TransitionGraphEvent();
        } else if (string.equals("player_logged_on")) {
            event = new PlayerLoggedOnEvent();
        } else if (string.equals("player_logged_out")) {
            event = new PlayerLoggedOutEvent();
        } else if (string.equals("view_change")) {
            event = new ViewChangeEvent();
        } else if (string.equals("image_event")) {
            event = new ImageEffectEvent();
        } else if (string.equals("text")) {
            event = new EntityMessageEvent();
        } else if (string.equals("global_visual_effect")) {
            event = new GlobalVisualEffectEvent();
        }
        if (event != null) {
            event.init(entity, rPEvent);
        }
        return event;
    }
}

