/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.events;

import games.stendhal.client.GameScreen;
import games.stendhal.client.OutfitStore;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.events.Event;
import games.stendhal.client.gui.ScrolledViewport;
import games.stendhal.client.gui.imageviewer.ImageViewWindow;
import games.stendhal.client.gui.imageviewer.ItemListImageViewerEvent;
import games.stendhal.client.gui.imageviewer.ViewPanel;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class ShowOutfitListEvent
extends Event<Entity> {
    private static final Logger logger = Logger.getLogger(ShowOutfitListEvent.class);
    private static final int PAD = 5;

    @Override
    public void execute() {
        if (!this.event.has("outfits")) {
            logger.warn((Object)"Could not create bestiary: Event does not have \"enemies\" attribute");
            return;
        }
        new ImageViewWindow(this.event.get("title"), this.createViewPanel());
    }

    private ViewPanel createViewPanel() {
        return new ViewPanel(){

            @Override
            public void prepareView(Dimension dimension) {
                Object object;
                JComponent jComponent;
                Dimension dimension2 = GameScreen.get().getSize();
                int n = dimension2.width - 80;
                if (ShowOutfitListEvent.this.event.has("caption")) {
                    jComponent = new JLabel("<html><div width=" + (n - 10) + ">" + ShowOutfitListEvent.this.event.get("caption") + "</div></html>");
                    jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    this.add((Component)jComponent, "North");
                }
                jComponent = this.createTable();
                jComponent.setEnabled(false);
                ((JTable)jComponent).setFillsViewportHeight(true);
                ((JTable)jComponent).setAutoResizeMode(3);
                TableColumn tableColumn = ((JTable)jComponent).getColumnModel().getColumn(0);
                tableColumn.setCellRenderer(new DefaultTableCellRenderer());
                DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                defaultTableCellRenderer.setHorizontalAlignment(0);
                tableColumn = ((JTable)jComponent).getColumnModel().getColumn(1);
                tableColumn.setCellRenderer(new SpriteCellRenderer());
                tableColumn = ((JTable)jComponent).getColumnModel().getColumn(2);
                tableColumn.setCellRenderer(defaultTableCellRenderer);
                ItemListImageViewerEvent.HeaderRenderer headerRenderer = new ItemListImageViewerEvent.HeaderRenderer();
                Enumeration<TableColumn> enumeration = ((JTable)jComponent).getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    ((TableColumn)object).setHeaderRenderer(headerRenderer);
                }
                this.adjustColumnWidths((JTable)jComponent);
                this.adjustRowHeights((JTable)jComponent);
                object = new ScrolledViewport(jComponent);
                ((ScrolledViewport)object).getComponent().setPreferredSize(new Dimension(n, Math.min(dimension2.height - 100, jComponent.getPreferredSize().height + headerRenderer.getPreferredSize().height + 20)));
                ((ScrolledViewport)object).getComponent().setBackground(jComponent.getBackground());
                this.add((Component)((ScrolledViewport)object).getComponent(), "Center");
                this.setVisible(true);
            }

            private JTable createTable() {
                Object[] objectArray = new String[]{"Name", "Preview", "Price"};
                List<String> list = Arrays.asList(ShowOutfitListEvent.this.event.get("outfits").split(":"));
                Object[][] objectArray2 = new Object[list.size()][];
                int n = 0;
                for (String string : list) {
                    objectArray2[n] = this.createDataRow(string.split(";"));
                    ++n;
                }
                return new JTable(objectArray2, objectArray);
            }

            /*
             * WARNING - void declaration
             */
            private Object[] createDataRow(String[] stringArray) {
                void var5_8;
                Object[] objectArray = new Object[3];
                boolean bl = stringArray.length > 3 && stringArray[3].equals("showall");
                ArrayList<String> arrayList = new ArrayList<String>();
                if (!bl && stringArray.length > 3) {
                    for (String n : stringArray[3].split(",")) {
                        arrayList.add(n);
                    }
                }
                String string = stringArray[1];
                if (!ShowOutfitListEvent.this.event.has("show_base") && !bl) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (String string2 : string.split(",")) {
                        Object object = string2.split("=");
                        hashMap.put(object[0], object[1]);
                    }
                    for (String string3 : Arrays.asList("body", "head", "eyes")) {
                        if (arrayList.contains("show" + string3)) continue;
                        hashMap.put(string3, "-1");
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = hashMap.size();
                    int n2 = 0;
                    for (Object object : hashMap.keySet()) {
                        stringBuilder.append((String)object + "=" + (String)hashMap.get(object));
                        if (n2 < n - 1) {
                            stringBuilder.append(",");
                        }
                        ++n2;
                    }
                    String string4 = stringBuilder.toString();
                }
                int n = 1;
                int n3 = 2;
                if (stringArray.length > 5) {
                    try {
                        n = Integer.parseInt(stringArray[4]);
                        n3 = Integer.parseInt(stringArray[5]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.warn((Object)"Failed to set frame index, using default");
                    }
                }
                objectArray[0] = stringArray[0];
                objectArray[1] = ((ImageSprite)OutfitStore.get().getAdjustedOutfit((String)var5_8, null, null, null)).getFrame(n, n3);
                objectArray[2] = stringArray[2];
                return objectArray;
            }

            private void adjustColumnWidths(JTable jTable) {
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                for (int i = 0; i < jTable.getColumnCount(); ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    int n = tableColumn.getWidth();
                    for (int j = 0; j < jTable.getRowCount(); ++j) {
                        Component component = jTable.prepareRenderer(jTable.getCellRenderer(j, i), j, i);
                        n = Math.max(n, component.getPreferredSize().width);
                    }
                    tableColumn.setPreferredWidth(n);
                }
            }

            private void adjustRowHeights(JTable jTable) {
                for (int i = 0; i < jTable.getRowCount(); ++i) {
                    int n = jTable.getRowHeight();
                    for (int j = 0; j < jTable.getColumnCount(); ++j) {
                        Component component = jTable.prepareRenderer(jTable.getCellRenderer(i, j), i, j);
                        n = Math.max(n, component.getPreferredSize().height);
                    }
                    jTable.setRowHeight(i, n);
                }
            }
        };
    }

    private static class SpriteCellRenderer
    extends JComponent
    implements TableCellRenderer {
        private Sprite sprite;

        private SpriteCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = jTable.getValueAt(n, n2);
            this.sprite = object2 instanceof Sprite ? (Sprite)object2 : null;
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            if (this.sprite != null) {
                dimension.width = this.sprite.getWidth() + 10;
                dimension.height = this.sprite.getHeight() + 10;
            }
            return dimension;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.sprite != null) {
                this.sprite.draw(graphics, (this.getWidth() - this.sprite.getWidth()) / 2, (this.getHeight() - this.sprite.getHeight()) / 2);
            }
        }
    }
}

