/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.gui.KTextEdit;
import games.stendhal.client.gui.NotificationChannel;
import games.stendhal.client.gui.NotificationChannelManager;
import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.wt.core.SettingChangeAdapter;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sound.facade.InfiniteAudibleArea;
import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.common.NotificationType;
import games.stendhal.common.constants.SoundLayer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ChatLogArea {
    private static final String PRIVATE_TAB_COLOR = "0xdcdcff";
    private final NotificationChannelManager channelManager;
    private final JTabbedPane tabs = new JTabbedPane(3);
    private final Timer animator = new Timer(100, null);

    ChatLogArea(NotificationChannelManager notificationChannelManager) {
        this.channelManager = notificationChannelManager;
        this.createLogArea();
    }

    private JTabbedPane createLogArea() {
        this.tabs.setFocusable(false);
        List<JComponent> list = this.createChannelComponents();
        BitSet bitSet = new BitSet(list.size());
        this.setupTabChangeHandling(bitSet);
        Iterator<NotificationChannel> iterator = this.channelManager.getChannels().iterator();
        for (JComponent jComponent : list) {
            this.tabs.add(iterator.next().getName(), jComponent);
        }
        this.setupHiddenChannelMessageHandling(bitSet);
        this.setupAnimation(bitSet);
        return this.tabs;
    }

    private List<JComponent> createChannelComponents() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        KTextEdit kTextEdit = new KTextEdit();
        arrayList.add(kTextEdit);
        NotificationChannel notificationChannel = this.setupMainChannel(kTextEdit);
        this.channelManager.addChannel(notificationChannel);
        kTextEdit = new KTextEdit();
        arrayList.add(kTextEdit);
        NotificationChannel notificationChannel2 = this.setupPersonalChannel(kTextEdit);
        this.channelManager.addChannel(notificationChannel2);
        return arrayList;
    }

    private NotificationChannel setupPersonalChannel(KTextEdit kTextEdit) {
        kTextEdit.setChannelName("Personal");
        kTextEdit.setDefaultBackground(Color.decode(PRIVATE_TAB_COLOR));
        String string = NotificationType.PRIVMSG.toString() + "," + (Object)((Object)NotificationType.CLIENT) + "," + (Object)((Object)NotificationType.GROUP) + "," + (Object)((Object)NotificationType.TUTORIAL) + "," + (Object)((Object)NotificationType.SUPPORT);
        return new NotificationChannel("Personal", kTextEdit, false, string);
    }

    private NotificationChannel setupMainChannel(KTextEdit kTextEdit) {
        final NotificationChannel notificationChannel = new NotificationChannel("Main", kTextEdit, true, "");
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        wtWindowManager.registerSettingChangeListener("ui.healingmessage", new SettingChangeAdapter("ui.healingmessage", "false"){

            @Override
            public void changed(String string) {
                notificationChannel.setTypeFiltering(NotificationType.HEAL, Boolean.parseBoolean(string));
            }
        });
        wtWindowManager.registerSettingChangeListener("ui.poisonmessage", new SettingChangeAdapter("ui.poisonmessage", "false"){

            @Override
            public void changed(String string) {
                notificationChannel.setTypeFiltering(NotificationType.POISON, Boolean.parseBoolean(string));
            }
        });
        return notificationChannel;
    }

    private void setupTabChangeHandling(final BitSet bitSet) {
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = ChatLogArea.this.tabs.getSelectedIndex();
                NotificationChannel notificationChannel = ChatLogArea.this.channelManager.getChannels().get(n);
                ChatLogArea.this.channelManager.setVisibleChannel(notificationChannel);
                if (bitSet.get(n)) {
                    bitSet.clear(n);
                    ChatLogArea.this.tabs.setBackgroundAt(n, null);
                    if (bitSet.isEmpty()) {
                        ChatLogArea.this.animator.stop();
                    }
                }
            }
        });
    }

    private void setupHiddenChannelMessageHandling(final BitSet bitSet) {
        final WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        this.channelManager.addHiddenChannelListener(new NotificationChannelManager.HiddenChannelListener(){

            @Override
            public void channelModified(int n) {
                if (n == 1 && wtWindowManager.getPropertyBoolean("ui.msg_sound", true) && this.getClass().getResource("/data/sounds/ui/notify_up.ogg") != null) {
                    SoundGroup soundGroup = ClientSingletonRepository.getSound().getGroup(SoundLayer.USER_INTERFACE.groupName);
                    soundGroup.loadSound("ui.msg_sound", "ui/notify_up.ogg", SoundFileType.OGG, false);
                    soundGroup.play("ui.msg_sound", 0, new InfiniteAudibleArea(), null, false, true);
                }
                if (!bitSet.get(n)) {
                    bitSet.set(n);
                    if (!ChatLogArea.this.animator.isRunning() && wtWindowManager.getPropertyBoolean("ui.msg_blink", true)) {
                        ChatLogArea.this.animator.start();
                    }
                }
            }
        });
    }

    private void setupAnimation(BitSet bitSet) {
        this.animator.addActionListener(new AnimationActionListener(bitSet));
    }

    JComponent getComponent() {
        return this.tabs;
    }

    private class AnimationActionListener
    implements ActionListener {
        private final BitSet changedChannels;
        private static final int STEPS = 10;
        private final Color[] colors;
        private int colorIndex;
        private int change = 1;

        private AnimationActionListener(BitSet bitSet) {
            this.changedChannels = bitSet;
            this.colors = new Color[10];
            this.initColors();
        }

        private void initColors() {
            Color color;
            Style style = StyleUtil.getStyle();
            if (style != null) {
                this.colors[0] = style.getHighLightColor();
                color = style.getPlainColor();
            } else {
                this.colors[0] = Color.BLUE;
                color = Color.DARK_GRAY;
            }
            int n = this.colors[0].getRed();
            int n2 = this.colors[0].getGreen();
            int n3 = this.colors[0].getBlue();
            int n4 = 255;
            int n5 = n - color.getRed();
            int n6 = n2 - color.getGreen();
            int n7 = n3 - color.getBlue();
            int n8 = TransparencyMode.TRANSPARENCY == 3 ? 25 : 0;
            for (int i = 1; i < 10; ++i) {
                this.colors[i] = new Color(n - i * n5 / 10, n2 - i * n6 / 10, n3 - i * n7 / 10, n4 -= n8);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.colorIndex += this.change;
            if (this.colorIndex >= this.colors.length || this.colorIndex < 0) {
                this.change = -this.change;
                this.colorIndex += this.change;
            }
            int n = this.changedChannels.nextSetBit(0);
            while (n >= 0) {
                ChatLogArea.this.tabs.setBackgroundAt(n, this.colors[this.colorIndex]);
                n = this.changedChannels.nextSetBit(n + 1);
            }
        }
    }
}

