/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.AbstractColorSelector;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.common.MathHelper;
import games.stendhal.common.color.ARGB;
import games.stendhal.common.color.HSL;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

class ColorSelector
extends AbstractColorSelector<AbstractColorSelector.HSLSelectionModel> {
    private final JComponent hueSaturationSelector;
    private final JComponent lightnessSelector;

    ColorSelector() {
        super(new AbstractColorSelector.HSLSelectionModel());
        AbstractColorSelector.HSLSelectionModel hSLSelectionModel = (AbstractColorSelector.HSLSelectionModel)this.getSelectionModel();
        this.hueSaturationSelector = new HueSaturationSelector(hSLSelectionModel);
        this.add(this.hueSaturationSelector);
        this.lightnessSelector = new AbstractColorSelector.LightnessSelector(hSLSelectionModel);
        this.add((Component)this.lightnessSelector, (Object)SLayout.EXPAND_X);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.hueSaturationSelector.setEnabled(bl);
        this.lightnessSelector.setEnabled(bl);
    }

    private static class HueSaturationSelector
    extends AbstractColorSelector.AbstractSpriteColorSelector<AbstractColorSelector.HSLSelectionModel> {
        HueSaturationSelector(AbstractColorSelector.HSLSelectionModel hSLSelectionModel) {
            super(hSLSelectionModel);
        }

        @Override
        Sprite createNormalSprite() {
            BufferedImage bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(80, 52);
            float[] fArray = new float[3];
            fArray[2] = 0.5f;
            int[] nArray = new int[4];
            nArray[0] = 255;
            for (int i = 0; i < 80; ++i) {
                for (int j = 0; j < 52; ++j) {
                    fArray[0] = (float)i / 80.0f;
                    fArray[1] = 1.0f - (float)j / 52.0f;
                    HSL.hsl2rgb(fArray, nArray);
                    int n = ARGB.mergeRgb(nArray);
                    bufferedImage.setRGB(i, j, n);
                }
            }
            return new ImageSprite(bufferedImage, (Object)"hsl_color_selection_id");
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Insets insets = this.getInsets();
            Sprite sprite = this.getBackgroundSprite();
            graphics.setColor(Color.BLACK);
            int n = (int)(((AbstractColorSelector.HSLSelectionModel)this.model).getHue() * (float)sprite.getWidth()) + insets.left;
            int n2 = (int)((1.0f - ((AbstractColorSelector.HSLSelectionModel)this.model).getSaturation()) * (float)sprite.getHeight()) + insets.left;
            graphics.drawLine(n, 0, n, this.getHeight());
            graphics.drawLine(0, n2, this.getWidth(), n2);
        }

        @Override
        void select(Point point) {
            Insets insets = this.getInsets();
            Sprite sprite = this.getBackgroundSprite();
            int n = sprite.getWidth();
            int n2 = sprite.getHeight();
            int n3 = point.x - insets.left;
            n3 = MathHelper.clamp(n3, 0, n);
            float f = (float)n3 / (float)n;
            int n4 = point.y - insets.top;
            n4 = MathHelper.clamp(n4, 0, n2);
            float f2 = 1.0f - (float)n4 / (float)n2;
            ((AbstractColorSelector.HSLSelectionModel)this.model).setHS(f, f2);
        }
    }
}

