/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.LayerRenderer;
import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.sprite.Tileset;
import java.awt.Graphics;

public abstract class EffectLayer
extends LayerRenderer {
    final long duration;
    final long timestamp;

    public EffectLayer(int n) {
        this.duration = n;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public void setTileset(Tileset tileset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 32;
        this.drawScreen(graphics, n * n5, n2 * n5, n3 * n5, n4 * n5);
    }

    abstract void drawScreen(Graphics var1, int var2, int var3, int var4, int var5);

    public boolean isExpired() {
        return System.currentTimeMillis() > this.timestamp + this.duration;
    }

    int alpha(int n) {
        if (TransparencyMode.TRANSPARENCY == 2) {
            return n > 127 ? 255 : 0;
        }
        return n;
    }
}

