/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.GameScreen;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.common.Direction;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;

class GameKeyHandler
implements KeyListener {
    private final StendhalClient client;
    private final GameScreen screen;
    private long lastAction = 0L;
    private final int doublePressThreshold = 300;
    private int prevKeyPress = -1;
    private long doublePressStart = -1L;
    private DelayedDirectionRelease directionRelease;

    GameKeyHandler(StendhalClient stendhalClient, GameScreen gameScreen) {
        this.client = stendhalClient;
        this.screen = gameScreen;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = this.isDoublePress(n);
        if (!this.client.keyIsPressed(n)) {
            this.client.onKeyPressed(n);
            if (keyEvent.isShiftDown()) {
                return;
            }
            switch (n) {
                case 82: {
                    if (!keyEvent.isControlDown()) break;
                    this.screen.clearTexts();
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    Object obj;
                    EntityView<?> entityView;
                    Direction direction = this.keyCodeToDirection(keyEvent.getKeyCode());
                    User user = User.get();
                    if (user.getRPObject().has("autowalk") || "true".equals(WtWindowManager.getInstance().getProperty("move.doubletapautowalk", "false")) && bl) {
                        this.processAutoWalk(direction, user);
                        break;
                    }
                    if (keyEvent.isAltGraphDown() && System.currentTimeMillis() - this.lastAction > 1000L && (entityView = this.screen.getEntityViewAt(user.getX() + (double)direction.getdx(), user.getY() + (double)direction.getdy())) != null && !(obj = entityView.getEntity()).equals(user)) {
                        entityView.onAction();
                        this.lastAction = System.currentTimeMillis();
                    }
                    this.processDirectionPress(direction, keyEvent.isControlDown());
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.switchToSpellCastingState(keyEvent);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this.client.keyIsPressed(n)) {
            this.client.onKeyReleased(n);
            switch (n) {
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    this.processDirectionRelease(this.keyCodeToDirection(keyEvent.getKeyCode()), keyEvent.isControlDown());
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public boolean isDoublePress(int n) {
        if (this.doublePressStart >= 0L && n == this.prevKeyPress && System.currentTimeMillis() - this.doublePressStart < 300L) {
            this.prevKeyPress = -1;
            this.doublePressStart = -1L;
            return true;
        }
        this.prevKeyPress = n;
        this.doublePressStart = System.currentTimeMillis();
        return false;
    }

    synchronized void processDelayedDirectionRelease() {
        if (this.directionRelease != null && this.directionRelease.hasExpired()) {
            this.client.removeDirection(this.directionRelease.getDirection(), this.directionRelease.isFacing());
            this.directionRelease = null;
        }
    }

    private Direction keyCodeToDirection(int n) {
        switch (n) {
            case 37: 
            case 226: {
                return Direction.LEFT;
            }
            case 39: 
            case 227: {
                return Direction.RIGHT;
            }
            case 38: 
            case 224: {
                return Direction.UP;
            }
            case 40: 
            case 225: {
                return Direction.DOWN;
            }
        }
        return null;
    }

    private synchronized void processDirectionPress(Direction direction, boolean bl) {
        User user;
        if (this.directionRelease != null) {
            if (this.directionRelease.check(direction, bl)) {
                this.directionRelease = null;
                return;
            }
            this.client.removeDirection(this.directionRelease.getDirection(), this.directionRelease.isFacing());
            this.directionRelease = null;
        }
        if (this.client.addDirection(direction, bl) && (user = User.get()) != null) {
            user.predictMovement(direction, bl);
        }
    }

    private synchronized void processAutoWalk(Direction direction, User user) {
        boolean bl;
        RPAction rPAction = new RPAction();
        boolean bl2 = bl = direction == user.getDirection();
        if (!bl) {
            RPAction rPAction2 = new RPAction();
            rPAction2.put("type", "face");
            rPAction2.put("dir", direction.get());
            this.client.send(rPAction2);
        }
        if (!user.getRPObject().has("autowalk")) {
            rPAction.put("type", "walk");
        } else if (bl) {
            rPAction.put("type", "walk");
            rPAction.put("mode", "stop");
        }
        if (rPAction.has("type")) {
            this.client.send(rPAction);
        }
    }

    private synchronized void processDirectionRelease(Direction direction, boolean bl) {
        if (this.directionRelease != null) {
            if (this.directionRelease.check(direction, bl)) {
                return;
            }
            this.client.removeDirection(this.directionRelease.getDirection(), this.directionRelease.isFacing());
        }
        this.directionRelease = new DelayedDirectionRelease(direction, bl);
    }

    public void flushDirectionKeys() {
        RPObject rPObject = this.client.getPlayer();
        if (rPObject != null && !rPObject.has("autowalk") && !rPObject.has("pathset")) {
            for (Direction object : Arrays.asList(Direction.LEFT, Direction.RIGHT, Direction.UP, Direction.DOWN)) {
                this.client.removeDirection(object, false);
            }
        }
        for (Integer n : Arrays.asList(37, 39, 38, 40)) {
            if (!this.client.keyIsPressed(n)) continue;
            this.client.onKeyReleased(n);
        }
    }

    private void switchToSpellCastingState(KeyEvent keyEvent) {
        this.screen.switchToSpellCasting(keyEvent);
    }

    private static class DelayedDirectionRelease {
        protected static final long DELAY = 50L;
        protected long expiration;
        protected Direction dir;
        protected boolean facing;

        public DelayedDirectionRelease(Direction direction, boolean bl) {
            this.dir = direction;
            this.facing = bl;
            this.expiration = System.currentTimeMillis() + 50L;
        }

        public boolean check(Direction direction, boolean bl) {
            if (this.dir != direction) {
                return false;
            }
            if (this.facing != bl) {
                return false;
            }
            long l = System.currentTimeMillis();
            if (l >= this.expiration) {
                return false;
            }
            this.expiration = l + 50L;
            return true;
        }

        public Direction getDirection() {
            return this.dir;
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() >= this.expiration;
        }

        public boolean isFacing() {
            return this.facing;
        }
    }
}

