/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.IGameScreen;
import games.stendhal.client.StaticGameLayers;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.User;
import games.stendhal.client.entity.factory.EntityMap;
import games.stendhal.client.gui.SlotWindow;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.spellcasting.DefaultGroundContainerMouseState;
import games.stendhal.client.gui.spellcasting.GroundContainerMouseState;
import games.stendhal.client.gui.styled.cursor.CursorRepository;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.common.Direction;
import games.stendhal.common.NotificationType;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

public class GroundContainer
implements Inspector,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final Logger logger = Logger.getLogger(GroundContainer.class);
    private CursorRepository cursorRepository = new CursorRepository();
    private final IGameScreen screen;
    private final StendhalClient client;
    private final JComponent canvas;
    private GroundContainerMouseState state;

    public GroundContainer(StendhalClient stendhalClient, IGameScreen iGameScreen, JComponent jComponent) {
        this.client = stendhalClient;
        this.screen = iGameScreen;
        this.canvas = jComponent;
        this.state = new DefaultGroundContainerMouseState(this);
    }

    @Override
    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        this.state.mouseMoved(mouseEvent);
        if ((mouseEvent.getModifiersEx() & 0x400) != 0) {
            return;
        }
        StendhalCursor stendhalCursor = this.getCursor(mouseEvent.getPoint());
        this.canvas.setCursor(this.cursorRepository.get(stendhalCursor));
    }

    private StendhalCursor getCursor(Point point) {
        return this.state.getCursor(point);
    }

    public void createAndSendMoveToAction(Point2D point2D, boolean bl) {
        Direction direction;
        RPAction rPAction = new RPAction();
        rPAction.put("type", "moveto");
        rPAction.put("x", (int)point2D.getX());
        rPAction.put("y", (int)point2D.getY());
        if (bl) {
            rPAction.put("double_click", "");
        }
        if ((direction = this.calculateZoneChangeDirection(point2D)) != null) {
            rPAction.put("extend", direction.ordinal());
        }
        this.client.send(rPAction);
    }

    public Direction calculateZoneChangeDirection(Point2D point2D) {
        StaticGameLayers staticGameLayers = StendhalClient.get().getStaticGameLayers();
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = staticGameLayers.getWidth();
        double d4 = staticGameLayers.getHeight();
        if (d < 0.333) {
            return Direction.LEFT;
        }
        if (d > d3 - 0.333) {
            return Direction.RIGHT;
        }
        if (d2 < 0.333) {
            return Direction.UP;
        }
        if (d2 > d4 - 0.4) {
            return Direction.DOWN;
        }
        return null;
    }

    public void dropEntity(IEntity iEntity, int n, Point point) {
        RPAction rPAction = new RPAction();
        RPObject rPObject = iEntity.getRPObject();
        if (rPObject == null) {
            return;
        }
        RPObject rPObject2 = rPObject.getContainer();
        rPAction.put("source_path", iEntity.getPath());
        if (rPObject2 != null) {
            rPAction.put("type", "drop");
            rPAction.put("baseobject", rPObject2.getID().getObjectID());
            rPAction.put("baseslot", rPObject.getContainerSlot().getName());
        } else {
            rPAction.put("type", "displace");
        }
        rPAction.put("baseitem", rPObject.getID().getObjectID());
        if (n >= 1) {
            rPAction.put("quantity", n);
        }
        Point2D point2D = this.screen.convertScreenViewToWorld(point);
        rPAction.put("x", (int)point2D.getX());
        rPAction.put("y", (int)point2D.getY());
        rPAction.put("zone", iEntity.getRPObject().getBaseContainer().get("zoneid"));
        this.client.send(rPAction);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (User.isNull()) {
            return;
        }
        logger.debug((Object)(mouseWheelEvent.getClickCount() + " click count and " + mouseWheelEvent.getScrollType() + " scroll type and wheel rotation " + mouseWheelEvent.getWheelRotation()));
        if (mouseWheelEvent.getClickCount() <= 1) {
            User user = User.get();
            Direction direction = user.getDirection();
            Direction direction2 = null;
            direction2 = mouseWheelEvent.getUnitsToScroll() > 0 ? direction.nextDirection() : direction.nextDirection().oppositeDirection();
            if (direction2 != null && direction2 != direction) {
                RPAction rPAction = new RPAction();
                rPAction.put("type", "face");
                rPAction.put("dir", direction2.get());
                this.client.send(rPAction);
            }
        }
    }

    @Override
    public SlotWindow inspectMe(IEntity iEntity, RPSlot rPSlot, SlotWindow slotWindow, int n, int n2) {
        if (slotWindow != null && slotWindow.isVisible()) {
            slotWindow.raise();
            return slotWindow;
        }
        SlotWindow slotWindow2 = new SlotWindow(iEntity.getType(), n, n2);
        slotWindow2.setAcceptedTypes(EntityMap.getClass("item", null, null));
        slotWindow2.setSlot(iEntity, rPSlot.getName());
        if (slotWindow2.isCloseEnough()) {
            j2DClient.get().addWindow(slotWindow2);
            slotWindow2.raise();
            slotWindow2.setVisible(true);
            return slotWindow2;
        }
        j2DClient.get().addEventLine(new EventLine("", "The " + iEntity.getType() + " is too far away.", NotificationType.CLIENT));
        return null;
    }

    public IGameScreen getScreen() {
        return this.screen;
    }

    public JComponent getCanvas() {
        return this.canvas;
    }

    public StendhalClient getClient() {
        return this.client;
    }

    public void setNewMouseHandlerState(GroundContainerMouseState groundContainerMouseState) {
        this.state = groundContainerMouseState;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.state.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.state.mouseReleased(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.state.mousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.state.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.state.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.state.mouseExited(mouseEvent);
    }
}

