/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.GameLoop;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.DragLayer;
import games.stendhal.client.gui.DropTarget;
import games.stendhal.client.gui.Inspectable;
import games.stendhal.client.gui.MouseHandler;
import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.j2d.entity.EntityViewFactory;
import games.stendhal.client.gui.styled.cursor.CursorRepository;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.gui.wt.EntityViewCommandList;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;

class ItemPanel
extends JComponent
implements DropTarget,
Inspectable {
    private static final long serialVersionUID = 3409932623156446910L;
    private static final int POPUP_MENU_OFFSET = 10;
    private static final CursorRepository cursorRepository = new CursorRepository();
    private static final Sprite background = SpriteStore.get().getSprite("data/gui/slot.png");
    private final Sprite placeholder;
    private EntityView<?> view;
    private IEntity parent;
    private JPopupMenu popupMenu;
    private Inspector inspector;
    private int itemNumber;
    private List<Class<? extends IEntity>> acceptedTypes = new ArrayList<Class<? extends IEntity>>();

    ItemPanel(String string, Sprite sprite) {
        this.placeholder = this.preparePlaceholder(sprite);
        this.setName(string);
        Dimension dimension = new Dimension(background.getWidth(), background.getHeight());
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setOpaque(false);
        ItemPanelMouseHandler itemPanelMouseHandler = new ItemPanelMouseHandler();
        this.addMouseMotionListener(itemPanelMouseHandler);
        this.addMouseListener(itemPanelMouseHandler);
    }

    private Sprite preparePlaceholder(Sprite sprite) {
        if (sprite == null || TransparencyMode.TRANSPARENCY == 2) {
            return sprite;
        }
        BufferedImage bufferedImage = new BufferedImage(sprite.getWidth(), sprite.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        sprite.draw(graphics2D, 0, 0);
        RescaleOp rescaleOp = new RescaleOp(new float[]{3.0f, 3.0f, 3.0f, 0.5f}, new float[]{-450.0f, -450.0f, -450.0f, 0.0f}, null);
        rescaleOp.filter(bufferedImage, bufferedImage);
        graphics2D.dispose();
        return new ImageSprite(bufferedImage);
    }

    void setItemNumber(int n) {
        this.itemNumber = n;
    }

    @Override
    public void setInspector(Inspector inspector) {
        this.inspector = inspector;
    }

    protected void setEntity(IEntity iEntity) {
        if (this.view != null) {
            if (this.view.getEntity() == iEntity) {
                return;
            }
            this.view.release();
        }
        if (iEntity != null) {
            this.setEntityView(EntityViewFactory.create(iEntity));
        } else {
            this.setEntityView(null);
        }
        this.popupMenu = null;
        this.repaint();
    }

    private void setEntityView(EntityView<?> entityView) {
        this.view = entityView;
        if (entityView != null) {
            entityView.setContained(true);
            entityView.setInspector(this.inspector);
            if (this.parent.isUser()) {
                this.setCursor(cursorRepository.get(entityView.getCursor()));
            } else {
                this.setCursor(cursorRepository.get(StendhalCursor.ITEM_PICK_UP_FROM_SLOT));
            }
        } else {
            this.setCursor(null);
        }
        this.popupMenu = null;
    }

    IEntity getEntity() {
        if (this.view != null) {
            return this.view.getEntity();
        }
        return null;
    }

    void moveViewTo(ItemPanel itemPanel) {
        itemPanel.setEntityView(this.view);
        this.setEntityView(null);
    }

    protected void setParent(IEntity iEntity) {
        this.parent = iEntity;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        background.draw(graphics, 0, 0);
        EntityView<?> entityView = this.view;
        if (entityView != null) {
            int n = (this.getWidth() - 32) / 2;
            int n2 = (this.getHeight() - 32) / 2;
            Graphics2D graphics2D = (Graphics2D)graphics.create(0, 0, this.getWidth(), this.getHeight());
            graphics2D.translate(n, n2);
            entityView.draw(graphics2D);
            graphics2D.dispose();
        } else if (this.placeholder != null) {
            this.placeholder.draw(graphics, (this.getWidth() - this.placeholder.getWidth()) / 2, (this.getHeight() - this.placeholder.getHeight()) / 2);
        }
    }

    @Override
    public void dropEntity(IEntity iEntity, int n, Point point) {
        if (this.view != null && iEntity == this.view.getEntity()) {
            return;
        }
        if (iEntity.getRPObject().getContainerSlot() == this.parent.getSlot(this.getName())) {
            if (n != -1) {
                return;
            }
            this.reorder(iEntity);
            return;
        }
        RPAction rPAction = new RPAction();
        rPAction.put("type", "equip");
        rPAction.put("source_path", iEntity.getPath());
        List<String> list = this.parent.getPath();
        list.add(this.getName());
        rPAction.put("target_path", list);
        if (n >= 1) {
            rPAction.put("quantity", n);
        }
        rPAction.put("zone", iEntity.getRPObject().getBaseContainer().get("zoneid"));
        RPObject rPObject = iEntity.getRPObject();
        if (rPObject.isContained()) {
            rPAction.put("baseobject", rPObject.getContainer().getID().getObjectID());
            rPAction.put("baseslot", rPObject.getContainerSlot().getName());
        }
        rPAction.put("baseitem", rPObject.getID().getObjectID());
        rPAction.put("targetobject", this.parent.getID().getObjectID());
        rPAction.put("targetslot", this.getName());
        StendhalClient.get().send(rPAction);
    }

    private void reorder(final IEntity iEntity) {
        if (!StendhalClient.serverVersionAtLeast("1.00.5")) {
            return;
        }
        GameLoop.get().runOnce(new Runnable(){

            @Override
            public void run() {
                RPObject rPObject = iEntity.getRPObject();
                RPSlot rPSlot = rPObject.getContainerSlot();
                int n = 0;
                for (RPObject rPObject2 : rPSlot) {
                    if (rPObject2 == rPObject && ItemPanel.this.itemNumber != n) {
                        RPAction rPAction = new RPAction();
                        rPAction.put("type", "reorder");
                        rPAction.put("source_path", iEntity.getPath());
                        rPAction.put("new_position", ItemPanel.this.itemNumber);
                        StendhalClient.get().send(rPAction);
                        return;
                    }
                    ++n;
                }
            }
        });
    }

    @SafeVarargs
    final void setAcceptedTypes(Class<? extends IEntity> ... classArray) {
        this.acceptedTypes = Arrays.asList(classArray);
    }

    void setAcceptedTypes(List<Class<? extends IEntity>> list) {
        this.acceptedTypes = list;
    }

    @Override
    public boolean canAccept(IEntity iEntity) {
        for (Class<? extends IEntity> clazz : this.acceptedTypes) {
            if (!clazz.isAssignableFrom(iEntity.getClass())) continue;
            return true;
        }
        return false;
    }

    private class ItemPanelMouseHandler
    extends MouseHandler {
        private ItemPanelMouseHandler() {
        }

        @Override
        protected void onDragStart(Point point) {
            if (ItemPanel.this.view != null && ItemPanel.this.view.isMovable()) {
                DragLayer.get().startDrag((IEntity)ItemPanel.this.view.getEntity());
            }
        }

        @Override
        protected boolean onMouseClick(Point point) {
            if (ItemPanel.this.view == null) {
                return true;
            }
            boolean bl = WtWindowManager.getInstance().getPropertyBoolean("ui.doubleclick", false);
            if (bl) {
                return false;
            }
            if (this.isUserSlot()) {
                return ItemPanel.this.view.onHarmlessAction();
            }
            if (this.isCtrlDown()) {
                return false;
            }
            this.moveItemToBag();
            return true;
        }

        @Override
        protected boolean onMouseDoubleClick(Point point) {
            if (ItemPanel.this.view == null) {
                return false;
            }
            if (this.isUserSlot()) {
                ItemPanel.this.view.onAction();
                return true;
            }
            this.moveItemToBag();
            return true;
        }

        private boolean isUserSlot() {
            return ItemPanel.this.parent.getRPObject().getContainerBaseOwner().equals((Object)User.get().getRPObject());
        }

        @Override
        protected void onMouseRightClick(Point point) {
            if (ItemPanel.this.view != null) {
                if (ItemPanel.this.popupMenu == null) {
                    ItemPanel.this.popupMenu = new EntityViewCommandList(ItemPanel.this.getName(), ItemPanel.this.view.getActions(), ItemPanel.this.view){

                        @Override
                        protected void doAction(String string) {
                            super.doAction(string);
                            this.setVisible(false);
                        }
                    };
                }
                ItemPanel.this.popupMenu.show(ItemPanel.this, point.x - 10, point.y - 10);
            }
        }

        private void moveItemToBag() {
            RPAction rPAction = new RPAction();
            EntityView entityView = ItemPanel.this.view;
            IEntity iEntity = ItemPanel.this.parent;
            if (entityView == null || iEntity == null) {
                return;
            }
            rPAction.put("type", "equip");
            rPAction.put("source_path", entityView.getEntity().getPath());
            rPAction.put("target_path", Arrays.asList(Integer.toString(User.get().getID().getObjectID()), "bag"));
            RPObject rPObject = entityView.getEntity().getRPObject();
            rPAction.put("baseobject", iEntity.getID().getObjectID());
            rPAction.put("baseslot", ItemPanel.this.getName());
            rPAction.put("baseitem", rPObject.getID().getObjectID());
            rPAction.put("targetobject", User.get().getID().getObjectID());
            rPAction.put("targetslot", "bag");
            rPAction.put("clicked", "");
            StendhalClient.get().send(rPAction);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            IEntity iEntity = ItemPanel.this.getEntity();
            if (iEntity != null) {
                RPObject rPObject = iEntity.getRPObject();
                if ("scroll".equals(iEntity.getEntityClass()) && rPObject.has("dest")) {
                    ItemPanel.this.setToolTipText(rPObject.get("dest").replaceFirst(",", " "));
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ItemPanel.this.setToolTipText(null);
        }
    }
}

