/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.AbstractScalingModel;

public class LinearScalingModel
extends AbstractScalingModel {
    private double maxValue;
    private int maxRepresentation;
    private double scale;
    private double value;

    public LinearScalingModel() {
        this(1.0, 1);
    }

    public LinearScalingModel(double d, int n) {
        this.maxValue = d;
        this.maxRepresentation = n;
        this.calculateScale();
    }

    @Override
    public void setValue(double d) {
        this.value = d;
        this.setRepresentation(Math.min((int)Math.round(this.value * this.scale), this.maxRepresentation));
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void setMaxRepresentation(int n) {
        if (n != this.maxRepresentation) {
            this.maxRepresentation = n;
            this.calculateScale();
            this.setValue(this.value);
        }
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
        this.calculateScale();
        this.setValue(this.value);
    }

    private void calculateScale() {
        this.scale = (double)this.maxRepresentation / this.maxValue;
    }
}

