/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.stendhal;
import games.stendhal.client.update.ClientGameConfiguration;
import java.awt.GraphicsConfiguration;
import java.awt.MouseInfo;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

final class MainFrame {
    private MainFrame() {
    }

    private static void setIcon(JFrame jFrame) {
        URL uRL = DataLoader.getResource(ClientGameConfiguration.get((String)"GAME_ICON"));
        jFrame.setIconImage(new ImageIcon(uRL).getImage());
    }

    private static void setTitle(JFrame jFrame) {
        String string = "";
        if ("PRE_RELEASE 2026-01-08" != null) {
            string = " - PRE_RELEASE 2026-01-08";
        }
        jFrame.setTitle(ClientGameConfiguration.get((String)"GAME_NAME") + " " + stendhal.VERSION + string + " - a multiplayer online game using Arianne");
    }

    static JFrame prepare(JFrame jFrame) {
        if (jFrame == null) {
            GraphicsConfiguration graphicsConfiguration = MouseInfo.getPointerInfo().getDevice().getDefaultConfiguration();
            jFrame = new JFrame(graphicsConfiguration);
            jFrame.setLocationByPlatform(true);
        }
        MainFrame.setTitle(jFrame);
        MainFrame.setIcon(jFrame);
        WindowUtils.trackLocation(jFrame, "main", true);
        jFrame.setDefaultCloseOperation(0);
        WindowUtils.closeOnEscape(jFrame);
        return jFrame;
    }
}

