/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Locale;

public abstract class MouseHandler
implements MouseListener,
MouseMotionListener {
    private boolean rightMouseButtonPressed;
    private long timeOfLastMousePress = System.currentTimeMillis();
    private boolean dragging;
    private boolean lastClickWasHandled;
    private int flags;

    protected abstract boolean onMouseClick(Point var1);

    protected abstract boolean onMouseDoubleClick(Point var1);

    protected abstract void onMouseRightClick(Point var1);

    protected abstract void onDragStart(Point var1);

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.rightMouseButtonPressed = true;
        }
        this.timeOfLastMousePress = System.currentTimeMillis();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.dragging = false;
        }
        if (mouseEvent.getButton() == 3) {
            this.rightMouseButtonPressed = false;
        }
        if (System.currentTimeMillis() - this.timeOfLastMousePress < 1000L) {
            this.onMouseClick(mouseEvent);
            this.timeOfLastMousePress = 0L;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.rightMouseButtonPressed) {
            return;
        }
        if (!this.dragging) {
            this.onDragStart(mouseEvent.getPoint());
            this.dragging = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void onMouseClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.flags = mouseEvent.getModifiersEx();
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("os x") && this.isCtrlDown()) {
            this.onMouseRightClick(point);
        } else if (mouseEvent.getButton() == 1) {
            if (mouseEvent.getClickCount() == 1) {
                this.lastClickWasHandled = this.onMouseClick(point);
            } else if (mouseEvent.getClickCount() >= 2) {
                this.lastClickWasHandled = this.lastClickWasHandled ? this.onMouseClick(point) : this.onMouseDoubleClick(point);
            }
        } else if (mouseEvent.getButton() == 3) {
            this.onMouseRightClick(point);
        }
    }

    protected boolean isCtrlDown() {
        return (this.flags & 0x80) != 0;
    }

    protected boolean isShiftDown() {
        return (this.flags & 0x40) != 0;
    }
}

