/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.NotificationChannel;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.common.NotificationType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class NotificationChannelManager {
    private final List<NotificationChannel> channels = new ArrayList<NotificationChannel>();
    private final List<HiddenChannelListener> listeners = new CopyOnWriteArrayList<HiddenChannelListener>();
    private NotificationChannel visibleChannel;

    NotificationChannelManager() {
    }

    void addChannel(NotificationChannel notificationChannel) {
        this.channels.add(notificationChannel);
    }

    void addHiddenChannelListener(HiddenChannelListener hiddenChannelListener) {
        this.listeners.add(hiddenChannelListener);
    }

    List<NotificationChannel> getChannels() {
        return this.channels;
    }

    void addEventLine(EventLine eventLine) {
        if (eventLine.getType() == NotificationType.CLIENT) {
            this.visibleChannel.addEventLine(eventLine);
        } else {
            int n = 0;
            for (NotificationChannel notificationChannel : this.channels) {
                if (notificationChannel.addEventLine(eventLine) && notificationChannel != this.visibleChannel) {
                    this.fireHiddenChannelModified(n);
                }
                ++n;
            }
        }
    }

    NotificationChannel getVisibleChannel() {
        return this.visibleChannel;
    }

    void setVisibleChannel(NotificationChannel notificationChannel) {
        this.visibleChannel = notificationChannel;
    }

    private void fireHiddenChannelModified(int n) {
        for (HiddenChannelListener hiddenChannelListener : this.listeners) {
            hiddenChannelListener.channelModified(n);
        }
    }

    static interface HiddenChannelListener {
        public void channelModified(int var1);
    }
}

