/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.OutfitStore;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.gui.AbstractColorSelector;
import games.stendhal.client.gui.ColorSelector;
import games.stendhal.client.gui.OutfitColor;
import games.stendhal.client.gui.SkinColorSelector;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.common.Outfits;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marauroa.common.game.RPAction;
import org.apache.log4j.Logger;

class OutfitDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(OutfitDialog.class);
    private static final int PLAYER_WIDTH = 48;
    private static final int PLAYER_HEIGHT = 64;
    private static final int SLIDER_WIDTH = 80;
    private final SelectorModel hair = new SelectorModel(57);
    private final SelectorModel head = new SelectorModel(4);
    private final SelectorModel body = new SelectorModel(3);
    private final SelectorModel dress = new SelectorModel(65);
    private final SelectorModel eyes = new SelectorModel(28);
    private final SelectorModel mouth = new SelectorModel(5);
    private final SelectorModel hat = new SelectorModel(19);
    private final SelectorModel mask = new SelectorModel(9);
    private final OutfitColor outfitColor;
    private int direction = 2;
    private final SpriteStore store = SpriteStore.get();
    private final OutfitStore ostore = OutfitStore.get();
    private final List<ResetListener> resetListeners = new ArrayList<ResetListener>();
    private OutfitLabel hairLabel;
    private OutfitLabel headLabel;
    private OutfitLabel bodyLabel;
    private OutfitLabel dressLabel;
    private OutfitLabel outfitLabel;
    private OutfitLabel eyesLabel;
    private OutfitLabel mouthLabel;
    private OutfitLabel hatLabel;
    private OutfitLabel maskLabel;
    private JSlider directionSlider;

    /*
     * WARNING - void declaration
     */
    OutfitDialog(Frame frame, String string, String string2, OutfitColor outfitColor) {
        super(frame, false);
        void var9_14;
        Object object;
        this.outfitColor = outfitColor;
        this.initComponents();
        this.applyStyle();
        this.setTitle(string);
        this.hair.addListener(this.hairLabel);
        this.hair.addListener(this.outfitLabel);
        this.eyes.addListener(this.eyesLabel);
        this.eyes.addListener(this.outfitLabel);
        this.mouth.addListener(this.mouthLabel);
        this.mouth.addListener(this.outfitLabel);
        this.head.addListener(this.headLabel);
        this.head.addListener(this.outfitLabel);
        this.body.addListener(this.bodyLabel);
        this.body.addListener(this.outfitLabel);
        this.dress.addListener(this.dressLabel);
        this.dress.addListener(this.outfitLabel);
        this.hat.addListener(this.outfitLabel);
        this.hat.addListener(this.hatLabel);
        this.mask.addListener(this.maskLabel);
        this.mask.addListener(this.outfitLabel);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String object22 : string2.split(",")) {
            if (!object22.contains("=")) continue;
            object = object22.split("=");
            hashMap.put(object[0], Integer.parseInt(object[1]));
        }
        Object object3 = (Integer)hashMap.get("body");
        Integer n = (Integer)hashMap.get("dress");
        Integer n2 = (Integer)hashMap.get("head");
        Integer n3 = (Integer)hashMap.get("mouth");
        object = (Integer)hashMap.get("eyes");
        Integer n4 = (Integer)hashMap.get("mask");
        Integer n5 = (Integer)hashMap.get("hair");
        Integer n6 = (Integer)hashMap.get("hat");
        if (object3 == null) {
            object3 = 0;
        }
        if (n == null) {
            n = 0;
        }
        if (n2 == null) {
            n2 = 0;
        }
        if (n3 == null) {
            Integer n7 = 0;
        }
        if (object == null) {
            object = 0;
        }
        if (n4 == null) {
            n4 = 0;
        }
        if (n5 == null) {
            n5 = 0;
        }
        if (n6 == null) {
            n6 = 0;
        }
        this.body.setIndex(this.checkIndex((Integer)object3, this.body));
        this.dress.setIndex(this.checkIndex(n, this.dress));
        this.head.setIndex(this.checkIndex(n2, this.head));
        this.mouth.setIndex(this.checkIndex(var9_14.intValue(), this.mouth));
        this.eyes.setIndex(this.checkIndex((Integer)object, this.eyes));
        this.mask.setIndex(this.checkIndex(n4, this.mask));
        this.hair.setIndex(this.checkIndex(n5, this.hair));
        this.hat.setIndex(this.checkIndex(n6, this.hat));
        this.pack();
        WindowUtils.closeOnEscape(this);
        WindowUtils.trackLocation(this, "outfit", false);
    }

    private int checkIndex(int n, SelectorModel selectorModel) {
        if (!selectorModel.isAllowed(n)) {
            return 0;
        }
        return n;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        int n = 5;
        JComponent jComponent = SBoxLayout.createContainer(true, n);
        JComponent jComponent2 = (JComponent)this.getContentPane();
        jComponent2.setBorder(BorderFactory.createCompoundBorder(jComponent2.getBorder(), BorderFactory.createEmptyBorder(n, n, n, n)));
        jComponent2.setLayout(new SBoxLayout(false, n));
        this.add(jComponent);
        JComponent jComponent3 = SBoxLayout.createContainer(false, n);
        jComponent.add(jComponent3);
        final SpriteRetriever spriteRetriever = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getHairSprite();
            }
        };
        this.hairLabel = new OutfitLabel(spriteRetriever);
        jComponent3.add(this.createSelector(this.hair, this.hairLabel));
        SpriteRetriever spriteRetriever2 = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getEyesSprite();
            }
        };
        this.eyesLabel = new OutfitLabel(spriteRetriever2);
        jComponent3.add(this.createSelector(this.eyes, this.eyesLabel));
        SpriteRetriever spriteRetriever3 = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getMouthSprite();
            }
        };
        this.mouthLabel = new OutfitLabel(spriteRetriever3);
        jComponent3.add(this.createSelector(this.mouth, this.mouthLabel));
        SpriteRetriever spriteRetriever4 = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getHeadSprite();
            }
        };
        this.headLabel = new OutfitLabel(spriteRetriever4);
        jComponent3.add(this.createSelector(this.head, this.headLabel));
        SpriteRetriever spriteRetriever5 = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getBodySprite();
            }
        };
        this.bodyLabel = new OutfitLabel(spriteRetriever5);
        jComponent3.add(this.createSelector(this.body, this.bodyLabel));
        SpriteRetriever spriteRetriever6 = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getDressSprite();
            }
        };
        this.dressLabel = new OutfitLabel(spriteRetriever6);
        jComponent3.add(this.createSelector(this.dress, this.dressLabel));
        JComponent jComponent4 = SBoxLayout.createContainer(false);
        jComponent.add((Component)jComponent4, (Object)SLayout.EXPAND_Y);
        JComponent jComponent5 = this.createColorSelector("Hair", "hair", this.hairLabel);
        jComponent5.setAlignmentX(0.5f);
        jComponent4.add(jComponent5);
        jComponent5 = this.createColorSelector("Eyes", "eyes", this.eyesLabel);
        jComponent5.setAlignmentX(0.5f);
        jComponent4.add(jComponent5);
        jComponent5 = this.createColorSelector("Skin", "skin", true, this.bodyLabel, this.headLabel);
        jComponent5.setAlignmentX(0.5f);
        jComponent4.add(jComponent5);
        jComponent5 = this.createColorSelector("Dress", "dress", this.dressLabel);
        jComponent5.setAlignmentX(0.5f);
        jComponent4.add(jComponent5);
        SBoxLayout.addSpring(jComponent4);
        JComponent jComponent6 = SBoxLayout.createContainer(false, n);
        jComponent.add(jComponent6);
        SpriteRetriever spriteRetriever7 = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getHatSprite();
            }
        };
        this.hatLabel = new OutfitLabel(spriteRetriever7);
        jComponent6.add(this.createSelector(this.hat, this.hatLabel));
        SpriteRetriever spriteRetriever8 = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getMaskSprite();
            }
        };
        this.maskLabel = new OutfitLabel(spriteRetriever8);
        jComponent6.add(this.createSelector(this.mask, this.maskLabel));
        jComponent4 = SBoxLayout.createContainer(false, n);
        jComponent4.setAlignmentY(0.5f);
        jComponent.add(jComponent4);
        this.outfitLabel = new OutfitLabel(new SpriteRetriever[]{spriteRetriever5, spriteRetriever6, spriteRetriever4, spriteRetriever3, spriteRetriever2, spriteRetriever8, spriteRetriever, spriteRetriever7}){

            @Override
            public void changed() {
                BufferedImage bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(48, 64);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, 0, 48, 64);
                for (SpriteRetriever spriteRetriever2 : this.retrievers) {
                    if (spriteRetriever2.equals(spriteRetriever) && Outfits.HATS_NO_HAIR.contains(OutfitDialog.this.hat.getIndex())) continue;
                    spriteRetriever2.getSprite().draw(graphics, 0, 0);
                }
                graphics.dispose();
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                this.setIcon(imageIcon);
            }
        };
        this.outfitLabel.setAlignmentX(0.5f);
        jComponent4.add(this.outfitLabel);
        this.directionSlider = new JSlider();
        this.directionSlider.setMaximum(3);
        this.directionSlider.setSnapToTicks(true);
        this.directionSlider.setValue(2);
        this.directionSlider.setInverted(true);
        Dimension dimension = this.directionSlider.getPreferredSize();
        dimension.width = 80;
        this.directionSlider.setPreferredSize(dimension);
        this.directionSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OutfitDialog.this.sliderDirectionStateChanged();
            }
        });
        jComponent4.add(this.directionSlider);
        JComponent jComponent7 = SBoxLayout.createContainer(true, n);
        jComponent7.setAlignmentX(1.0f);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutfitDialog.this.dispatchEvent(new WindowEvent(OutfitDialog.this, 201));
            }
        });
        jButton.setMnemonic(67);
        jComponent7.add(jButton);
        JButton jButton2 = new JButton("Change Outfit");
        jButton2.setMnemonic(65);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutfitDialog.this.okActionPerformed();
            }
        });
        jComponent7.add(jButton2);
        this.add(jComponent7);
    }

    private JComponent createSelector(final SelectorModel selectorModel, OutfitLabel outfitLabel) {
        JComponent jComponent = SBoxLayout.createContainer(true, 5);
        JButton jButton = new JButton("<");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectorModel.scrollDown();
            }
        });
        jComponent.add(jButton);
        jComponent.add(outfitLabel);
        jButton = new JButton(">");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectorModel.scrollUp();
            }
        });
        jComponent.add(jButton);
        return jComponent;
    }

    private void sliderDirectionStateChanged() {
        this.direction = this.directionSlider.getValue();
        this.outfitLabel.changed();
        this.hairLabel.changed();
        this.eyesLabel.changed();
        this.mouthLabel.changed();
        this.headLabel.changed();
        this.dressLabel.changed();
        this.bodyLabel.changed();
        this.hatLabel.changed();
        this.maskLabel.changed();
    }

    private Sprite getHatSprite() {
        return this.store.getTile(this.ostore.getLayerSprite("hat", this.hat.getIndex()), 48, this.direction * 64, 48, 64);
    }

    private Sprite getHairSprite() {
        return this.store.getTile(this.ostore.getLayerSprite("hair", this.hair.getIndex(), this.outfitColor), 48, this.direction * 64, 48, 64);
    }

    private Sprite getMaskSprite() {
        return this.store.getTile(this.ostore.getLayerSprite("mask", this.mask.getIndex()), 48, this.direction * 64, 48, 64);
    }

    private Sprite getEyesSprite() {
        return this.store.getTile(this.ostore.getLayerSprite("eyes", this.eyes.getIndex(), this.outfitColor), 48, this.direction * 64, 48, 64);
    }

    private Sprite getMouthSprite() {
        return this.store.getTile(this.ostore.getLayerSprite("mouth", this.mouth.getIndex()), 48, this.direction * 64, 48, 64);
    }

    private Sprite getHeadSprite() {
        return this.store.getTile(this.ostore.getLayerSprite("head", this.head.getIndex(), this.outfitColor), 48, this.direction * 64, 48, 64);
    }

    private Sprite getBodySprite() {
        return this.store.getTile(this.ostore.getLayerSprite("body", this.body.getIndex(), this.outfitColor), 48, this.direction * 64, 48, 64);
    }

    private Sprite getDressSprite() {
        return this.store.getTile(this.ostore.getLayerSprite("dress", this.dress.getIndex(), this.outfitColor, this.body.getIndex() == 1), 48, this.direction * 64, 48, 64);
    }

    private JComponent createColorSelector(String string, String string2, OutfitLabel ... outfitLabelArray) {
        return this.createColorSelector(string, string2, false, outfitLabelArray);
    }

    private JComponent createColorSelector(String string, final String string2, boolean bl, OutfitLabel ... outfitLabelArray) {
        JComponent jComponent = SBoxLayout.createContainer(false);
        final JCheckBox jCheckBox = new JCheckBox(string + " color");
        jComponent.add(jCheckBox);
        boolean bl2 = this.outfitColor.getColor(string2) != null;
        jCheckBox.setSelected(bl2);
        AbstractColorSelector abstractColorSelector = bl ? new SkinColorSelector() : new ColorSelector();
        abstractColorSelector.setEnabled(bl2);
        abstractColorSelector.setAlignmentX(0.5f);
        jComponent.add(abstractColorSelector);
        Object t = abstractColorSelector.getSelectionModel();
        t.setSelectedColor(this.outfitColor.getColor(string2));
        t.addChangeListener(new ChangeListener((ColorSelectionModel)t, outfitLabelArray){
            final /* synthetic */ ColorSelectionModel val$model;
            final /* synthetic */ OutfitLabel[] val$labels;
            {
                this.val$model = colorSelectionModel;
                this.val$labels = outfitLabelArray;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OutfitDialog.this.outfitColor.setColor(string2, this.val$model.getSelectedColor());
                for (OutfitLabel outfitLabel : this.val$labels) {
                    outfitLabel.changed();
                }
                OutfitDialog.this.outfitLabel.changed();
            }
        });
        jCheckBox.addActionListener(new ActionListener((ColorSelectionModel)t, abstractColorSelector, outfitLabelArray){
            final /* synthetic */ ColorSelectionModel val$model;
            final /* synthetic */ AbstractColorSelector val$selector;
            final /* synthetic */ OutfitLabel[] val$labels;
            {
                this.val$model = colorSelectionModel;
                this.val$selector = abstractColorSelector;
                this.val$labels = outfitLabelArray;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBox.isSelected()) {
                    OutfitDialog.this.outfitColor.setColor(string2, this.val$model.getSelectedColor());
                } else {
                    OutfitDialog.this.outfitColor.setColor(string2, null);
                }
                this.val$selector.setEnabled(jCheckBox.isSelected());
                for (OutfitLabel outfitLabel : this.val$labels) {
                    outfitLabel.changed();
                }
                OutfitDialog.this.outfitLabel.changed();
            }
        });
        this.resetListeners.add(new ResetListener((ColorSelectionModel)t, abstractColorSelector, jCheckBox){
            final /* synthetic */ ColorSelectionModel val$model;
            final /* synthetic */ AbstractColorSelector val$selector;
            final /* synthetic */ JCheckBox val$enableToggle;
            {
                this.val$model = colorSelectionModel;
                this.val$selector = abstractColorSelector;
                this.val$enableToggle = jCheckBox;
            }

            @Override
            public void reset() {
                boolean bl;
                Color color = OutfitDialog.this.outfitColor.getColor(string2);
                boolean bl2 = bl = color != null;
                if (bl) {
                    this.val$model.setSelectedColor(color);
                }
                this.val$selector.setEnabled(bl);
                this.val$enableToggle.setSelected(bl);
            }
        });
        return jComponent;
    }

    private void okActionPerformed() {
        this.sendAction();
        this.dispose();
    }

    private void sendAction() {
        StendhalClient stendhalClient = StendhalClient.get();
        RPAction rPAction = new RPAction();
        if (StendhalClient.serverVersionAtLeast("1.31.5")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("body=" + Integer.toString(this.body.getIndex()) + ",");
            stringBuilder.append("dress=" + Integer.toString(this.dress.getIndex()) + ",");
            stringBuilder.append("head=" + Integer.toString(this.head.getIndex()) + ",");
            stringBuilder.append("mouth=" + Integer.toString(this.mouth.getIndex()) + ",");
            stringBuilder.append("eyes=" + Integer.toString(this.eyes.getIndex()) + ",");
            stringBuilder.append("mask=" + Integer.toString(this.mask.getIndex()) + ",");
            stringBuilder.append("hair=" + Integer.toString(this.hair.getIndex()) + ",");
            stringBuilder.append("hat=" + Integer.toString(this.hat.getIndex()) + ",");
            rPAction.put("type", "outfit_ext");
            rPAction.put("value", stringBuilder.toString());
        } else {
            int n = this.body.getIndex();
            n += this.dress.getIndex() * 100;
            n += this.head.getIndex() * 10000;
            rPAction.put("type", "outfit");
            rPAction.put("value", n += this.hair.getIndex() * 1000000);
        }
        Color color = this.outfitColor.getColor("hair");
        if (color != null) {
            rPAction.put("hair", color.getRGB());
        }
        if ((color = this.outfitColor.getColor("dress")) != null) {
            rPAction.put("dress", color.getRGB());
        }
        if ((color = this.outfitColor.getColor("skin")) != null) {
            rPAction.put("skin", color.getRGB());
        }
        if ((color = this.outfitColor.getColor("eyes")) != null) {
            rPAction.put("eyes", color.getRGB());
        }
        stendhalClient.send(rPAction);
    }

    private void applyStyle() {
        Style style = StyleUtil.getStyle();
        if (style != null) {
            this.bodyLabel.setBorder(style.getBorderDown());
            this.dressLabel.setBorder(style.getBorderDown());
            this.headLabel.setBorder(style.getBorderDown());
            this.mouthLabel.setBorder(style.getBorderDown());
            this.eyesLabel.setBorder(style.getBorderDown());
            this.maskLabel.setBorder(style.getBorderDown());
            this.hairLabel.setBorder(style.getBorderDown());
            this.hatLabel.setBorder(style.getBorderDown());
            this.outfitLabel.setBorder(style.getBorderDown());
        }
    }

    /*
     * WARNING - void declaration
     */
    void setState(String string, OutfitColor outfitColor) {
        void var7_12;
        Object object;
        this.outfitColor.setColor("skin", outfitColor.getColor("skin"));
        this.outfitColor.setColor("dress", outfitColor.getColor("dress"));
        this.outfitColor.setColor("eyes", outfitColor.getColor("eyes"));
        this.outfitColor.setColor("hair", outfitColor.getColor("hair"));
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String object22 : string.split(",")) {
            if (!object22.contains("=")) continue;
            object = object22.split("=");
            hashMap.put(object[0], Integer.parseInt(object[1]));
        }
        Object object3 = (Integer)hashMap.get("body");
        Integer n = (Integer)hashMap.get("dress");
        Integer n2 = (Integer)hashMap.get("head");
        Integer n3 = (Integer)hashMap.get("mouth");
        object = (Integer)hashMap.get("eyes");
        Integer n4 = (Integer)hashMap.get("mask");
        Integer n5 = (Integer)hashMap.get("hair");
        Integer n6 = (Integer)hashMap.get("hat");
        if (object3 == null) {
            object3 = 0;
        }
        if (n == null) {
            n = 0;
        }
        if (n2 == null) {
            n2 = 0;
        }
        if (n3 == null) {
            Integer n7 = 0;
        }
        if (object == null) {
            object = 0;
        }
        if (n4 == null) {
            n4 = 0;
        }
        if (n5 == null) {
            n5 = 0;
        }
        if (n6 == null) {
            n6 = 0;
        }
        this.body.setIndex((Integer)object3);
        this.dress.setIndex(n);
        this.head.setIndex(n2);
        this.mouth.setIndex(var7_12.intValue());
        this.eyes.setIndex((Integer)object);
        this.mask.setIndex(n4);
        this.hair.setIndex(n5);
        this.hat.setIndex(n6);
        for (ResetListener resetListener : this.resetListeners) {
            resetListener.reset();
        }
    }

    private static interface IndexChangeListener {
        public void changed();
    }

    private static interface SpriteRetriever {
        public Sprite getSprite();
    }

    private static class SelectorModel {
        final int n;
        int index;
        final List<IndexChangeListener> listeners = new ArrayList<IndexChangeListener>();

        SelectorModel(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Can not create a model with " + n + " elements");
            }
            this.n = n;
        }

        void addListener(IndexChangeListener indexChangeListener) {
            this.listeners.add(indexChangeListener);
        }

        void setIndex(int n) {
            if (!this.isAllowed(n)) {
                LOGGER.warn((Object)("Index out of allowed range [0-" + this.n + "]: " + n), new Throwable());
                n = 0;
            }
            this.index = n;
            this.fire();
        }

        void scrollDown() {
            this.index += this.n - 1;
            this.index %= this.n;
            this.fire();
        }

        void scrollUp() {
            ++this.index;
            this.index %= this.n;
            this.fire();
        }

        int getIndex() {
            return this.index;
        }

        boolean isAllowed(int n) {
            return n >= 0 && n < this.n;
        }

        private void fire() {
            for (IndexChangeListener indexChangeListener : this.listeners) {
                indexChangeListener.changed();
            }
        }
    }

    private static class OutfitLabel
    extends JLabel
    implements IndexChangeListener {
        final SpriteRetriever[] retrievers;

        OutfitLabel(SpriteRetriever ... spriteRetrieverArray) {
            this.setOpaque(true);
            this.retrievers = spriteRetrieverArray;
        }

        @Override
        public void changed() {
            BufferedImage bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(48, 64);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, 48, 64);
            for (SpriteRetriever spriteRetriever : this.retrievers) {
                spriteRetriever.getSprite().draw(graphics, 0, 0);
            }
            graphics.dispose();
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            this.setIcon(imageIcon);
        }
    }

    private static interface ResetListener {
        public void reset();
    }
}

