/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.entity.User;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.j2DClient;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;

class QuitDialog {
    private static final int PADDING = 10;
    private InternalManagedWindow quitDialog = this.buildQuitDialog();
    private JButton yesButton;

    Component getQuitDialog() {
        return this.quitDialog;
    }

    QuitDialog() {
        this.quitDialog.setVisible(false);
        this.quitDialog.addHierarchyBoundsListener(new ParentResizeListener());
    }

    private InternalManagedWindow buildQuitDialog() {
        JComponent jComponent = new JComponent(){};
        jComponent.setLayout(new GridLayout(1, 2, 10, 10));
        jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jComponent.setFocusCycleRoot(true);
        jComponent.setFocusTraversalPolicy(new LimitingFocusTraversalPolicy());
        this.yesButton = new JButton();
        this.yesButton.setText("Yes");
        this.yesButton.setMnemonic(89);
        this.yesButton.addActionListener(new QuitConfirmCB());
        jComponent.add(this.yesButton);
        JButton jButton = new JButton();
        jButton.setText("No");
        jButton.setMnemonic(78);
        jButton.addActionListener(new QuitCancelCB());
        jComponent.add(jButton);
        InternalManagedWindow internalManagedWindow = new InternalManagedWindow("quit", "Quit");
        internalManagedWindow.setContent(jComponent);
        internalManagedWindow.setMinimizable(false);
        internalManagedWindow.setHideOnClose(true);
        internalManagedWindow.setMovable(false);
        return internalManagedWindow;
    }

    void requestQuit(User user) {
        if (user != null && !user.stopped()) {
            user.stopMovement();
        }
        this.quitDialog.center();
        this.quitDialog.setVisible(true);
        this.yesButton.requestFocusInWindow();
    }

    private static class LimitingFocusTraversalPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private LimitingFocusTraversalPolicy() {
        }

        @Override
        public Component getFirstComponent(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray.length > 0) {
                return componentArray[0];
            }
            return null;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            Component component2 = super.getComponentBefore(container, component);
            if (component2 == container) {
                component2 = super.getLastComponent(container);
            }
            return component2;
        }
    }

    private class ParentResizeListener
    implements HierarchyBoundsListener {
        private ParentResizeListener() {
        }

        @Override
        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
        }

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            if (QuitDialog.this.quitDialog.isVisible() && hierarchyEvent.getChanged().equals(QuitDialog.this.quitDialog.getParent())) {
                QuitDialog.this.quitDialog.center();
            }
        }
    }

    private static class QuitConfirmCB
    implements ActionListener {
        private QuitConfirmCB() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            j2DClient.get().shutdown();
        }
    }

    private class QuitCancelCB
    implements ActionListener {
        private QuitCancelCB() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QuitDialog.this.quitDialog.setVisible(false);
        }
    }
}

